/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.field.business.type;

import com.liferay.dynamic.data.mapping.expression.CreateExpressionRequest;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionException;
import com.liferay.dynamic.data.mapping.expression.DDMExpressionFactory;
import com.liferay.object.field.business.type.ObjectFieldBusinessType;
import com.liferay.object.field.render.ObjectFieldRenderingContext;
import com.liferay.object.model.ObjectField;
import com.liferay.object.model.ObjectFieldSetting;
import com.liferay.object.service.ObjectFieldSettingLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.scripting.ScriptingException;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.vulcan.extension.PropertyDefinition;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"object.field.business.type.key=Formula"}, service={FormulaObjectFieldBusinessType.class, ObjectFieldBusinessType.class})
public class FormulaObjectFieldBusinessType
implements ObjectFieldBusinessType {
    @Reference
    private DDMExpressionFactory _ddmExpressionFactory;
    @Reference
    private Language _language;
    @Reference
    private ObjectFieldSettingLocalService _objectFieldSettingLocalService;

    public Set<String> getAllowedObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"output", "script"});
    }

    public String getDBType() {
        return "String";
    }

    public String getDDMFormFieldTypeName() {
        return "text";
    }

    public String getDescription(Locale locale) {
        return this._language.get(locale, "add-an-algorithm-that-derives-its-value-from-other-fields");
    }

    public String getLabel(Locale locale) {
        return this._language.get(locale, "formula");
    }

    public String getName() {
        return "Formula";
    }

    public Map<String, Object> getProperties(ObjectField objectField, ObjectFieldRenderingContext objectFieldRenderingContext) throws PortalException {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ListUtil.isNotEmptyForEach((List)this._objectFieldSettingLocalService.getObjectFieldObjectFieldSettings(objectField.getObjectFieldId()), objectFieldSetting -> properties.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        return properties;
    }

    public PropertyDefinition.PropertyType getPropertyType() {
        return PropertyDefinition.PropertyType.TEXT;
    }

    public Set<String> getRequiredObjectFieldSettingsNames() {
        return SetUtil.fromArray((Object[])new String[]{"output"});
    }

    public void validateObjectFieldSettings(long objectDefinitionId, String objectFieldName, List<ObjectFieldSetting> objectFieldSettings) throws PortalException {
        super.validateObjectFieldSettings(objectDefinitionId, objectFieldName, objectFieldSettings);
        HashMap objectFieldSettingsValues = new HashMap();
        objectFieldSettings.forEach(objectFieldSetting -> objectFieldSettingsValues.put(objectFieldSetting.getName(), objectFieldSetting.getValue()));
        String script = (String)objectFieldSettingsValues.get("script");
        if (script == null) {
            return;
        }
        try {
            this._ddmExpressionFactory.createExpression(CreateExpressionRequest.Builder.newBuilder((String)script).build());
        }
        catch (DDMExpressionException ddmExpressionException) {
            throw new ScriptingException((Throwable)ddmExpressionException);
        }
    }
}

