/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.persistence.impl;

import com.liferay.object.exception.NoSuchObjectEntryException;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectEntryTable;
import com.liferay.object.model.impl.ObjectEntryImpl;
import com.liferay.object.model.impl.ObjectEntryModelImpl;
import com.liferay.object.service.persistence.ObjectEntryPersistence;
import com.liferay.object.service.persistence.impl.ObjectEntryModelArgumentsResolver;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ObjectEntryPersistence.class, BasePersistence.class})
public class ObjectEntryPersistenceImpl
extends BasePersistenceImpl<ObjectEntry>
implements ObjectEntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = ObjectEntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUuid;
    private FinderPath _finderPathWithoutPaginationFindByUuid;
    private FinderPath _finderPathCountByUuid;
    private static final String _FINDER_COLUMN_UUID_UUID_2 = "objectEntry.uuid = ?";
    private static final String _FINDER_COLUMN_UUID_UUID_3 = "(objectEntry.uuid IS NULL OR objectEntry.uuid = '')";
    private FinderPath _finderPathFetchByUUID_G;
    private FinderPath _finderPathCountByUUID_G;
    private static final String _FINDER_COLUMN_UUID_G_UUID_2 = "objectEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_G_UUID_3 = "(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_G_GROUPID_2 = "objectEntry.groupId = ?";
    private FinderPath _finderPathWithPaginationFindByUuid_C;
    private FinderPath _finderPathWithoutPaginationFindByUuid_C;
    private FinderPath _finderPathCountByUuid_C;
    private static final String _FINDER_COLUMN_UUID_C_UUID_2 = "objectEntry.uuid = ? AND ";
    private static final String _FINDER_COLUMN_UUID_C_UUID_3 = "(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ";
    private static final String _FINDER_COLUMN_UUID_C_COMPANYID_2 = "objectEntry.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByObjectDefinitionId;
    private FinderPath _finderPathWithoutPaginationFindByObjectDefinitionId;
    private FinderPath _finderPathCountByObjectDefinitionId;
    private static final String _FINDER_COLUMN_OBJECTDEFINITIONID_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ?";
    private FinderPath _finderPathWithPaginationFindByG_ODI;
    private FinderPath _finderPathWithoutPaginationFindByG_ODI;
    private FinderPath _finderPathCountByG_ODI;
    private static final String _FINDER_COLUMN_G_ODI_GROUPID_2 = "objectEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_ODI_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ?";
    private FinderPath _finderPathWithPaginationFindByODI_NotS;
    private FinderPath _finderPathWithPaginationCountByODI_NotS;
    private static final String _FINDER_COLUMN_ODI_NOTS_OBJECTDEFINITIONID_2 = "objectEntry.objectDefinitionId = ? AND ";
    private static final String _FINDER_COLUMN_ODI_NOTS_STATUS_2 = "objectEntry.status != ?";
    private FinderPath _finderPathFetchByG_C_ERC;
    private FinderPath _finderPathCountByG_C_ERC;
    private static final String _FINDER_COLUMN_G_C_ERC_GROUPID_2 = "objectEntry.groupId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_ERC_COMPANYID_2 = "objectEntry.companyId = ? AND ";
    private static final String _FINDER_COLUMN_G_C_ERC_EXTERNALREFERENCECODE_2 = "objectEntry.externalReferenceCode = ?";
    private static final String _FINDER_COLUMN_G_C_ERC_EXTERNALREFERENCECODE_3 = "(objectEntry.externalReferenceCode IS NULL OR objectEntry.externalReferenceCode = '')";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OBJECTENTRY = "SELECT objectEntry FROM ObjectEntry objectEntry";
    private static final String _SQL_SELECT_OBJECTENTRY_WHERE = "SELECT objectEntry FROM ObjectEntry objectEntry WHERE ";
    private static final String _SQL_COUNT_OBJECTENTRY = "SELECT COUNT(objectEntry) FROM ObjectEntry objectEntry";
    private static final String _SQL_COUNT_OBJECTENTRY_WHERE = "SELECT COUNT(objectEntry) FROM ObjectEntry objectEntry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "objectEntry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No ObjectEntry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No ObjectEntry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(ObjectEntryPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"uuid"});
    @Reference
    private ObjectEntryModelArgumentsResolver _objectEntryModelArgumentsResolver;

    public List<ObjectEntry> findByUuid(String uuid) {
        return this.findByUuid(uuid, -1, -1, null);
    }

    public List<ObjectEntry> findByUuid(String uuid, int start, int end) {
        return this.findByUuid(uuid, start, end, null);
    }

    public List<ObjectEntry> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByUuid(uuid, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByUuid(String uuid, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid;
                finderArgs = new Object[]{uuid};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid;
            finderArgs = new Object[]{uuid, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (uuid.equals(objectEntry.getUuid())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByUuid_First(String uuid, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_First(uuid, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_First(String uuid, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByUuid(uuid, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByUuid_Last(String uuid, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_Last(uuid, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_Last(String uuid, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByUuid(uuid);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByUuid(uuid, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByUuid_PrevAndNext(long objectEntryId, String uuid, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        uuid = Objects.toString(uuid, "");
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByUuid_PrevAndNext(session, objectEntry, uuid, orderByComparator, true), objectEntry, this.getByUuid_PrevAndNext(session, objectEntry, uuid, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByUuid_PrevAndNext(Session session, ObjectEntry objectEntry, String uuid, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append(_FINDER_COLUMN_UUID_UUID_3);
        } else {
            bindUuid = true;
            sb.append(_FINDER_COLUMN_UUID_UUID_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid(String uuid) {
        for (ObjectEntry objectEntry : this.findByUuid(uuid, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByUuid(String uuid) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid;
        Object[] finderArgs = new Object[]{uuid};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append(_FINDER_COLUMN_UUID_UUID_3);
            } else {
                bindUuid = true;
                sb.append(_FINDER_COLUMN_UUID_UUID_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectEntry findByUUID_G(String uuid, long groupId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUUID_G(uuid, groupId);
        if (objectEntry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("uuid=");
            sb.append(uuid);
            sb.append(", groupId=");
            sb.append(groupId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchObjectEntryException(sb.toString());
        }
        return objectEntry;
    }

    public ObjectEntry fetchByUUID_G(String uuid, long groupId) {
        return this.fetchByUUID_G(uuid, groupId, true);
    }

    public ObjectEntry fetchByUUID_G(String uuid, long groupId, boolean useFinderCache) {
        ObjectEntry objectEntry;
        uuid = Objects.toString(uuid, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{uuid, groupId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByUUID_G, finderArgs);
        }
        if (result instanceof ObjectEntry && (!Objects.equals(uuid, (objectEntry = (ObjectEntry)result).getUuid()) || groupId != objectEntry.getGroupId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("objectEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByUUID_G, finderArgs, (Object)list);
                    }
                } else {
                    ObjectEntry objectEntry2 = (ObjectEntry)list.get(0);
                    result = objectEntry2;
                    this.cacheResult(objectEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ObjectEntry)result;
    }

    public ObjectEntry removeByUUID_G(String uuid, long groupId) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByUUID_G(uuid, groupId);
        return (ObjectEntry)this.remove((BaseModel)objectEntry);
    }

    public int countByUUID_G(String uuid, long groupId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUUID_G;
        Object[] finderArgs = new Object[]{uuid, groupId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("objectEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_G_GROUPID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(groupId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId) {
        return this.findByUuid_C(uuid, companyId, -1, -1, null);
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId, int start, int end) {
        return this.findByUuid_C(uuid, companyId, start, end, null);
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByUuid_C(uuid, companyId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByUuid_C(String uuid, long companyId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUuid_C;
                finderArgs = new Object[]{uuid, companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUuid_C;
            finderArgs = new Object[]{uuid, companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (uuid.equals(objectEntry.getUuid()) && companyId == objectEntry.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("objectEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_C_First(uuid, companyId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_C_First(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByUuid_C(uuid, companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByUuid_C_Last(uuid, companyId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("uuid=");
        sb.append(uuid);
        sb.append(", companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByUuid_C_Last(String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByUuid_C(uuid, companyId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByUuid_C(uuid, companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByUuid_C_PrevAndNext(long objectEntryId, String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        uuid = Objects.toString(uuid, "");
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByUuid_C_PrevAndNext(session, objectEntry, uuid, companyId, orderByComparator, true), objectEntry, this.getByUuid_C_PrevAndNext(session, objectEntry, uuid, companyId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByUuid_C_PrevAndNext(Session session, ObjectEntry objectEntry, String uuid, long companyId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        boolean bindUuid = false;
        if (uuid.isEmpty()) {
            sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
        } else {
            bindUuid = true;
            sb.append("objectEntry.uuid = ? AND ");
        }
        sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        if (bindUuid) {
            queryPos.add(uuid);
        }
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByUuid_C(String uuid, long companyId) {
        for (ObjectEntry objectEntry : this.findByUuid_C(uuid, companyId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByUuid_C(String uuid, long companyId) {
        uuid = Objects.toString(uuid, "");
        FinderPath finderPath = this._finderPathCountByUuid_C;
        Object[] finderArgs = new Object[]{uuid, companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            boolean bindUuid = false;
            if (uuid.isEmpty()) {
                sb.append("(objectEntry.uuid IS NULL OR objectEntry.uuid = '') AND ");
            } else {
                bindUuid = true;
                sb.append("objectEntry.uuid = ? AND ");
            }
            sb.append(_FINDER_COLUMN_UUID_C_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindUuid) {
                    queryPos.add(uuid);
                }
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId) {
        return this.findByObjectDefinitionId(objectDefinitionId, -1, -1, null);
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId, int start, int end) {
        return this.findByObjectDefinitionId(objectDefinitionId, start, end, null);
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByObjectDefinitionId(objectDefinitionId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByObjectDefinitionId(long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByObjectDefinitionId;
                finderArgs = new Object[]{objectDefinitionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByObjectDefinitionId;
            finderArgs = new Object[]{objectDefinitionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (objectDefinitionId == objectEntry.getObjectDefinitionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.objectDefinitionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByObjectDefinitionId_First(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByObjectDefinitionId_First(objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByObjectDefinitionId_First(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByObjectDefinitionId(objectDefinitionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByObjectDefinitionId_Last(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByObjectDefinitionId_Last(objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByObjectDefinitionId_Last(long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByObjectDefinitionId(objectDefinitionId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByObjectDefinitionId(objectDefinitionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByObjectDefinitionId_PrevAndNext(long objectEntryId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByObjectDefinitionId_PrevAndNext(session, objectEntry, objectDefinitionId, orderByComparator, true), objectEntry, this.getByObjectDefinitionId_PrevAndNext(session, objectEntry, objectDefinitionId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByObjectDefinitionId_PrevAndNext(Session session, ObjectEntry objectEntry, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.objectDefinitionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(objectDefinitionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByObjectDefinitionId(long objectDefinitionId) {
        for (ObjectEntry objectEntry : this.findByObjectDefinitionId(objectDefinitionId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByObjectDefinitionId(long objectDefinitionId) {
        FinderPath finderPath = this._finderPathCountByObjectDefinitionId;
        Object[] finderArgs = new Object[]{objectDefinitionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.objectDefinitionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId) {
        return this.findByG_ODI(groupId, objectDefinitionId, -1, -1, null);
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId, int start, int end) {
        return this.findByG_ODI(groupId, objectDefinitionId, start, end, null);
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByG_ODI(groupId, objectDefinitionId, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByG_ODI(long groupId, long objectDefinitionId, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByG_ODI;
                finderArgs = new Object[]{groupId, objectDefinitionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByG_ODI;
            finderArgs = new Object[]{groupId, objectDefinitionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (groupId == objectEntry.getGroupId() && objectDefinitionId == objectEntry.getObjectDefinitionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectDefinitionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByG_ODI_First(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_ODI_First(groupId, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_ODI_First(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByG_ODI(groupId, objectDefinitionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByG_ODI_Last(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_ODI_Last(groupId, objectDefinitionId, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("groupId=");
        sb.append(groupId);
        sb.append(", objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByG_ODI_Last(long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByG_ODI(groupId, objectDefinitionId);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByG_ODI(groupId, objectDefinitionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByG_ODI_PrevAndNext(long objectEntryId, long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByG_ODI_PrevAndNext(session, objectEntry, groupId, objectDefinitionId, orderByComparator, true), objectEntry, this.getByG_ODI_PrevAndNext(session, objectEntry, groupId, objectDefinitionId, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByG_ODI_PrevAndNext(Session session, ObjectEntry objectEntry, long groupId, long objectDefinitionId, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append("objectEntry.groupId = ? AND ");
        sb.append("objectEntry.objectDefinitionId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(groupId);
        queryPos.add(objectDefinitionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByG_ODI(long groupId, long objectDefinitionId) {
        for (ObjectEntry objectEntry : this.findByG_ODI(groupId, objectDefinitionId, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByG_ODI(long groupId, long objectDefinitionId) {
        FinderPath finderPath = this._finderPathCountByG_ODI;
        Object[] finderArgs = new Object[]{groupId, objectDefinitionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append("objectEntry.objectDefinitionId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(objectDefinitionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status) {
        return this.findByODI_NotS(objectDefinitionId, status, -1, -1, null);
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status, int start, int end) {
        return this.findByODI_NotS(objectDefinitionId, status, start, end, null);
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status, int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findByODI_NotS(objectDefinitionId, status, start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findByODI_NotS(long objectDefinitionId, int status, int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByODI_NotS;
        finderArgs = new Object[]{objectDefinitionId, status, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs)) != null && !list.isEmpty()) {
            for (ObjectEntry objectEntry : list) {
                if (objectDefinitionId == objectEntry.getObjectDefinitionId() && status != objectEntry.getStatus()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_ODI_NOTS_OBJECTDEFINITIONID_2);
            sb.append(_FINDER_COLUMN_ODI_NOTS_STATUS_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY objectEntry.objectEntryId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                queryPos.add(status);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public ObjectEntry findByODI_NotS_First(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByODI_NotS_First(objectDefinitionId, status, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", status!=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByODI_NotS_First(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) {
        List<ObjectEntry> list = this.findByODI_NotS(objectDefinitionId, status, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry findByODI_NotS_Last(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByODI_NotS_Last(objectDefinitionId, status, orderByComparator);
        if (objectEntry != null) {
            return objectEntry;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("objectDefinitionId=");
        sb.append(objectDefinitionId);
        sb.append(", status!=");
        sb.append(status);
        sb.append("}");
        throw new NoSuchObjectEntryException(sb.toString());
    }

    public ObjectEntry fetchByODI_NotS_Last(long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) {
        int count = this.countByODI_NotS(objectDefinitionId, status);
        if (count == 0) {
            return null;
        }
        List<ObjectEntry> list = this.findByODI_NotS(objectDefinitionId, status, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public ObjectEntry[] findByODI_NotS_PrevAndNext(long objectEntryId, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByPrimaryKey(objectEntryId);
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry[] array = new ObjectEntryImpl[]{this.getByODI_NotS_PrevAndNext(session, objectEntry, objectDefinitionId, status, orderByComparator, true), objectEntry, this.getByODI_NotS_PrevAndNext(session, objectEntry, objectDefinitionId, status, orderByComparator, false)};
            ObjectEntry[] objectEntryArray = array;
            return objectEntryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry getByODI_NotS_PrevAndNext(Session session, ObjectEntry objectEntry, long objectDefinitionId, int status, OrderByComparator<ObjectEntry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
        sb.append(_FINDER_COLUMN_ODI_NOTS_OBJECTDEFINITIONID_2);
        sb.append(_FINDER_COLUMN_ODI_NOTS_STATUS_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY objectEntry.objectEntryId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(objectDefinitionId);
        queryPos.add(status);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)objectEntry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (ObjectEntry)list.get(1);
        }
        return null;
    }

    public void removeByODI_NotS(long objectDefinitionId, int status) {
        for (ObjectEntry objectEntry : this.findByODI_NotS(objectDefinitionId, status, -1, -1, null)) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countByODI_NotS(long objectDefinitionId, int status) {
        FinderPath finderPath = this._finderPathWithPaginationCountByODI_NotS;
        Object[] finderArgs = new Object[]{objectDefinitionId, status};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append(_FINDER_COLUMN_ODI_NOTS_OBJECTDEFINITIONID_2);
            sb.append(_FINDER_COLUMN_ODI_NOTS_STATUS_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(objectDefinitionId);
                queryPos.add(status);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectEntry findByG_C_ERC(long groupId, long companyId, String externalReferenceCode) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.fetchByG_C_ERC(groupId, companyId, externalReferenceCode);
        if (objectEntry == null) {
            StringBundler sb = new StringBundler(8);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("groupId=");
            sb.append(groupId);
            sb.append(", companyId=");
            sb.append(companyId);
            sb.append(", externalReferenceCode=");
            sb.append(externalReferenceCode);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchObjectEntryException(sb.toString());
        }
        return objectEntry;
    }

    public ObjectEntry fetchByG_C_ERC(long groupId, long companyId, String externalReferenceCode) {
        return this.fetchByG_C_ERC(groupId, companyId, externalReferenceCode, true);
    }

    public ObjectEntry fetchByG_C_ERC(long groupId, long companyId, String externalReferenceCode, boolean useFinderCache) {
        ObjectEntry objectEntry;
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{groupId, companyId, externalReferenceCode};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByG_C_ERC, finderArgs);
        }
        if (result instanceof ObjectEntry && (groupId != (objectEntry = (ObjectEntry)result).getGroupId() || companyId != objectEntry.getCompanyId() || !Objects.equals(externalReferenceCode, objectEntry.getExternalReferenceCode()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_SELECT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_G_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByG_C_ERC, finderArgs, (Object)list);
                    }
                } else {
                    if (list.size() > 1) {
                        Collections.sort(list, Collections.reverseOrder());
                        if (_log.isWarnEnabled()) {
                            if (!useFinderCache) {
                                finderArgs = new Object[]{groupId, companyId, externalReferenceCode};
                            }
                            _log.warn((Object)("ObjectEntryPersistenceImpl.fetchByG_C_ERC(long, long, String, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                        }
                    }
                    ObjectEntry objectEntry2 = (ObjectEntry)list.get(0);
                    result = objectEntry2;
                    this.cacheResult(objectEntry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (ObjectEntry)result;
    }

    public ObjectEntry removeByG_C_ERC(long groupId, long companyId, String externalReferenceCode) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = this.findByG_C_ERC(groupId, companyId, externalReferenceCode);
        return (ObjectEntry)this.remove((BaseModel)objectEntry);
    }

    public int countByG_C_ERC(long groupId, long companyId, String externalReferenceCode) {
        externalReferenceCode = Objects.toString(externalReferenceCode, "");
        FinderPath finderPath = this._finderPathCountByG_C_ERC;
        Object[] finderArgs = new Object[]{groupId, companyId, externalReferenceCode};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_OBJECTENTRY_WHERE);
            sb.append("objectEntry.groupId = ? AND ");
            sb.append(_FINDER_COLUMN_G_C_ERC_COMPANYID_2);
            boolean bindExternalReferenceCode = false;
            if (externalReferenceCode.isEmpty()) {
                sb.append(_FINDER_COLUMN_G_C_ERC_EXTERNALREFERENCECODE_3);
            } else {
                bindExternalReferenceCode = true;
                sb.append(_FINDER_COLUMN_G_C_ERC_EXTERNALREFERENCECODE_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(groupId);
                queryPos.add(companyId);
                if (bindExternalReferenceCode) {
                    queryPos.add(externalReferenceCode);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public ObjectEntryPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("uuid", "uuid_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(ObjectEntry.class);
        this.setModelImplClass(ObjectEntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)ObjectEntryTable.INSTANCE);
    }

    public void cacheResult(ObjectEntry objectEntry) {
        this.entityCache.putResult(ObjectEntryImpl.class, (Serializable)Long.valueOf(objectEntry.getPrimaryKey()), (Serializable)objectEntry);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, new Object[]{objectEntry.getUuid(), objectEntry.getGroupId()}, (Object)objectEntry);
        this.finderCache.putResult(this._finderPathFetchByG_C_ERC, new Object[]{objectEntry.getGroupId(), objectEntry.getCompanyId(), objectEntry.getExternalReferenceCode()}, (Object)objectEntry);
    }

    public void cacheResult(List<ObjectEntry> objectEntries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && objectEntries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (ObjectEntry objectEntry : objectEntries) {
            ObjectEntry cachedObjectEntry = (ObjectEntry)this.entityCache.getResult(ObjectEntryImpl.class, (Serializable)Long.valueOf(objectEntry.getPrimaryKey()));
            if (cachedObjectEntry == null) {
                this.cacheResult(objectEntry);
                continue;
            }
            ObjectEntryModelImpl objectEntryModelImpl = (ObjectEntryModelImpl)objectEntry;
            ObjectEntryModelImpl cachedObjectEntryModelImpl = (ObjectEntryModelImpl)cachedObjectEntry;
            objectEntryModelImpl.setValues(cachedObjectEntryModelImpl.getValues());
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(ObjectEntryImpl.class);
        this.finderCache.clearCache(ObjectEntryImpl.class);
    }

    public void clearCache(ObjectEntry objectEntry) {
        this.entityCache.removeResult(ObjectEntryImpl.class, (BaseModel)objectEntry);
    }

    public void clearCache(List<ObjectEntry> objectEntries) {
        for (ObjectEntry objectEntry : objectEntries) {
            this.entityCache.removeResult(ObjectEntryImpl.class, (BaseModel)objectEntry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(ObjectEntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(ObjectEntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(ObjectEntryModelImpl objectEntryModelImpl) {
        Object[] args = new Object[]{objectEntryModelImpl.getUuid(), objectEntryModelImpl.getGroupId()};
        this.finderCache.putResult(this._finderPathCountByUUID_G, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByUUID_G, args, (Object)objectEntryModelImpl);
        args = new Object[]{objectEntryModelImpl.getGroupId(), objectEntryModelImpl.getCompanyId(), objectEntryModelImpl.getExternalReferenceCode()};
        this.finderCache.putResult(this._finderPathCountByG_C_ERC, args, (Object)1L);
        this.finderCache.putResult(this._finderPathFetchByG_C_ERC, args, (Object)objectEntryModelImpl);
    }

    public ObjectEntry create(long objectEntryId) {
        ObjectEntryImpl objectEntry = new ObjectEntryImpl();
        objectEntry.setNew(true);
        objectEntry.setPrimaryKey(objectEntryId);
        String uuid = PortalUUIDUtil.generate();
        objectEntry.setUuid(uuid);
        objectEntry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return objectEntry;
    }

    public ObjectEntry remove(long objectEntryId) throws NoSuchObjectEntryException {
        return this.remove(Long.valueOf(objectEntryId));
    }

    public ObjectEntry remove(Serializable primaryKey) throws NoSuchObjectEntryException {
        Session session = null;
        try {
            session = this.openSession();
            ObjectEntry objectEntry = (ObjectEntry)session.get(ObjectEntryImpl.class, primaryKey);
            if (objectEntry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchObjectEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            ObjectEntry objectEntry2 = (ObjectEntry)this.remove((BaseModel)objectEntry);
            return objectEntry2;
        }
        catch (NoSuchObjectEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected ObjectEntry removeImpl(ObjectEntry objectEntry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)objectEntry)) {
                objectEntry = (ObjectEntry)session.get(ObjectEntryImpl.class, objectEntry.getPrimaryKeyObj());
            }
            if (objectEntry != null) {
                session.delete((Object)objectEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (objectEntry != null) {
            this.clearCache(objectEntry);
        }
        return objectEntry;
    }

    public ObjectEntry updateImpl(ObjectEntry objectEntry) {
        boolean isNew = objectEntry.isNew();
        if (!(objectEntry instanceof ObjectEntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(objectEntry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)objectEntry);
                throw new IllegalArgumentException("Implement ModelWrapper in objectEntry proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom ObjectEntry implementation " + objectEntry.getClass());
        }
        ObjectEntryModelImpl objectEntryModelImpl = (ObjectEntryModelImpl)objectEntry;
        if (Validator.isNull((String)objectEntry.getUuid())) {
            String uuid = PortalUUIDUtil.generate();
            objectEntry.setUuid(uuid);
        }
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && objectEntry.getCreateDate() == null) {
            if (serviceContext == null) {
                objectEntry.setCreateDate(date);
            } else {
                objectEntry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!objectEntryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                objectEntry.setModifiedDate(date);
            } else {
                objectEntry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)objectEntry);
            } else {
                objectEntry = (ObjectEntry)session.merge((Object)objectEntry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(ObjectEntryImpl.class, (BaseModel)objectEntryModelImpl, false, true);
        this.cacheUniqueFindersCache(objectEntryModelImpl);
        if (isNew) {
            objectEntry.setNew(false);
        }
        objectEntry.resetOriginalValues();
        return objectEntry;
    }

    public ObjectEntry findByPrimaryKey(Serializable primaryKey) throws NoSuchObjectEntryException {
        ObjectEntry objectEntry = (ObjectEntry)this.fetchByPrimaryKey(primaryKey);
        if (objectEntry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchObjectEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return objectEntry;
    }

    public ObjectEntry findByPrimaryKey(long objectEntryId) throws NoSuchObjectEntryException {
        return this.findByPrimaryKey(Long.valueOf(objectEntryId));
    }

    public ObjectEntry fetchByPrimaryKey(long objectEntryId) {
        return (ObjectEntry)this.fetchByPrimaryKey(Long.valueOf(objectEntryId));
    }

    public List<ObjectEntry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<ObjectEntry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<ObjectEntry> findAll(int start, int end, OrderByComparator<ObjectEntry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<ObjectEntry> findAll(int start, int end, OrderByComparator<ObjectEntry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OBJECTENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OBJECTENTRY;
                sql = sql.concat(" ORDER BY objectEntry.objectEntryId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (ObjectEntry objectEntry : this.findAll()) {
            this.remove((BaseModel)objectEntry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OBJECTENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "objectEntryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OBJECTENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return ObjectEntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid", new String[]{String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathWithoutPaginationFindByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, true);
        this._finderPathCountByUuid = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid", new String[]{String.class.getName()}, new String[]{"uuid_"}, false);
        this._finderPathFetchByUUID_G = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, true);
        this._finderPathCountByUUID_G = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUUID_G", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "groupId"}, false);
        this._finderPathWithPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathWithoutPaginationFindByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, true);
        this._finderPathCountByUuid_C = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUuid_C", new String[]{String.class.getName(), Long.class.getName()}, new String[]{"uuid_", "companyId"}, false);
        this._finderPathWithPaginationFindByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByObjectDefinitionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"objectDefinitionId"}, true);
        this._finderPathWithoutPaginationFindByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByObjectDefinitionId", new String[]{Long.class.getName()}, new String[]{"objectDefinitionId"}, true);
        this._finderPathCountByObjectDefinitionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByObjectDefinitionId", new String[]{Long.class.getName()}, new String[]{"objectDefinitionId"}, false);
        this._finderPathWithPaginationFindByG_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByG_ODI", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"groupId", "objectDefinitionId"}, true);
        this._finderPathWithoutPaginationFindByG_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByG_ODI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "objectDefinitionId"}, true);
        this._finderPathCountByG_ODI = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_ODI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"groupId", "objectDefinitionId"}, false);
        this._finderPathWithPaginationFindByODI_NotS = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByODI_NotS", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"objectDefinitionId", "status"}, true);
        this._finderPathWithPaginationCountByODI_NotS = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByODI_NotS", new String[]{Long.class.getName(), Integer.class.getName()}, new String[]{"objectDefinitionId", "status"}, false);
        this._finderPathFetchByG_C_ERC = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByG_C_ERC", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, new String[]{"groupId", "companyId", "externalReferenceCode"}, true);
        this._finderPathCountByG_C_ERC = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByG_C_ERC", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, new String[]{"groupId", "companyId", "externalReferenceCode"}, false);
    }

    @Deactivate
    public void deactivate() {
        this.entityCache.removeCache(ObjectEntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.object.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.object.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

