/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.base.ObjectEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectEntry"}, service={AopService.class})
public class ObjectEntryServiceImpl
extends ObjectEntryServiceBaseImpl {
    private final Map<String, ModelResourcePermission<ObjectEntry>> _modelResourcePermissions = new ConcurrentHashMap<String, ModelResourcePermission<ObjectEntry>>();
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    private final Map<String, PortletResourcePermission> _portletResourcePermissions = new ConcurrentHashMap<String, PortletResourcePermission>();

    public ObjectEntry addObjectEntry(long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        this._checkPortletResourcePermission(groupId, objectDefinitionId, "ADD_OBJECT_ENTRY");
        return this.objectEntryLocalService.addObjectEntry(this.getUserId(), groupId, objectDefinitionId, values, serviceContext);
    }

    public ObjectEntry addOrUpdateObjectEntry(String externalReferenceCode, long groupId, long objectDefinitionId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryPersistence.fetchByG_C_ERC(groupId, serviceContext.getCompanyId(), externalReferenceCode);
        if (objectEntry == null) {
            this._checkPortletResourcePermission(groupId, objectDefinitionId, "ADD_OBJECT_ENTRY");
        } else {
            this._checkModelResourcePermission(objectDefinitionId, objectEntry.getObjectEntryId(), "UPDATE");
        }
        return this.objectEntryLocalService.addOrUpdateObjectEntry(externalReferenceCode, this.getUserId(), groupId, objectDefinitionId, values, serviceContext);
    }

    public ObjectEntry deleteObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "DELETE");
        return this.objectEntryLocalService.deleteObjectEntry(objectEntryId);
    }

    public ObjectEntry fetchObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.fetchObjectEntry(objectEntryId);
        if (objectEntry != null) {
            this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
        }
        return objectEntry;
    }

    public ObjectEntry getObjectEntry(long objectEntryId) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "VIEW");
        return objectEntry;
    }

    public ObjectEntry updateObjectEntry(long objectEntryId, Map<String, Serializable> values, ServiceContext serviceContext) throws PortalException {
        ObjectEntry objectEntry = this.objectEntryLocalService.getObjectEntry(objectEntryId);
        this._checkModelResourcePermission(objectEntry.getObjectDefinitionId(), objectEntry.getObjectEntryId(), "UPDATE");
        return this.objectEntryLocalService.updateObjectEntry(this.getUserId(), objectEntryId, values, serviceContext);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(com.liferay.object=true)(model.class.name=*))")
    protected void setModelResourcePermission(ModelResourcePermission<ObjectEntry> modelResourcePermission, Map<String, Object> properties) {
        String className = (String)properties.get("model.class.name");
        this._modelResourcePermissions.put(className, modelResourcePermission);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(&(com.liferay.object=true)(resource.name=*))")
    protected void setPortletResourcePermission(PortletResourcePermission portletResourcePermission, Map<String, Object> properties) {
        String resourceName = (String)properties.get("resource.name");
        this._portletResourcePermissions.put(resourceName, portletResourcePermission);
    }

    protected void unsetModelResourcePermission(ModelResourcePermission<ObjectEntry> modelResourcePermission, Map<String, Object> properties) {
        String className = (String)properties.get("model.class.name");
        this._modelResourcePermissions.remove(className);
    }

    protected void unsetPortletResourcePermission(PortletResourcePermission portletResourcePermission, Map<String, Object> properties) {
        String resourceName = (String)properties.get("resource.name");
        this._portletResourcePermissions.remove(resourceName);
    }

    private void _checkModelResourcePermission(long objectDefinitionId, long objectEntryId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        ModelResourcePermission<ObjectEntry> modelResourcePermission = this._modelResourcePermissions.get(objectDefinition.getClassName());
        modelResourcePermission.check(this.getPermissionChecker(), objectEntryId, actionId);
    }

    private void _checkPortletResourcePermission(long groupId, long objectDefinitionId, String actionId) throws PortalException {
        ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
        PortletResourcePermission portletResourcePermission = this._portletResourcePermissions.get(objectDefinition.getResourceName());
        portletResourcePermission.check(this.getPermissionChecker(), groupId, actionId);
    }
}

