/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.service.impl;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectField;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.base.ObjectDefinitionServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=object", "json.web.service.context.path=ObjectDefinition"}, service={AopService.class})
public class ObjectDefinitionServiceImpl
extends ObjectDefinitionServiceBaseImpl {
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference(target="(model.class.name=com.liferay.object.model.ObjectDefinition)")
    private ModelResourcePermission<ObjectDefinition> _objectDefinitionModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.object)")
    private PortletResourcePermission _portletResourcePermission;

    public ObjectDefinition addCustomObjectDefinition(Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, String scope, List<ObjectField> objectFields) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_OBJECT_DEFINITION");
        return this._objectDefinitionLocalService.addCustomObjectDefinition(this.getUserId(), labelMap, name, panelAppOrder, panelCategoryKey, pluralLabelMap, scope, objectFields);
    }

    public ObjectDefinition deleteObjectDefinition(long objectDefinitionId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "DELETE");
        return this._objectDefinitionLocalService.deleteObjectDefinition(objectDefinitionId);
    }

    public ObjectDefinition getObjectDefinition(long objectDefinitionId) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId, "VIEW");
        return this._objectDefinitionLocalService.getObjectDefinition(objectDefinitionId);
    }

    public List<ObjectDefinition> getObjectDefinitions(int start, int end) {
        return this._objectDefinitionLocalService.getObjectDefinitions(start, end);
    }

    public List<ObjectDefinition> getObjectDefinitions(long companyId, int start, int end) {
        return this.objectDefinitionPersistence.findByCompanyId(companyId, start, end);
    }

    public int getObjectDefinitionsCount() throws PortalException {
        return this._objectDefinitionLocalService.getObjectDefinitionsCount();
    }

    public int getObjectDefinitionsCount(long companyId) throws PortalException {
        return this._objectDefinitionLocalService.getObjectDefinitionsCount(companyId);
    }

    public ObjectDefinition publishCustomObjectDefinition(long objectDefinitionId) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "PUBLISH_OBJECT_DEFINITION");
        return this._objectDefinitionLocalService.publishCustomObjectDefinition(this.getUserId(), objectDefinitionId);
    }

    public ObjectDefinition updateCustomObjectDefinition(Long objectDefinitionId, long descriptionObjectFieldId, long titleObjectFieldId, boolean active, Map<Locale, String> labelMap, String name, String panelAppOrder, String panelCategoryKey, Map<Locale, String> pluralLabelMap, String scope) throws PortalException {
        this._objectDefinitionModelResourcePermission.check(this.getPermissionChecker(), objectDefinitionId.longValue(), "UPDATE");
        return this._objectDefinitionLocalService.updateCustomObjectDefinition(objectDefinitionId, descriptionObjectFieldId, titleObjectFieldId, active, labelMap, name, panelAppOrder, panelCategoryKey, pluralLabelMap, scope);
    }
}

