/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.security.permission.resource;

import com.liferay.object.model.ObjectEntry;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;

public class ObjectEntryModelResourcePermission
implements ModelResourcePermission<ObjectEntry> {
    private final String _modelName;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final PortletResourcePermission _portletResourcePermission;

    public ObjectEntryModelResourcePermission(String modelName, ObjectEntryLocalService objectEntryLocalService, PortletResourcePermission portletResourcePermission) {
        this._modelName = modelName;
        this._objectEntryLocalService = objectEntryLocalService;
        this._portletResourcePermission = portletResourcePermission;
    }

    public void check(PermissionChecker permissionChecker, long objectEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._modelName, objectEntryId, new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, ObjectEntry objectEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, objectEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, this._modelName, objectEntry.getObjectEntryId(), new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, long objectEntryId, String actionId) throws PortalException {
        ObjectEntry objectEntry = this._objectEntryLocalService.getObjectEntry(objectEntryId);
        return this.contains(permissionChecker, objectEntry, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, ObjectEntry objectEntry, String actionId) throws PortalException {
        return permissionChecker.hasPermission(objectEntry.getGroupId(), this._modelName, objectEntry.getObjectEntryId(), actionId);
    }

    public String getModelName() {
        return this._modelName;
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

