/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.related.models;

import com.liferay.object.exception.RequiredObjectRelationshipException;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectRelationship;
import com.liferay.object.related.models.ObjectRelatedModelsProvider;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.object.service.ObjectRelationshipLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import java.util.List;
import java.util.Objects;

public class ObjectEntryMtoMObjectRelatedModelsProviderImpl
implements ObjectRelatedModelsProvider<ObjectEntry> {
    private final String _className;
    private final ObjectEntryLocalService _objectEntryLocalService;
    private final ObjectRelationshipLocalService _objectRelationshipLocalService;

    public ObjectEntryMtoMObjectRelatedModelsProviderImpl(ObjectDefinition objectDefinition, ObjectEntryLocalService objectEntryLocalService, ObjectRelationshipLocalService objectRelationshipLocalService) {
        this._objectEntryLocalService = objectEntryLocalService;
        this._objectRelationshipLocalService = objectRelationshipLocalService;
        this._className = objectDefinition.getClassName();
    }

    public void deleteRelatedModel(long userId, long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        ObjectRelationship objectRelationship = this._objectRelationshipLocalService.getObjectRelationship(objectRelationshipId);
        if (Objects.equals(objectRelationship.getDeletionType(), "cascade") || Objects.equals(objectRelationship.getDeletionType(), "disassociate")) {
            this._objectRelationshipLocalService.deleteObjectRelationshipMappingTableValues(objectRelationshipId, primaryKey);
        } else if (Objects.equals(objectRelationship.getDeletionType(), "prevent")) {
            throw new RequiredObjectRelationshipException();
        }
    }

    public String getClassName() {
        return this._className;
    }

    public String getObjectRelationshipType() {
        return "many_to_many";
    }

    public List<ObjectEntry> getRelatedModels(long groupId, long objectRelationshipId, long primaryKey, int start, int end) throws PortalException {
        return this._objectEntryLocalService.getManyToManyRelatedObjectEntries(groupId, objectRelationshipId, primaryKey, start, end);
    }

    public int getRelatedModelsCount(long groupId, long objectRelationshipId, long primaryKey) throws PortalException {
        return this._objectEntryLocalService.getManyToManyRelatedObjectEntriesCount(groupId, objectRelationshipId, primaryKey);
    }
}

