/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.internal.model.listener;

import com.liferay.object.action.engine.ObjectActionEngine;
import com.liferay.object.model.ObjectEntry;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONException;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.util.HashMapBuilder;
import java.io.Serializable;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class ObjectEntryModelListener
extends BaseModelListener<ObjectEntry> {
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectActionEngine _objectActionEngine;

    public void onAfterCreate(ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("on-after-add", null, objectEntry);
    }

    public void onAfterRemove(ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("on-after-delete", null, objectEntry);
    }

    public void onAfterUpdate(ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        this._executeObjectActions("on-after-update", originalObjectEntry, objectEntry);
    }

    private void _executeObjectActions(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws ModelListenerException {
        try {
            long userId = PrincipalThreadLocal.getUserId();
            if (userId == 0L) {
                userId = objectEntry.getUserId();
            }
            this._objectActionEngine.executeObjectActions(userId, objectEntry.getModelClassName(), objectActionTriggerKey, (Map)HashMapBuilder.put((Object)"payload", (Object)this._getPayload(objectActionTriggerKey, originalObjectEntry, objectEntry)).build());
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private Serializable _getPayload(String objectActionTriggerKey, ObjectEntry originalObjectEntry, ObjectEntry objectEntry) throws JSONException {
        JSONObject payloadJSONObject = JSONUtil.put((String)"objectActionTriggerKey", (Object)objectActionTriggerKey);
        JSONObject objectEntryJSONObject = this._jsonFactory.createJSONObject(objectEntry.toString());
        objectEntryJSONObject.put("values", (Object)objectEntry.getValues());
        payloadJSONObject.put("objectEntry", objectEntryJSONObject);
        if (originalObjectEntry != null) {
            JSONObject originalObjectEntryJSONObject = this._jsonFactory.createJSONObject(originalObjectEntry.toString());
            originalObjectEntryJSONObject.put("values", (Object)originalObjectEntry.getValues());
            payloadJSONObject.put("originalObjectEntry", originalObjectEntryJSONObject);
        }
        return payloadJSONObject.toString();
    }
}

