/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.object.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectDefinitionModel;
import com.liferay.object.model.ObjectDefinitionSoap;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ObjectDefinition service. Represents a row in the &quot;ObjectDefinition&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>ObjectDefinitionModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ObjectDefinitionImpl}.
 * </p>
 *
 * @author Marco Leo
 * @see ObjectDefinitionImpl
 * @generated
 */
@JSON(strict = true)
public class ObjectDefinitionModelImpl
	extends BaseModelImpl<ObjectDefinition> implements ObjectDefinitionModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a object definition model instance should use the <code>ObjectDefinition</code> interface instead.
	 */
	public static final String TABLE_NAME = "ObjectDefinition";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"objectDefinitionId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"descriptionObjectFieldId", Types.BIGINT},
		{"titleObjectFieldId", Types.BIGINT}, {"active_", Types.BOOLEAN},
		{"dbTableName", Types.VARCHAR}, {"label", Types.VARCHAR},
		{"className", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"panelAppOrder", Types.VARCHAR}, {"panelCategoryKey", Types.VARCHAR},
		{"pkObjectFieldDBColumnName", Types.VARCHAR},
		{"pkObjectFieldName", Types.VARCHAR}, {"pluralLabel", Types.VARCHAR},
		{"scope", Types.VARCHAR}, {"system_", Types.BOOLEAN},
		{"version", Types.INTEGER}, {"status", Types.INTEGER}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("objectDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("descriptionObjectFieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("titleObjectFieldId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("active_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("dbTableName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("label", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("className", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("panelAppOrder", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("panelCategoryKey", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("pkObjectFieldDBColumnName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("pkObjectFieldName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("pluralLabel", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("scope", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("system_", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("version", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("status", Types.INTEGER);
	}

	public static final String TABLE_SQL_CREATE =
		"create table ObjectDefinition (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,objectDefinitionId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,descriptionObjectFieldId LONG,titleObjectFieldId LONG,active_ BOOLEAN,dbTableName VARCHAR(75) null,label STRING null,className VARCHAR(75) null,name VARCHAR(75) null,panelAppOrder VARCHAR(75) null,panelCategoryKey VARCHAR(75) null,pkObjectFieldDBColumnName VARCHAR(75) null,pkObjectFieldName VARCHAR(75) null,pluralLabel STRING null,scope VARCHAR(75) null,system_ BOOLEAN,version INTEGER,status INTEGER)";

	public static final String TABLE_SQL_DROP = "drop table ObjectDefinition";

	public static final String ORDER_BY_JPQL =
		" ORDER BY objectDefinition.name ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY ObjectDefinition.name ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long ACTIVE_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CLASSNAME_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NAME_COLUMN_BITMASK = 8L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long STATUS_COLUMN_BITMASK = 16L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long SYSTEM_COLUMN_BITMASK = 32L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 64L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static ObjectDefinition toModel(ObjectDefinitionSoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		ObjectDefinition model = new ObjectDefinitionImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setUuid(soapModel.getUuid());
		model.setObjectDefinitionId(soapModel.getObjectDefinitionId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setDescriptionObjectFieldId(
			soapModel.getDescriptionObjectFieldId());
		model.setTitleObjectFieldId(soapModel.getTitleObjectFieldId());
		model.setActive(soapModel.isActive());
		model.setDBTableName(soapModel.getDBTableName());
		model.setLabel(soapModel.getLabel());
		model.setClassName(soapModel.getClassName());
		model.setName(soapModel.getName());
		model.setPanelAppOrder(soapModel.getPanelAppOrder());
		model.setPanelCategoryKey(soapModel.getPanelCategoryKey());
		model.setPKObjectFieldDBColumnName(
			soapModel.getPKObjectFieldDBColumnName());
		model.setPKObjectFieldName(soapModel.getPKObjectFieldName());
		model.setPluralLabel(soapModel.getPluralLabel());
		model.setScope(soapModel.getScope());
		model.setSystem(soapModel.isSystem());
		model.setVersion(soapModel.getVersion());
		model.setStatus(soapModel.getStatus());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<ObjectDefinition> toModels(
		ObjectDefinitionSoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<ObjectDefinition> models = new ArrayList<ObjectDefinition>(
			soapModels.length);

		for (ObjectDefinitionSoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public ObjectDefinitionModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _objectDefinitionId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setObjectDefinitionId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _objectDefinitionId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return ObjectDefinition.class;
	}

	@Override
	public String getModelClassName() {
		return ObjectDefinition.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<ObjectDefinition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<ObjectDefinition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectDefinition, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((ObjectDefinition)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<ObjectDefinition, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<ObjectDefinition, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(ObjectDefinition)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<ObjectDefinition, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<ObjectDefinition, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, ObjectDefinition>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			ObjectDefinition.class.getClassLoader(), ObjectDefinition.class,
			ModelWrapper.class);

		try {
			Constructor<ObjectDefinition> constructor =
				(Constructor<ObjectDefinition>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<ObjectDefinition, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<ObjectDefinition, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<ObjectDefinition, Object>>
			attributeGetterFunctions =
				new LinkedHashMap<String, Function<ObjectDefinition, Object>>();
		Map<String, BiConsumer<ObjectDefinition, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap<String, BiConsumer<ObjectDefinition, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", ObjectDefinition::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<ObjectDefinition, Long>)
				ObjectDefinition::setMvccVersion);
		attributeGetterFunctions.put("uuid", ObjectDefinition::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<ObjectDefinition, String>)ObjectDefinition::setUuid);
		attributeGetterFunctions.put(
			"objectDefinitionId", ObjectDefinition::getObjectDefinitionId);
		attributeSetterBiConsumers.put(
			"objectDefinitionId",
			(BiConsumer<ObjectDefinition, Long>)
				ObjectDefinition::setObjectDefinitionId);
		attributeGetterFunctions.put(
			"companyId", ObjectDefinition::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<ObjectDefinition, Long>)ObjectDefinition::setCompanyId);
		attributeGetterFunctions.put("userId", ObjectDefinition::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<ObjectDefinition, Long>)ObjectDefinition::setUserId);
		attributeGetterFunctions.put("userName", ObjectDefinition::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setUserName);
		attributeGetterFunctions.put(
			"createDate", ObjectDefinition::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<ObjectDefinition, Date>)
				ObjectDefinition::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", ObjectDefinition::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<ObjectDefinition, Date>)
				ObjectDefinition::setModifiedDate);
		attributeGetterFunctions.put(
			"descriptionObjectFieldId",
			ObjectDefinition::getDescriptionObjectFieldId);
		attributeSetterBiConsumers.put(
			"descriptionObjectFieldId",
			(BiConsumer<ObjectDefinition, Long>)
				ObjectDefinition::setDescriptionObjectFieldId);
		attributeGetterFunctions.put(
			"titleObjectFieldId", ObjectDefinition::getTitleObjectFieldId);
		attributeSetterBiConsumers.put(
			"titleObjectFieldId",
			(BiConsumer<ObjectDefinition, Long>)
				ObjectDefinition::setTitleObjectFieldId);
		attributeGetterFunctions.put("active", ObjectDefinition::getActive);
		attributeSetterBiConsumers.put(
			"active",
			(BiConsumer<ObjectDefinition, Boolean>)ObjectDefinition::setActive);
		attributeGetterFunctions.put(
			"dbTableName", ObjectDefinition::getDBTableName);
		attributeSetterBiConsumers.put(
			"dbTableName",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setDBTableName);
		attributeGetterFunctions.put("label", ObjectDefinition::getLabel);
		attributeSetterBiConsumers.put(
			"label",
			(BiConsumer<ObjectDefinition, String>)ObjectDefinition::setLabel);
		attributeGetterFunctions.put(
			"className", ObjectDefinition::getClassName);
		attributeSetterBiConsumers.put(
			"className",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setClassName);
		attributeGetterFunctions.put("name", ObjectDefinition::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<ObjectDefinition, String>)ObjectDefinition::setName);
		attributeGetterFunctions.put(
			"panelAppOrder", ObjectDefinition::getPanelAppOrder);
		attributeSetterBiConsumers.put(
			"panelAppOrder",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setPanelAppOrder);
		attributeGetterFunctions.put(
			"panelCategoryKey", ObjectDefinition::getPanelCategoryKey);
		attributeSetterBiConsumers.put(
			"panelCategoryKey",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setPanelCategoryKey);
		attributeGetterFunctions.put(
			"pkObjectFieldDBColumnName",
			ObjectDefinition::getPKObjectFieldDBColumnName);
		attributeSetterBiConsumers.put(
			"pkObjectFieldDBColumnName",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setPKObjectFieldDBColumnName);
		attributeGetterFunctions.put(
			"pkObjectFieldName", ObjectDefinition::getPKObjectFieldName);
		attributeSetterBiConsumers.put(
			"pkObjectFieldName",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setPKObjectFieldName);
		attributeGetterFunctions.put(
			"pluralLabel", ObjectDefinition::getPluralLabel);
		attributeSetterBiConsumers.put(
			"pluralLabel",
			(BiConsumer<ObjectDefinition, String>)
				ObjectDefinition::setPluralLabel);
		attributeGetterFunctions.put("scope", ObjectDefinition::getScope);
		attributeSetterBiConsumers.put(
			"scope",
			(BiConsumer<ObjectDefinition, String>)ObjectDefinition::setScope);
		attributeGetterFunctions.put("system", ObjectDefinition::getSystem);
		attributeSetterBiConsumers.put(
			"system",
			(BiConsumer<ObjectDefinition, Boolean>)ObjectDefinition::setSystem);
		attributeGetterFunctions.put("version", ObjectDefinition::getVersion);
		attributeSetterBiConsumers.put(
			"version",
			(BiConsumer<ObjectDefinition, Integer>)
				ObjectDefinition::setVersion);
		attributeGetterFunctions.put("status", ObjectDefinition::getStatus);
		attributeSetterBiConsumers.put(
			"status",
			(BiConsumer<ObjectDefinition, Integer>)ObjectDefinition::setStatus);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getObjectDefinitionId() {
		return _objectDefinitionId;
	}

	@Override
	public void setObjectDefinitionId(long objectDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId = objectDefinitionId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getDescriptionObjectFieldId() {
		return _descriptionObjectFieldId;
	}

	@Override
	public void setDescriptionObjectFieldId(long descriptionObjectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_descriptionObjectFieldId = descriptionObjectFieldId;
	}

	@JSON
	@Override
	public long getTitleObjectFieldId() {
		return _titleObjectFieldId;
	}

	@Override
	public void setTitleObjectFieldId(long titleObjectFieldId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_titleObjectFieldId = titleObjectFieldId;
	}

	@JSON
	@Override
	public boolean getActive() {
		return _active;
	}

	@JSON
	@Override
	public boolean isActive() {
		return _active;
	}

	@Override
	public void setActive(boolean active) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_active = active;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalActive() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("active_"));
	}

	@JSON
	@Override
	public String getDBTableName() {
		if (_dbTableName == null) {
			return "";
		}
		else {
			return _dbTableName;
		}
	}

	@Override
	public void setDBTableName(String dbTableName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_dbTableName = dbTableName;
	}

	@JSON
	@Override
	public String getLabel() {
		if (_label == null) {
			return "";
		}
		else {
			return _label;
		}
	}

	@Override
	public String getLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId);
	}

	@Override
	public String getLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getLabel(languageId, useDefault);
	}

	@Override
	public String getLabel(String languageId) {
		return LocalizationUtil.getLocalization(getLabel(), languageId);
	}

	@Override
	public String getLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getLabel(), languageId, useDefault);
	}

	@Override
	public String getLabelCurrentLanguageId() {
		return _labelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getLabelCurrentValue() {
		Locale locale = getLocale(_labelCurrentLanguageId);

		return getLabel(locale);
	}

	@Override
	public Map<Locale, String> getLabelMap() {
		return LocalizationUtil.getLocalizationMap(getLabel());
	}

	@Override
	public void setLabel(String label) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_label = label;
	}

	@Override
	public void setLabel(String label, Locale locale) {
		setLabel(label, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setLabel(String label, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(label)) {
			setLabel(
				LocalizationUtil.updateLocalization(
					getLabel(), "Label", label, languageId, defaultLanguageId));
		}
		else {
			setLabel(
				LocalizationUtil.removeLocalization(
					getLabel(), "Label", languageId));
		}
	}

	@Override
	public void setLabelCurrentLanguageId(String languageId) {
		_labelCurrentLanguageId = languageId;
	}

	@Override
	public void setLabelMap(Map<Locale, String> labelMap) {
		setLabelMap(labelMap, LocaleUtil.getDefault());
	}

	@Override
	public void setLabelMap(
		Map<Locale, String> labelMap, Locale defaultLocale) {

		if (labelMap == null) {
			return;
		}

		setLabel(
			LocalizationUtil.updateLocalization(
				labelMap, getLabel(), "Label",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getClassName() {
		if (_className == null) {
			return "";
		}
		else {
			return _className;
		}
	}

	@Override
	public void setClassName(String className) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_className = className;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalClassName() {
		return getColumnOriginalValue("className");
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalName() {
		return getColumnOriginalValue("name");
	}

	@JSON
	@Override
	public String getPanelAppOrder() {
		if (_panelAppOrder == null) {
			return "";
		}
		else {
			return _panelAppOrder;
		}
	}

	@Override
	public void setPanelAppOrder(String panelAppOrder) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_panelAppOrder = panelAppOrder;
	}

	@JSON
	@Override
	public String getPanelCategoryKey() {
		if (_panelCategoryKey == null) {
			return "";
		}
		else {
			return _panelCategoryKey;
		}
	}

	@Override
	public void setPanelCategoryKey(String panelCategoryKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_panelCategoryKey = panelCategoryKey;
	}

	@JSON
	@Override
	public String getPKObjectFieldDBColumnName() {
		if (_pkObjectFieldDBColumnName == null) {
			return "";
		}
		else {
			return _pkObjectFieldDBColumnName;
		}
	}

	@Override
	public void setPKObjectFieldDBColumnName(String pkObjectFieldDBColumnName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_pkObjectFieldDBColumnName = pkObjectFieldDBColumnName;
	}

	@JSON
	@Override
	public String getPKObjectFieldName() {
		if (_pkObjectFieldName == null) {
			return "";
		}
		else {
			return _pkObjectFieldName;
		}
	}

	@Override
	public void setPKObjectFieldName(String pkObjectFieldName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_pkObjectFieldName = pkObjectFieldName;
	}

	@JSON
	@Override
	public String getPluralLabel() {
		if (_pluralLabel == null) {
			return "";
		}
		else {
			return _pluralLabel;
		}
	}

	@Override
	public String getPluralLabel(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getPluralLabel(languageId);
	}

	@Override
	public String getPluralLabel(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getPluralLabel(languageId, useDefault);
	}

	@Override
	public String getPluralLabel(String languageId) {
		return LocalizationUtil.getLocalization(getPluralLabel(), languageId);
	}

	@Override
	public String getPluralLabel(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getPluralLabel(), languageId, useDefault);
	}

	@Override
	public String getPluralLabelCurrentLanguageId() {
		return _pluralLabelCurrentLanguageId;
	}

	@JSON
	@Override
	public String getPluralLabelCurrentValue() {
		Locale locale = getLocale(_pluralLabelCurrentLanguageId);

		return getPluralLabel(locale);
	}

	@Override
	public Map<Locale, String> getPluralLabelMap() {
		return LocalizationUtil.getLocalizationMap(getPluralLabel());
	}

	@Override
	public void setPluralLabel(String pluralLabel) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_pluralLabel = pluralLabel;
	}

	@Override
	public void setPluralLabel(String pluralLabel, Locale locale) {
		setPluralLabel(pluralLabel, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setPluralLabel(
		String pluralLabel, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(pluralLabel)) {
			setPluralLabel(
				LocalizationUtil.updateLocalization(
					getPluralLabel(), "PluralLabel", pluralLabel, languageId,
					defaultLanguageId));
		}
		else {
			setPluralLabel(
				LocalizationUtil.removeLocalization(
					getPluralLabel(), "PluralLabel", languageId));
		}
	}

	@Override
	public void setPluralLabelCurrentLanguageId(String languageId) {
		_pluralLabelCurrentLanguageId = languageId;
	}

	@Override
	public void setPluralLabelMap(Map<Locale, String> pluralLabelMap) {
		setPluralLabelMap(pluralLabelMap, LocaleUtil.getDefault());
	}

	@Override
	public void setPluralLabelMap(
		Map<Locale, String> pluralLabelMap, Locale defaultLocale) {

		if (pluralLabelMap == null) {
			return;
		}

		setPluralLabel(
			LocalizationUtil.updateLocalization(
				pluralLabelMap, getPluralLabel(), "PluralLabel",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getScope() {
		if (_scope == null) {
			return "";
		}
		else {
			return _scope;
		}
	}

	@Override
	public void setScope(String scope) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_scope = scope;
	}

	@JSON
	@Override
	public boolean getSystem() {
		return _system;
	}

	@JSON
	@Override
	public boolean isSystem() {
		return _system;
	}

	@Override
	public void setSystem(boolean system) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_system = system;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public boolean getOriginalSystem() {
		return GetterUtil.getBoolean(
			this.<Boolean>getColumnOriginalValue("system_"));
	}

	@JSON
	@Override
	public int getVersion() {
		return _version;
	}

	@Override
	public void setVersion(int version) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_version = version;
	}

	@JSON
	@Override
	public int getStatus() {
		return _status;
	}

	@Override
	public void setStatus(int status) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_status = status;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public int getOriginalStatus() {
		return GetterUtil.getInteger(
			this.<Integer>getColumnOriginalValue("status"));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(ObjectDefinition.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), ObjectDefinition.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> labelMap = getLabelMap();

		for (Map.Entry<Locale, String> entry : labelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> pluralLabelMap = getPluralLabelMap();

		for (Map.Entry<Locale, String> entry : pluralLabelMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getLabel();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			ObjectDefinition.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String label = getLabel(defaultLocale);

		if (Validator.isNull(label)) {
			setLabel(getLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setLabel(getLabel(defaultLocale), defaultLocale, defaultLocale);
		}

		String pluralLabel = getPluralLabel(defaultLocale);

		if (Validator.isNull(pluralLabel)) {
			setPluralLabel(
				getPluralLabel(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setPluralLabel(
				getPluralLabel(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public ObjectDefinition toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ObjectDefinition>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		ObjectDefinitionImpl objectDefinitionImpl = new ObjectDefinitionImpl();

		objectDefinitionImpl.setMvccVersion(getMvccVersion());
		objectDefinitionImpl.setUuid(getUuid());
		objectDefinitionImpl.setObjectDefinitionId(getObjectDefinitionId());
		objectDefinitionImpl.setCompanyId(getCompanyId());
		objectDefinitionImpl.setUserId(getUserId());
		objectDefinitionImpl.setUserName(getUserName());
		objectDefinitionImpl.setCreateDate(getCreateDate());
		objectDefinitionImpl.setModifiedDate(getModifiedDate());
		objectDefinitionImpl.setDescriptionObjectFieldId(
			getDescriptionObjectFieldId());
		objectDefinitionImpl.setTitleObjectFieldId(getTitleObjectFieldId());
		objectDefinitionImpl.setActive(isActive());
		objectDefinitionImpl.setDBTableName(getDBTableName());
		objectDefinitionImpl.setLabel(getLabel());
		objectDefinitionImpl.setClassName(getClassName());
		objectDefinitionImpl.setName(getName());
		objectDefinitionImpl.setPanelAppOrder(getPanelAppOrder());
		objectDefinitionImpl.setPanelCategoryKey(getPanelCategoryKey());
		objectDefinitionImpl.setPKObjectFieldDBColumnName(
			getPKObjectFieldDBColumnName());
		objectDefinitionImpl.setPKObjectFieldName(getPKObjectFieldName());
		objectDefinitionImpl.setPluralLabel(getPluralLabel());
		objectDefinitionImpl.setScope(getScope());
		objectDefinitionImpl.setSystem(isSystem());
		objectDefinitionImpl.setVersion(getVersion());
		objectDefinitionImpl.setStatus(getStatus());

		objectDefinitionImpl.resetOriginalValues();

		return objectDefinitionImpl;
	}

	@Override
	public ObjectDefinition cloneWithOriginalValues() {
		ObjectDefinitionImpl objectDefinitionImpl = new ObjectDefinitionImpl();

		objectDefinitionImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		objectDefinitionImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		objectDefinitionImpl.setObjectDefinitionId(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
		objectDefinitionImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		objectDefinitionImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		objectDefinitionImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		objectDefinitionImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		objectDefinitionImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		objectDefinitionImpl.setDescriptionObjectFieldId(
			this.<Long>getColumnOriginalValue("descriptionObjectFieldId"));
		objectDefinitionImpl.setTitleObjectFieldId(
			this.<Long>getColumnOriginalValue("titleObjectFieldId"));
		objectDefinitionImpl.setActive(
			this.<Boolean>getColumnOriginalValue("active_"));
		objectDefinitionImpl.setDBTableName(
			this.<String>getColumnOriginalValue("dbTableName"));
		objectDefinitionImpl.setLabel(
			this.<String>getColumnOriginalValue("label"));
		objectDefinitionImpl.setClassName(
			this.<String>getColumnOriginalValue("className"));
		objectDefinitionImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		objectDefinitionImpl.setPanelAppOrder(
			this.<String>getColumnOriginalValue("panelAppOrder"));
		objectDefinitionImpl.setPanelCategoryKey(
			this.<String>getColumnOriginalValue("panelCategoryKey"));
		objectDefinitionImpl.setPKObjectFieldDBColumnName(
			this.<String>getColumnOriginalValue("pkObjectFieldDBColumnName"));
		objectDefinitionImpl.setPKObjectFieldName(
			this.<String>getColumnOriginalValue("pkObjectFieldName"));
		objectDefinitionImpl.setPluralLabel(
			this.<String>getColumnOriginalValue("pluralLabel"));
		objectDefinitionImpl.setScope(
			this.<String>getColumnOriginalValue("scope"));
		objectDefinitionImpl.setSystem(
			this.<Boolean>getColumnOriginalValue("system_"));
		objectDefinitionImpl.setVersion(
			this.<Integer>getColumnOriginalValue("version"));
		objectDefinitionImpl.setStatus(
			this.<Integer>getColumnOriginalValue("status"));

		return objectDefinitionImpl;
	}

	@Override
	public int compareTo(ObjectDefinition objectDefinition) {
		int value = 0;

		value = getName().compareTo(objectDefinition.getName());

		if (value != 0) {
			return value;
		}

		return 0;
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectDefinition)) {
			return false;
		}

		ObjectDefinition objectDefinition = (ObjectDefinition)object;

		long primaryKey = objectDefinition.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<ObjectDefinition> toCacheModel() {
		ObjectDefinitionCacheModel objectDefinitionCacheModel =
			new ObjectDefinitionCacheModel();

		objectDefinitionCacheModel.mvccVersion = getMvccVersion();

		objectDefinitionCacheModel.uuid = getUuid();

		String uuid = objectDefinitionCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			objectDefinitionCacheModel.uuid = null;
		}

		objectDefinitionCacheModel.objectDefinitionId = getObjectDefinitionId();

		objectDefinitionCacheModel.companyId = getCompanyId();

		objectDefinitionCacheModel.userId = getUserId();

		objectDefinitionCacheModel.userName = getUserName();

		String userName = objectDefinitionCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			objectDefinitionCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			objectDefinitionCacheModel.createDate = createDate.getTime();
		}
		else {
			objectDefinitionCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			objectDefinitionCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			objectDefinitionCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		objectDefinitionCacheModel.descriptionObjectFieldId =
			getDescriptionObjectFieldId();

		objectDefinitionCacheModel.titleObjectFieldId = getTitleObjectFieldId();

		objectDefinitionCacheModel.active = isActive();

		objectDefinitionCacheModel.dbTableName = getDBTableName();

		String dbTableName = objectDefinitionCacheModel.dbTableName;

		if ((dbTableName != null) && (dbTableName.length() == 0)) {
			objectDefinitionCacheModel.dbTableName = null;
		}

		objectDefinitionCacheModel.label = getLabel();

		String label = objectDefinitionCacheModel.label;

		if ((label != null) && (label.length() == 0)) {
			objectDefinitionCacheModel.label = null;
		}

		objectDefinitionCacheModel.className = getClassName();

		String className = objectDefinitionCacheModel.className;

		if ((className != null) && (className.length() == 0)) {
			objectDefinitionCacheModel.className = null;
		}

		objectDefinitionCacheModel.name = getName();

		String name = objectDefinitionCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			objectDefinitionCacheModel.name = null;
		}

		objectDefinitionCacheModel.panelAppOrder = getPanelAppOrder();

		String panelAppOrder = objectDefinitionCacheModel.panelAppOrder;

		if ((panelAppOrder != null) && (panelAppOrder.length() == 0)) {
			objectDefinitionCacheModel.panelAppOrder = null;
		}

		objectDefinitionCacheModel.panelCategoryKey = getPanelCategoryKey();

		String panelCategoryKey = objectDefinitionCacheModel.panelCategoryKey;

		if ((panelCategoryKey != null) && (panelCategoryKey.length() == 0)) {
			objectDefinitionCacheModel.panelCategoryKey = null;
		}

		objectDefinitionCacheModel.pkObjectFieldDBColumnName =
			getPKObjectFieldDBColumnName();

		String pkObjectFieldDBColumnName =
			objectDefinitionCacheModel.pkObjectFieldDBColumnName;

		if ((pkObjectFieldDBColumnName != null) &&
			(pkObjectFieldDBColumnName.length() == 0)) {

			objectDefinitionCacheModel.pkObjectFieldDBColumnName = null;
		}

		objectDefinitionCacheModel.pkObjectFieldName = getPKObjectFieldName();

		String pkObjectFieldName = objectDefinitionCacheModel.pkObjectFieldName;

		if ((pkObjectFieldName != null) && (pkObjectFieldName.length() == 0)) {
			objectDefinitionCacheModel.pkObjectFieldName = null;
		}

		objectDefinitionCacheModel.pluralLabel = getPluralLabel();

		String pluralLabel = objectDefinitionCacheModel.pluralLabel;

		if ((pluralLabel != null) && (pluralLabel.length() == 0)) {
			objectDefinitionCacheModel.pluralLabel = null;
		}

		objectDefinitionCacheModel.scope = getScope();

		String scope = objectDefinitionCacheModel.scope;

		if ((scope != null) && (scope.length() == 0)) {
			objectDefinitionCacheModel.scope = null;
		}

		objectDefinitionCacheModel.system = isSystem();

		objectDefinitionCacheModel.version = getVersion();

		objectDefinitionCacheModel.status = getStatus();

		return objectDefinitionCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<ObjectDefinition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<ObjectDefinition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectDefinition, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(ObjectDefinition)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<ObjectDefinition, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<ObjectDefinition, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<ObjectDefinition, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((ObjectDefinition)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, ObjectDefinition>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private String _uuid;
	private long _objectDefinitionId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _descriptionObjectFieldId;
	private long _titleObjectFieldId;
	private boolean _active;
	private String _dbTableName;
	private String _label;
	private String _labelCurrentLanguageId;
	private String _className;
	private String _name;
	private String _panelAppOrder;
	private String _panelCategoryKey;
	private String _pkObjectFieldDBColumnName;
	private String _pkObjectFieldName;
	private String _pluralLabel;
	private String _pluralLabelCurrentLanguageId;
	private String _scope;
	private boolean _system;
	private int _version;
	private int _status;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<ObjectDefinition, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((ObjectDefinition)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("objectDefinitionId", _objectDefinitionId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"descriptionObjectFieldId", _descriptionObjectFieldId);
		_columnOriginalValues.put("titleObjectFieldId", _titleObjectFieldId);
		_columnOriginalValues.put("active_", _active);
		_columnOriginalValues.put("dbTableName", _dbTableName);
		_columnOriginalValues.put("label", _label);
		_columnOriginalValues.put("className", _className);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("panelAppOrder", _panelAppOrder);
		_columnOriginalValues.put("panelCategoryKey", _panelCategoryKey);
		_columnOriginalValues.put(
			"pkObjectFieldDBColumnName", _pkObjectFieldDBColumnName);
		_columnOriginalValues.put("pkObjectFieldName", _pkObjectFieldName);
		_columnOriginalValues.put("pluralLabel", _pluralLabel);
		_columnOriginalValues.put("scope", _scope);
		_columnOriginalValues.put("system_", _system);
		_columnOriginalValues.put("version", _version);
		_columnOriginalValues.put("status", _status);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("active_", "active");
		attributeNames.put("system_", "system");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("objectDefinitionId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("descriptionObjectFieldId", 256L);

		columnBitmasks.put("titleObjectFieldId", 512L);

		columnBitmasks.put("active_", 1024L);

		columnBitmasks.put("dbTableName", 2048L);

		columnBitmasks.put("label", 4096L);

		columnBitmasks.put("className", 8192L);

		columnBitmasks.put("name", 16384L);

		columnBitmasks.put("panelAppOrder", 32768L);

		columnBitmasks.put("panelCategoryKey", 65536L);

		columnBitmasks.put("pkObjectFieldDBColumnName", 131072L);

		columnBitmasks.put("pkObjectFieldName", 262144L);

		columnBitmasks.put("pluralLabel", 524288L);

		columnBitmasks.put("scope", 1048576L);

		columnBitmasks.put("system_", 2097152L);

		columnBitmasks.put("version", 4194304L);

		columnBitmasks.put("status", 8388608L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private ObjectDefinition _escapedModel;

}