/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.model.impl;

import com.liferay.object.model.ObjectAction;
import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.MVCCModel;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

import java.util.Date;

/**
 * The cache model class for representing ObjectAction in entity cache.
 *
 * @author Marco Leo
 * @generated
 */
public class ObjectActionCacheModel
	implements CacheModel<ObjectAction>, Externalizable, MVCCModel {

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ObjectActionCacheModel)) {
			return false;
		}

		ObjectActionCacheModel objectActionCacheModel =
			(ObjectActionCacheModel)object;

		if ((objectActionId == objectActionCacheModel.objectActionId) &&
			(mvccVersion == objectActionCacheModel.mvccVersion)) {

			return true;
		}

		return false;
	}

	@Override
	public int hashCode() {
		int hashCode = HashUtil.hash(0, objectActionId);

		return HashUtil.hash(hashCode, mvccVersion);
	}

	@Override
	public long getMvccVersion() {
		return mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		this.mvccVersion = mvccVersion;
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(29);

		sb.append("{mvccVersion=");
		sb.append(mvccVersion);
		sb.append(", uuid=");
		sb.append(uuid);
		sb.append(", objectActionId=");
		sb.append(objectActionId);
		sb.append(", companyId=");
		sb.append(companyId);
		sb.append(", userId=");
		sb.append(userId);
		sb.append(", userName=");
		sb.append(userName);
		sb.append(", createDate=");
		sb.append(createDate);
		sb.append(", modifiedDate=");
		sb.append(modifiedDate);
		sb.append(", objectDefinitionId=");
		sb.append(objectDefinitionId);
		sb.append(", active=");
		sb.append(active);
		sb.append(", name=");
		sb.append(name);
		sb.append(", objectActionExecutorKey=");
		sb.append(objectActionExecutorKey);
		sb.append(", objectActionTriggerKey=");
		sb.append(objectActionTriggerKey);
		sb.append(", parameters=");
		sb.append(parameters);
		sb.append("}");

		return sb.toString();
	}

	@Override
	public ObjectAction toEntityModel() {
		ObjectActionImpl objectActionImpl = new ObjectActionImpl();

		objectActionImpl.setMvccVersion(mvccVersion);

		if (uuid == null) {
			objectActionImpl.setUuid("");
		}
		else {
			objectActionImpl.setUuid(uuid);
		}

		objectActionImpl.setObjectActionId(objectActionId);
		objectActionImpl.setCompanyId(companyId);
		objectActionImpl.setUserId(userId);

		if (userName == null) {
			objectActionImpl.setUserName("");
		}
		else {
			objectActionImpl.setUserName(userName);
		}

		if (createDate == Long.MIN_VALUE) {
			objectActionImpl.setCreateDate(null);
		}
		else {
			objectActionImpl.setCreateDate(new Date(createDate));
		}

		if (modifiedDate == Long.MIN_VALUE) {
			objectActionImpl.setModifiedDate(null);
		}
		else {
			objectActionImpl.setModifiedDate(new Date(modifiedDate));
		}

		objectActionImpl.setObjectDefinitionId(objectDefinitionId);
		objectActionImpl.setActive(active);

		if (name == null) {
			objectActionImpl.setName("");
		}
		else {
			objectActionImpl.setName(name);
		}

		if (objectActionExecutorKey == null) {
			objectActionImpl.setObjectActionExecutorKey("");
		}
		else {
			objectActionImpl.setObjectActionExecutorKey(
				objectActionExecutorKey);
		}

		if (objectActionTriggerKey == null) {
			objectActionImpl.setObjectActionTriggerKey("");
		}
		else {
			objectActionImpl.setObjectActionTriggerKey(objectActionTriggerKey);
		}

		if (parameters == null) {
			objectActionImpl.setParameters("");
		}
		else {
			objectActionImpl.setParameters(parameters);
		}

		objectActionImpl.resetOriginalValues();

		return objectActionImpl;
	}

	@Override
	public void readExternal(ObjectInput objectInput)
		throws ClassNotFoundException, IOException {

		mvccVersion = objectInput.readLong();
		uuid = objectInput.readUTF();

		objectActionId = objectInput.readLong();

		companyId = objectInput.readLong();

		userId = objectInput.readLong();
		userName = objectInput.readUTF();
		createDate = objectInput.readLong();
		modifiedDate = objectInput.readLong();

		objectDefinitionId = objectInput.readLong();

		active = objectInput.readBoolean();
		name = objectInput.readUTF();
		objectActionExecutorKey = objectInput.readUTF();
		objectActionTriggerKey = objectInput.readUTF();
		parameters = (String)objectInput.readObject();
	}

	@Override
	public void writeExternal(ObjectOutput objectOutput) throws IOException {
		objectOutput.writeLong(mvccVersion);

		if (uuid == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(uuid);
		}

		objectOutput.writeLong(objectActionId);

		objectOutput.writeLong(companyId);

		objectOutput.writeLong(userId);

		if (userName == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(userName);
		}

		objectOutput.writeLong(createDate);
		objectOutput.writeLong(modifiedDate);

		objectOutput.writeLong(objectDefinitionId);

		objectOutput.writeBoolean(active);

		if (name == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(name);
		}

		if (objectActionExecutorKey == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(objectActionExecutorKey);
		}

		if (objectActionTriggerKey == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(objectActionTriggerKey);
		}

		if (parameters == null) {
			objectOutput.writeObject("");
		}
		else {
			objectOutput.writeObject(parameters);
		}
	}

	public long mvccVersion;
	public String uuid;
	public long objectActionId;
	public long companyId;
	public long userId;
	public String userName;
	public long createDate;
	public long modifiedDate;
	public long objectDefinitionId;
	public boolean active;
	public String name;
	public String objectActionExecutorKey;
	public String objectActionTriggerKey;
	public String parameters;

}