/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.internal.action.executor;

import com.liferay.object.action.executor.ObjectActionExecutor;
import com.liferay.object.action.request.ObjectActionRequest;
import com.liferay.object.constants.ObjectActionExecutorConstants;
import com.liferay.object.service.ObjectEntryLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Marco Leo
 */
@Component(enabled = false, service = ObjectActionExecutor.class)
public class UpdateObjectEntryObjectActionExecutorImpl
	implements ObjectActionExecutor {

	@Override
	public void execute(ObjectActionRequest objectActionRequest)
		throws Exception {

		_objectEntryLocalService.updateObjectEntry(
			objectActionRequest.getUserId(),
			GetterUtil.getLong(
				objectActionRequest.getParameterValue("classPK")),
			HashMapBuilder.put(
				String.valueOf(
					objectActionRequest.getParameterValue("objectFieldName")),
				objectActionRequest.getParameterValue("objectFieldValue")
			).build(),
			new ServiceContext() {
				{
					setUserId(objectActionRequest.getUserId());
				}
			});
	}

	@Override
	public String getKey() {
		return ObjectActionExecutorConstants.KEY_UPDATE_OBJECT_ENTRY;
	}

	@Reference
	private ObjectEntryLocalService _objectEntryLocalService;

}