/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.item.selector.web.internal.display.context;

import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portlet.SearchOrderByUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.OrderByComparatorFactoryUtil;
import jakarta.portlet.PortletRequest;
import jakarta.portlet.PortletURL;
import jakarta.portlet.RenderRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;

public class ObjectDefinitionDisplayContext {
    private final HttpServletRequest _httpServletRequest;
    private final ObjectDefinitionLocalService _objectDefinitionLocalService;
    private SearchContainer<ObjectDefinition> _objectDefinitionSearchContainer;
    private String _orderByCol;
    private String _orderByType;
    private final PortletURL _portletURL;
    private final RenderRequest _renderRequest;
    private final ThemeDisplay _themeDisplay;

    public ObjectDefinitionDisplayContext(HttpServletRequest httpServletRequest, ObjectDefinitionLocalService objectDefinitionLocalService, PortletURL portletURL, RenderRequest renderRequest) {
        this._httpServletRequest = httpServletRequest;
        this._objectDefinitionLocalService = objectDefinitionLocalService;
        this._portletURL = portletURL;
        this._renderRequest = renderRequest;
        this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
    }

    public SearchContainer<ObjectDefinition> getObjectDefinitionSearchContainer() throws PortalException {
        if (this._objectDefinitionSearchContainer != null) {
            return this._objectDefinitionSearchContainer;
        }
        SearchContainer objectDefinitionSearchContainer = new SearchContainer((PortletRequest)this._renderRequest, this._portletURL, null, "there-are-no-objects");
        objectDefinitionSearchContainer.setId("selectObjectDefinition");
        objectDefinitionSearchContainer.setOrderByCol(this._getOrderByCol());
        objectDefinitionSearchContainer.setOrderByType(this._getOrderByType());
        String columnName = objectDefinitionSearchContainer.getOrderByCol();
        if (columnName.equals("modified-date")) {
            columnName = "modifiedDate";
        }
        objectDefinitionSearchContainer.setResultsAndTotal(this._objectDefinitionLocalService.getObjectDefinitions(this._themeDisplay.getCompanyId(), true, false, 0, objectDefinitionSearchContainer.getStart(), objectDefinitionSearchContainer.getEnd(), OrderByComparatorFactoryUtil.create((String)"ObjectDefinition", (Object[])new Object[]{columnName, Objects.equals(this._getOrderByType(), "asc")})));
        this._objectDefinitionSearchContainer = objectDefinitionSearchContainer;
        return this._objectDefinitionSearchContainer;
    }

    private String _getOrderByCol() {
        if (this._orderByCol != null) {
            return this._orderByCol;
        }
        this._orderByCol = SearchOrderByUtil.getOrderByCol((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_object_web_internal_object_definitions_portlet_ObjectDefinitionsPortlet", (String)"object-definition-order-by-col", (String)"label");
        return this._orderByCol;
    }

    private String _getOrderByType() {
        if (this._orderByType != null) {
            return this._orderByType;
        }
        this._orderByType = SearchOrderByUtil.getOrderByType((HttpServletRequest)this._httpServletRequest, (String)"com_liferay_object_web_internal_object_definitions_portlet_ObjectDefinitionsPortlet", (String)"object-definition-order-by-type", (String)"asc");
        return this._orderByType;
    }
}

