/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.object.dynamic.data.mapping.internal.storage;

import com.liferay.dynamic.data.mapping.exception.StorageException;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormField;
import com.liferay.dynamic.data.mapping.model.DDMFormFieldOptions;
import com.liferay.dynamic.data.mapping.model.DDMFormInstance;
import com.liferay.dynamic.data.mapping.model.DDMFormInstanceSettings;
import com.liferay.dynamic.data.mapping.model.LocalizedValue;
import com.liferay.dynamic.data.mapping.model.Value;
import com.liferay.dynamic.data.mapping.storage.DDMFormFieldValue;
import com.liferay.dynamic.data.mapping.storage.DDMFormValues;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapter;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterDeleteResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterGetResponse;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveRequest;
import com.liferay.dynamic.data.mapping.storage.DDMStorageAdapterSaveResponse;
import com.liferay.object.field.util.ObjectFieldUtil;
import com.liferay.object.model.ObjectDefinition;
import com.liferay.object.model.ObjectEntry;
import com.liferay.object.model.ObjectField;
import com.liferay.object.rest.dto.v1_0.ListEntry;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.DefaultObjectEntryManagerProvider;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManager;
import com.liferay.object.rest.manager.v1_0.ObjectEntryManagerRegistry;
import com.liferay.object.scope.ObjectScopeProvider;
import com.liferay.object.scope.ObjectScopeProviderRegistry;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectEntryService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.dto.converter.DTOConverterContext;
import com.liferay.portal.vulcan.dto.converter.DefaultDTOConverterContext;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"ddm.storage.adapter.type=object"}, service={DDMStorageAdapter.class})
public class ObjectDDMStorageAdapter
implements DDMStorageAdapter {
    private static final Log _log = LogFactoryUtil.getLog(ObjectDDMStorageAdapter.class);
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private JSONFactory _jsonFactory;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectEntryManagerRegistry _objectEntryManagerRegistry;
    @Reference
    private ObjectEntryService _objectEntryService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private ObjectScopeProviderRegistry _objectScopeProviderRegistry;
    @Reference
    private UserLocalService _userLocalService;

    public DDMStorageAdapterDeleteResponse delete(DDMStorageAdapterDeleteRequest ddmStorageAdapterDeleteRequest) throws StorageException {
        throw new UnsupportedOperationException();
    }

    public DDMStorageAdapterGetResponse get(DDMStorageAdapterGetRequest ddmStorageAdapterGetRequest) throws StorageException {
        try {
            DDMForm ddmForm = ddmStorageAdapterGetRequest.getDDMForm();
            DDMFormValues ddmFormValues = new DDMFormValues(ddmForm);
            ddmFormValues.addAvailableLocale(ddmForm.getDefaultLocale());
            ObjectEntry serviceBuilderObjectEntry = this._objectEntryService.getObjectEntry(ddmStorageAdapterGetRequest.getPrimaryKey());
            ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(serviceBuilderObjectEntry.getObjectDefinitionId());
            DefaultObjectEntryManager defaultObjectEntryManager = DefaultObjectEntryManagerProvider.provide((ObjectEntryManager)this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getCompanyId(), objectDefinition.getStorageType()));
            com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry = defaultObjectEntryManager.fetchObjectEntry((DTOConverterContext)new DefaultDTOConverterContext(true, Collections.singletonMap("delete", Collections.singletonMap("delete", "")), null, null, (Object)ddmStorageAdapterGetRequest.getPrimaryKey(), ddmForm.getDefaultLocale(), null, this._userLocalService.fetchUser(PrincipalThreadLocal.getUserId())), objectDefinition, ddmStorageAdapterGetRequest.getPrimaryKey());
            ddmFormValues.setDDMFormFieldValues(this._getDDMFormFieldValues(ddmForm.getDDMFormFields(), ddmForm.getDefaultLocale(), objectEntry.getProperties()));
            ddmFormValues.setDefaultLocale(ddmForm.getDefaultLocale());
            return DDMStorageAdapterGetResponse.Builder.newBuilder((DDMFormValues)ddmFormValues).build();
        }
        catch (Exception exception) {
            throw new StorageException((Throwable)exception);
        }
    }

    public DDMStorageAdapterSaveResponse save(DDMStorageAdapterSaveRequest ddmStorageAdapterSaveRequest) throws StorageException {
        try {
            DDMFormInstance ddmFormInstance = ddmStorageAdapterSaveRequest.getDDMFormInstance();
            DDMFormInstanceSettings ddmFormInstanceSettings = ddmFormInstance.getSettingsModel();
            final ObjectDefinition objectDefinition = this._objectDefinitionLocalService.getObjectDefinition(GetterUtil.getLong((String)ddmFormInstanceSettings.objectDefinitionId()));
            ObjectEntryManager objectEntryManager = this._objectEntryManagerRegistry.getObjectEntryManager(objectDefinition.getCompanyId(), objectDefinition.getStorageType());
            final DDMFormValues ddmFormValues = ddmStorageAdapterSaveRequest.getDDMFormValues();
            DDMForm ddmForm = ddmFormValues.getDDMForm();
            com.liferay.object.rest.dto.v1_0.ObjectEntry objectEntry = objectEntryManager.addObjectEntry((DTOConverterContext)new DefaultDTOConverterContext(true, Collections.singletonMap("delete", Collections.singletonMap("delete", "")), null, null, null, ddmForm.getDefaultLocale(), null, this._userLocalService.getUser(ddmStorageAdapterSaveRequest.getUserId())), objectDefinition, new com.liferay.object.rest.dto.v1_0.ObjectEntry(){
                {
                    this.setProperties(() -> ObjectDDMStorageAdapter.this._toProperties(ddmFormValues.getDDMFormFieldValuesMap(true), ObjectFieldUtil.toObjectFieldsMap((List)ObjectDDMStorageAdapter.this._objectFieldLocalService.getObjectFields(objectDefinition.getObjectDefinitionId()))));
                }
            }, this._getScopeKey(ddmStorageAdapterSaveRequest.getGroupId(), objectDefinition));
            return DDMStorageAdapterSaveResponse.Builder.newBuilder((long)GetterUtil.getLong((Object)objectEntry.getId())).build();
        }
        catch (Exception exception) {
            throw new StorageException(exception.getMessage(), (Throwable)exception);
        }
    }

    private List<DDMFormFieldValue> _getDDMFormFieldValues(List<DDMFormField> ddmFormFields, Locale locale, Map<String, Object> properties) {
        return TransformUtil.transform(ddmFormFields, ddmFormField -> {
            String objectFieldName;
            LocalizedValue value;
            DDMFormFieldValue ddmFormFieldValue;
            block11: {
                ddmFormFieldValue = new DDMFormFieldValue();
                ddmFormFieldValue.setFieldReference(ddmFormField.getFieldReference());
                ddmFormFieldValue.setName(ddmFormField.getName());
                if (StringUtil.equals((String)ddmFormField.getType(), (String)"fieldset")) {
                    ddmFormFieldValue.setNestedDDMFormFields(this._getDDMFormFieldValues(ddmFormField.getNestedDDMFormFields(), locale, properties));
                    return ddmFormFieldValue;
                }
                value = new LocalizedValue(locale);
                objectFieldName = "";
                try {
                    JSONArray jsonArray = this._jsonFactory.createJSONArray(GetterUtil.getString((Object)ddmFormField.getProperty("objectFieldName")));
                    objectFieldName = jsonArray.getString(0);
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block11;
                    _log.debug((Throwable)exception);
                }
            }
            Object objectFieldValue = properties.get(objectFieldName);
            if (StringUtil.equals((String)ddmFormField.getType(), (String)"radio")) {
                JSONArray jsonArray = this._toJSONArray(objectFieldValue);
                value.addString(locale, jsonArray.getString(0));
            } else if (StringUtil.equals((String)ddmFormField.getType(), (String)"select")) {
                JSONArray jsonArray = this._toJSONArray(objectFieldValue);
                value.addString(locale, jsonArray.toString());
            } else if (objectFieldValue instanceof Double) {
                NumberFormat numberFormat = NumberFormat.getInstance(locale);
                value.addString(locale, numberFormat.format(objectFieldValue));
            } else if (objectFieldValue instanceof byte[]) {
                value.addString(locale, new String((byte[])objectFieldValue));
            } else {
                value.addString(locale, String.valueOf(objectFieldValue));
            }
            ddmFormFieldValue.setValue((Value)value);
            return ddmFormFieldValue;
        });
    }

    private String _getOptionReference(DDMFormField ddmFormField, String optionValue, String propertyName) {
        DDMFormFieldOptions ddmFormFieldOptions = (DDMFormFieldOptions)ddmFormField.getProperty(propertyName);
        return MapUtil.getString((Map)ddmFormFieldOptions.getOptionsReferences(), (Object)optionValue, (String)optionValue);
    }

    private String _getScopeKey(long groupId, ObjectDefinition objectDefinition) {
        ObjectScopeProvider objectScopeProvider = this._objectScopeProviderRegistry.getObjectScopeProvider(objectDefinition.getScope());
        if (!objectScopeProvider.isGroupAware()) {
            return null;
        }
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        return group.getGroupKey();
    }

    private String _getValueString(DDMFormField ddmFormField, Locale locale, ObjectField objectField, String valueString) throws Exception {
        if (StringUtil.equals((String)ddmFormField.getType(), (String)"checkbox_multiple") || StringUtil.equals((String)ddmFormField.getType(), (String)"grid") || StringUtil.equals((String)ddmFormField.getType(), (String)"select")) {
            StringBundler sb = this._toStringBundler(ddmFormField, valueString);
            if (sb.index() > 0) {
                sb.setIndex(sb.index() - 1);
            }
            return sb.toString();
        }
        if (StringUtil.equals((String)ddmFormField.getType(), (String)"document_library")) {
            JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
            return jsonObject.getString("fileEntryId");
        }
        if (StringUtil.equals((String)ddmFormField.getType(), (String)"radio")) {
            return this._getOptionReference(ddmFormField, valueString, "options");
        }
        if (Objects.equals(objectField.getDBType(), "BigDecimal") || Objects.equals(objectField.getDBType(), "Double")) {
            if (valueString.isEmpty()) {
                return String.valueOf(0.0);
            }
            NumberFormat numberFormat = NumberFormat.getInstance(locale);
            Number number = numberFormat.parse(valueString);
            if (Objects.equals(objectField.getDBType(), "BigDecimal")) {
                return String.valueOf(GetterUtil.get((Object)number, (Number)BigDecimal.ZERO));
            }
            return String.valueOf(GetterUtil.getDouble((Object)number));
        }
        return valueString;
    }

    private JSONArray _toJSONArray(Object objectFieldValue) {
        JSONArray jsonArray = this._jsonFactory.createJSONArray();
        if (objectFieldValue instanceof List) {
            for (ListEntry listEntry : (List)objectFieldValue) {
                jsonArray.put(listEntry.getName());
            }
        } else {
            ListEntry listEntry = (ListEntry)objectFieldValue;
            jsonArray.put(listEntry.getName());
        }
        return jsonArray;
    }

    private Map<String, Object> _toProperties(Map<String, List<DDMFormFieldValue>> ddmFormFieldValuesMap, Map<String, ObjectField> objectFieldsMap) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (List<DDMFormFieldValue> ddmFormFieldValues : ddmFormFieldValuesMap.values()) {
            for (DDMFormFieldValue ddmFormFieldValue : ddmFormFieldValues) {
                Value value;
                JSONArray jsonArray;
                ObjectField objectField;
                DDMFormField ddmFormField = ddmFormFieldValue.getDDMFormField();
                if (ddmFormField == null || (objectField = objectFieldsMap.get((jsonArray = this._jsonFactory.createJSONArray((String)ddmFormField.getProperty("objectFieldName"))).getString(0))) == null || (value = ddmFormFieldValue.getValue()) == null) continue;
                String valueString = this._getValueString(ddmFormField, value.getDefaultLocale(), objectField, value.getString(value.getDefaultLocale()));
                if (objectField.compareBusinessType("MultiselectPicklist")) {
                    properties.put(objectField.getName(), ListUtil.fromString((String)valueString, (String)", "));
                    continue;
                }
                if (objectField.compareBusinessType("Picklist")) {
                    properties.put(objectField.getName(), HashMapBuilder.put((Object)"key", (Object)valueString).build());
                    continue;
                }
                properties.put(objectField.getName(), valueString);
            }
        }
        return properties;
    }

    private StringBundler _toStringBundler(DDMFormField ddmFormField, String valueString) throws Exception {
        StringBundler sb = new StringBundler();
        if (!StringUtil.equals((String)ddmFormField.getType(), (String)"grid")) {
            for (Object optionValue : this._jsonFactory.createJSONArray(valueString)) {
                sb.append(this._getOptionReference(ddmFormField, optionValue.toString(), "options"));
                sb.append(", ");
            }
            return sb;
        }
        JSONObject jsonObject = this._jsonFactory.createJSONObject(valueString);
        for (String key : jsonObject.keySet()) {
            sb.append(this._getOptionReference(ddmFormField, key, "rows"));
            sb.append(": ");
            sb.append(this._getOptionReference(ddmFormField, jsonObject.getString(key), "columns"));
            sb.append(", ");
        }
        return sb;
    }
}

