/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.object.dynamic.data.mapping.internal.form.field.type;

import com.liferay.dynamic.data.mapping.form.field.type.BaseDDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldType;
import com.liferay.dynamic.data.mapping.form.field.type.DDMFormFieldTypeSettings;

import org.osgi.service.component.annotations.Component;

/**
 * @author Marco Leo
 */
@Component(
	immediate = true,
	property = {
		"ddm.form.field.type.data.domain=list",
		"ddm.form.field.type.description=object-relationship-field-type-description",
		"ddm.form.field.type.display.order:Integer=13",
		"ddm.form.field.type.group=basic",
		"ddm.form.field.type.icon=relationship",
		"ddm.form.field.type.label=object-relationship-field-type-label",
		"ddm.form.field.type.name=object-relationship",
		"ddm.form.field.type.system=true"
	},
	service = DDMFormFieldType.class
)
public class ObjectRelationshipDDMFormFieldType extends BaseDDMFormFieldType {

	@Override
	public Class<? extends DDMFormFieldTypeSettings>
		getDDMFormFieldTypeSettings() {

		return ObjectRelationshipDDMFormFieldTypeSettings.class;
	}

	@Override
	public String getModuleName() {
		return "dynamic-data-mapping-form-field-type/ObjectRelationship" +
			"/ObjectRelationship";
	}

	@Override
	public String getName() {
		return "object-relationship";
	}

}