/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.internal.model.listener;

import com.liferay.oauth2.provider.model.OAuth2ScopeGrant;
import com.liferay.oauth2.provider.service.OAuth2ApplicationLocalService;
import com.liferay.oauth2.provider.service.OAuth2ScopeGrantLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.ModelListener;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CompanyModelListener
extends BaseModelListener<Company> {
    @Reference
    private OAuth2ApplicationLocalService _oAuth2ApplicationLocalService;
    @Reference
    private OAuth2ScopeGrantLocalService _oAuth2ScopeGrantLocalService;

    public void onAfterRemove(Company company) throws ModelListenerException {
        try {
            this._oAuth2ApplicationLocalService.deleteOAuth2Applications(company.getCompanyId());
            this._deleteOAuth2ScopeGrant(company);
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    private void _deleteOAuth2ScopeGrant(Company company) throws PortalException {
        ActionableDynamicQuery actionableDynamicQuery = this._oAuth2ScopeGrantLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"companyId", (Object)company.getCompanyId())));
        actionableDynamicQuery.setPerformActionMethod(oAuth2ScopeGrant -> this._oAuth2ScopeGrantLocalService.deleteOAuth2ScopeGrant((OAuth2ScopeGrant)oAuth2ScopeGrant));
        actionableDynamicQuery.performActions();
    }
}

