/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.http;

import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.OAuth2ApplicationServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.util.List;

public class OAuth2ApplicationServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(OAuth2ApplicationServiceHttp.class);
    private static final Class<?>[] _addOAuth2ApplicationParameterTypes0 = new Class[]{List.class, Long.TYPE, String.class, Integer.TYPE, String.class, String.class, List.class, String.class, Long.TYPE, String.class, String.class, List.class, List.class, ServiceContext.class};
    private static final Class<?>[] _addOAuth2ApplicationParameterTypes1 = new Class[]{List.class, String.class, Integer.TYPE, String.class, String.class, List.class, String.class, Long.TYPE, String.class, String.class, List.class, List.class, ServiceContext.class};
    private static final Class<?>[] _deleteOAuth2ApplicationParameterTypes2 = new Class[]{Long.TYPE};
    private static final Class<?>[] _fetchOAuth2ApplicationParameterTypes3 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getOAuth2ApplicationParameterTypes4 = new Class[]{Long.TYPE};
    private static final Class<?>[] _getOAuth2ApplicationParameterTypes5 = new Class[]{Long.TYPE, String.class};
    private static final Class<?>[] _getOAuth2ApplicationsParameterTypes6 = new Class[]{Long.TYPE, Integer.TYPE, Integer.TYPE, OrderByComparator.class};
    private static final Class<?>[] _getOAuth2ApplicationsCountParameterTypes7 = new Class[]{Long.TYPE};
    private static final Class<?>[] _updateIconParameterTypes8 = new Class[]{Long.TYPE, InputStream.class};
    private static final Class<?>[] _updateOAuth2ApplicationParameterTypes9 = new Class[]{Long.TYPE, List.class, Long.TYPE, String.class, Integer.TYPE, String.class, String.class, List.class, String.class, Long.TYPE, String.class, String.class, List.class, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _updateOAuth2ApplicationParameterTypes10 = new Class[]{Long.TYPE, List.class, String.class, Integer.TYPE, String.class, String.class, List.class, String.class, Long.TYPE, String.class, String.class, List.class, Long.TYPE, ServiceContext.class};
    private static final Class<?>[] _updateScopeAliasesParameterTypes11 = new Class[]{Long.TYPE, List.class};

    public static OAuth2Application addOAuth2Application(HttpPrincipal httpPrincipal, List<GrantType> allowedGrantTypesList, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, List<String> scopeAliasesList, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "addOAuth2Application", (Class[])_addOAuth2ApplicationParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{allowedGrantTypesList, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, scopeAliasesList, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application addOAuth2Application(HttpPrincipal httpPrincipal, List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, List<String> scopeAliasesList, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "addOAuth2Application", (Class[])_addOAuth2ApplicationParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{allowedGrantTypesList, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, scopeAliasesList, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application deleteOAuth2Application(HttpPrincipal httpPrincipal, long oAuth2ApplicationId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "deleteOAuth2Application", (Class[])_deleteOAuth2ApplicationParameterTypes2);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application fetchOAuth2Application(HttpPrincipal httpPrincipal, long companyId, String clientId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "fetchOAuth2Application", (Class[])_fetchOAuth2ApplicationParameterTypes3);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, clientId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application getOAuth2Application(HttpPrincipal httpPrincipal, long oAuth2ApplicationId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "getOAuth2Application", (Class[])_getOAuth2ApplicationParameterTypes4);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application getOAuth2Application(HttpPrincipal httpPrincipal, long companyId, String clientId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "getOAuth2Application", (Class[])_getOAuth2ApplicationParameterTypes5);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, clientId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static List<OAuth2Application> getOAuth2Applications(HttpPrincipal httpPrincipal, long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "getOAuth2Applications", (Class[])_getOAuth2ApplicationsParameterTypes6);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId, start, end, orderByComparator});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (List)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static int getOAuth2ApplicationsCount(HttpPrincipal httpPrincipal, long companyId) {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "getOAuth2ApplicationsCount", (Class[])_getOAuth2ApplicationsCountParameterTypes7);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{companyId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
            return (Integer)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application updateIcon(HttpPrincipal httpPrincipal, long oAuth2ApplicationId, InputStream inputStream) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "updateIcon", (Class[])_updateIconParameterTypes8);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId, inputStream});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application updateOAuth2Application(HttpPrincipal httpPrincipal, long oAuth2ApplicationId, List<GrantType> allowedGrantTypesList, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, long auth2ApplicationScopeAliasesId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "updateOAuth2Application", (Class[])_updateOAuth2ApplicationParameterTypes9);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId, allowedGrantTypesList, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, auth2ApplicationScopeAliasesId, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application updateOAuth2Application(HttpPrincipal httpPrincipal, long oAuth2ApplicationId, List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, long auth2ApplicationScopeAliasesId, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "updateOAuth2Application", (Class[])_updateOAuth2ApplicationParameterTypes10);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId, allowedGrantTypesList, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, auth2ApplicationScopeAliasesId, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuth2Application updateScopeAliases(HttpPrincipal httpPrincipal, long oAuth2ApplicationId, List<String> scopeAliasesList) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuth2ApplicationServiceUtil.class, "updateScopeAliases", (Class[])_updateScopeAliasesParameterTypes11);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuth2ApplicationId, scopeAliasesList});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuth2Application)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

