/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.model.impl;

import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.model.impl.OAuth2ApplicationBaseImpl;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OAuth2ApplicationImpl
extends OAuth2ApplicationBaseImpl {
    public List<GrantType> getAllowedGrantTypesList() {
        Stream<String> stream = Arrays.stream(StringUtil.split((String)this.getAllowedGrantTypes()));
        return stream.map(GrantType::valueOf).collect(Collectors.toList());
    }

    public List<String> getFeaturesList() {
        return Arrays.asList(StringUtil.split((String)this.getFeatures()));
    }

    public List<String> getRedirectURIsList() {
        return Arrays.asList(StringUtil.split((String)this.getRedirectURIs(), (String)"\n"));
    }

    public void setAllowedGrantTypesList(List<GrantType> allowedGrantTypesList) {
        Stream stream = allowedGrantTypesList.stream();
        this.setAllowedGrantTypes(stream.map(Enum::toString).collect(Collectors.joining(",")));
    }

    public void setFeaturesList(List<String> featuresList) {
        this.setFeatures(StringUtil.merge(featuresList));
    }

    public void setRedirectURIsList(List<String> redirectURIsList) {
        String redirectURIs = StringUtil.merge(redirectURIsList, (String)"\n");
        this.setRedirectURIs(redirectURIs);
    }
}

