/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.impl;

import com.liferay.oauth2.provider.constants.GrantType;
import com.liferay.oauth2.provider.exception.OAuth2ApplicationClientCredentialUserIdException;
import com.liferay.oauth2.provider.model.OAuth2Application;
import com.liferay.oauth2.provider.service.base.OAuth2ApplicationServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.jsonwebservice.JSONWebService;
import com.liferay.portal.kernel.jsonwebservice.JSONWebServiceMode;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.InputStream;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@JSONWebService(mode=JSONWebServiceMode.IGNORE)
@Component(service={AopService.class})
public class OAuth2ApplicationServiceImpl
extends OAuth2ApplicationServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.oauth2.provider.model.OAuth2Application)")
    private ModelResourcePermission<OAuth2Application> _oAuth2ApplicationModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.model.User)")
    private ModelResourcePermission<User> _userModelResourcePermission;

    public OAuth2Application addOAuth2Application(List<GrantType> allowedGrantTypesList, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, List<String> scopeAliasesList, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(this._oAuth2ApplicationModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)0L, (long)0L, (String)"ADD_APPLICATION");
        User user = this.getUser();
        if (allowedGrantTypesList.contains(GrantType.CLIENT_CREDENTIALS) && clientCredentialUserId != user.getUserId()) {
            this._checkCanImpersonateClientCredentialUser(clientCredentialUserId);
        }
        return this.oAuth2ApplicationLocalService.addOAuth2Application(user.getCompanyId(), user.getUserId(), user.getFullName(), allowedGrantTypesList, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, scopeAliasesList, serviceContext);
    }

    @Deprecated
    public OAuth2Application addOAuth2Application(List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, List<String> scopeAliasesList, ServiceContext serviceContext) throws PortalException {
        ModelResourcePermissionHelper.check(this._oAuth2ApplicationModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)0L, (long)0L, (String)"ADD_APPLICATION");
        User user = this.getUser();
        return this.oAuth2ApplicationLocalService.addOAuth2Application(user.getCompanyId(), user.getUserId(), user.getFullName(), allowedGrantTypesList, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, scopeAliasesList, serviceContext);
    }

    public OAuth2Application deleteOAuth2Application(long oAuth2ApplicationId) throws PortalException {
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.oAuth2ApplicationLocalService.getOAuth2Application(oAuth2ApplicationId), "DELETE");
        return this.oAuth2ApplicationLocalService.deleteOAuth2Application(oAuth2ApplicationId);
    }

    public OAuth2Application fetchOAuth2Application(long companyId, String clientId) throws PortalException {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.fetchOAuth2Application(companyId, clientId);
        if (oAuth2Application != null) {
            this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuth2Application, "VIEW");
        }
        return oAuth2Application;
    }

    public OAuth2Application getOAuth2Application(long oAuth2ApplicationId) throws PortalException {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.getOAuth2Application(oAuth2ApplicationId);
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuth2Application, "VIEW");
        return oAuth2Application;
    }

    public OAuth2Application getOAuth2Application(long companyId, String clientId) throws PortalException {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.getOAuth2Application(companyId, clientId);
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuth2Application, "VIEW");
        return oAuth2Application;
    }

    public List<OAuth2Application> getOAuth2Applications(long companyId, int start, int end, OrderByComparator<OAuth2Application> orderByComparator) {
        return this.oAuth2ApplicationPersistence.filterFindByC(companyId, start, end, orderByComparator);
    }

    public int getOAuth2ApplicationsCount(long companyId) {
        return this.oAuth2ApplicationPersistence.filterCountByC(companyId);
    }

    public OAuth2Application updateIcon(long oAuth2ApplicationId, InputStream inputStream) throws PortalException {
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.oAuth2ApplicationLocalService.getOAuth2Application(oAuth2ApplicationId), "UPDATE");
        return this.oAuth2ApplicationLocalService.updateIcon(oAuth2ApplicationId, inputStream);
    }

    public OAuth2Application updateOAuth2Application(long oAuth2ApplicationId, List<GrantType> allowedGrantTypesList, long clientCredentialUserId, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, long auth2ApplicationScopeAliasesId, ServiceContext serviceContext) throws PortalException {
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)this.oAuth2ApplicationLocalService.getOAuth2Application(oAuth2ApplicationId), "UPDATE");
        if (allowedGrantTypesList.contains(GrantType.CLIENT_CREDENTIALS)) {
            this._checkCanImpersonateClientCredentialUser(clientCredentialUserId);
        }
        return this.oAuth2ApplicationLocalService.updateOAuth2Application(oAuth2ApplicationId, allowedGrantTypesList, clientCredentialUserId, clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, auth2ApplicationScopeAliasesId, serviceContext);
    }

    @Deprecated
    public OAuth2Application updateOAuth2Application(long oAuth2ApplicationId, List<GrantType> allowedGrantTypesList, String clientId, int clientProfile, String clientSecret, String description, List<String> featuresList, String homePageURL, long iconFileEntryId, String name, String privacyPolicyURL, List<String> redirectURIsList, long auth2ApplicationScopeAliasesId, ServiceContext serviceContext) throws PortalException {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.getOAuth2Application(oAuth2ApplicationId);
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuth2Application, "UPDATE");
        return this.oAuth2ApplicationLocalService.updateOAuth2Application(oAuth2ApplicationId, allowedGrantTypesList, oAuth2Application.getClientCredentialUserId(), clientId, clientProfile, clientSecret, description, featuresList, homePageURL, iconFileEntryId, name, privacyPolicyURL, redirectURIsList, auth2ApplicationScopeAliasesId, serviceContext);
    }

    public OAuth2Application updateScopeAliases(long oAuth2ApplicationId, List<String> scopeAliasesList) throws PortalException {
        OAuth2Application oAuth2Application = this.oAuth2ApplicationLocalService.getOAuth2Application(oAuth2ApplicationId);
        this._oAuth2ApplicationModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)oAuth2Application, "UPDATE");
        User user = this.getUser();
        List allowedGrantTypesList = oAuth2Application.getAllowedGrantTypesList();
        if (allowedGrantTypesList.contains(GrantType.CLIENT_CREDENTIALS)) {
            this._checkCanImpersonateClientCredentialUser(oAuth2Application.getClientCredentialUserId());
        }
        return this.oAuth2ApplicationLocalService.updateScopeAliases(user.getUserId(), user.getFullName(), oAuth2ApplicationId, scopeAliasesList);
    }

    private void _checkCanImpersonateClientCredentialUser(long clientCredentialUserId) throws OAuth2ApplicationClientCredentialUserIdException, PortalException, PrincipalException {
        User user = this.getUser();
        if (clientCredentialUserId != user.getUserId() && !ModelResourcePermissionHelper.contains(this._userModelResourcePermission, (PermissionChecker)this.getPermissionChecker(), (long)0L, (long)clientCredentialUserId, (String)"IMPERSONATE")) {
            User clientCredentialUser = this.userLocalService.fetchUser(clientCredentialUserId);
            String clientCredentialUserScreenName = null;
            if (clientCredentialUser != null) {
                clientCredentialUserScreenName = clientCredentialUser.getScreenName();
            }
            throw new OAuth2ApplicationClientCredentialUserIdException(user.getUserId(), user.getScreenName(), clientCredentialUserId, clientCredentialUserScreenName);
        }
    }
}

