/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth2.provider.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.oauth2.provider.model.OAuth2Authorization;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalService;
import com.liferay.oauth2.provider.service.OAuth2AuthorizationLocalServiceUtil;
import com.liferay.oauth2.provider.service.persistence.OAuth2AuthorizationPersistence;
import com.liferay.oauth2.provider.service.persistence.OAuth2ScopeGrantFinder;
import com.liferay.oauth2.provider.service.persistence.OAuth2ScopeGrantPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class OAuth2AuthorizationLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
OAuth2AuthorizationLocalService {
    protected OAuth2AuthorizationLocalService oAuth2AuthorizationLocalService;
    @Reference
    protected OAuth2AuthorizationPersistence oAuth2AuthorizationPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected OAuth2ScopeGrantPersistence oAuth2ScopeGrantPersistence;
    @Reference
    protected OAuth2ScopeGrantFinder oAuth2ScopeGrantFinder;
    private static final Log _log = LogFactoryUtil.getLog(OAuth2AuthorizationLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public OAuth2Authorization addOAuth2Authorization(OAuth2Authorization oAuth2Authorization) {
        oAuth2Authorization.setNew(true);
        return (OAuth2Authorization)this.oAuth2AuthorizationPersistence.update((BaseModel)oAuth2Authorization);
    }

    @Transactional(enabled=false)
    public OAuth2Authorization createOAuth2Authorization(long oAuth2AuthorizationId) {
        return this.oAuth2AuthorizationPersistence.create(oAuth2AuthorizationId);
    }

    @Indexable(type=IndexableType.DELETE)
    public OAuth2Authorization deleteOAuth2Authorization(long oAuth2AuthorizationId) throws PortalException {
        return this.oAuth2AuthorizationPersistence.remove(oAuth2AuthorizationId);
    }

    @Indexable(type=IndexableType.DELETE)
    public OAuth2Authorization deleteOAuth2Authorization(OAuth2Authorization oAuth2Authorization) {
        return (OAuth2Authorization)this.oAuth2AuthorizationPersistence.remove((BaseModel)oAuth2Authorization);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(OAuth2Authorization.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.oAuth2AuthorizationPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.oAuth2AuthorizationPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.oAuth2AuthorizationPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.oAuth2AuthorizationPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.oAuth2AuthorizationPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public OAuth2Authorization fetchOAuth2Authorization(long oAuth2AuthorizationId) {
        return this.oAuth2AuthorizationPersistence.fetchByPrimaryKey(oAuth2AuthorizationId);
    }

    public OAuth2Authorization getOAuth2Authorization(long oAuth2AuthorizationId) throws PortalException {
        return this.oAuth2AuthorizationPersistence.findByPrimaryKey(oAuth2AuthorizationId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.oAuth2AuthorizationLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(OAuth2Authorization.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("oAuth2AuthorizationId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.oAuth2AuthorizationLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(OAuth2Authorization.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("oAuth2AuthorizationId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.oAuth2AuthorizationLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(OAuth2Authorization.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("oAuth2AuthorizationId");
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.oAuth2AuthorizationLocalService.deleteOAuth2Authorization((OAuth2Authorization)persistedModel);
    }

    public BasePersistence<OAuth2Authorization> getBasePersistence() {
        return this.oAuth2AuthorizationPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.oAuth2AuthorizationPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<OAuth2Authorization> getOAuth2Authorizations(int start, int end) {
        return this.oAuth2AuthorizationPersistence.findAll(start, end);
    }

    public int getOAuth2AuthorizationsCount() {
        return this.oAuth2AuthorizationPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public OAuth2Authorization updateOAuth2Authorization(OAuth2Authorization oAuth2Authorization) {
        return (OAuth2Authorization)this.oAuth2AuthorizationPersistence.update((BaseModel)oAuth2Authorization);
    }

    public void addOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, long oAuth2AuthorizationId) {
        this.oAuth2ScopeGrantPersistence.addOAuth2Authorization(oAuth2ScopeGrantId, oAuth2AuthorizationId);
    }

    public void addOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, OAuth2Authorization oAuth2Authorization) {
        this.oAuth2ScopeGrantPersistence.addOAuth2Authorization(oAuth2ScopeGrantId, oAuth2Authorization);
    }

    public void addOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, long[] oAuth2AuthorizationIds) {
        this.oAuth2ScopeGrantPersistence.addOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2AuthorizationIds);
    }

    public void addOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, List<OAuth2Authorization> oAuth2Authorizations) {
        this.oAuth2ScopeGrantPersistence.addOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2Authorizations);
    }

    public void clearOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId) {
        this.oAuth2ScopeGrantPersistence.clearOAuth2Authorizations(oAuth2ScopeGrantId);
    }

    public void deleteOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, long oAuth2AuthorizationId) {
        this.oAuth2ScopeGrantPersistence.removeOAuth2Authorization(oAuth2ScopeGrantId, oAuth2AuthorizationId);
    }

    public void deleteOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, OAuth2Authorization oAuth2Authorization) {
        this.oAuth2ScopeGrantPersistence.removeOAuth2Authorization(oAuth2ScopeGrantId, oAuth2Authorization);
    }

    public void deleteOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, long[] oAuth2AuthorizationIds) {
        this.oAuth2ScopeGrantPersistence.removeOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2AuthorizationIds);
    }

    public void deleteOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, List<OAuth2Authorization> oAuth2Authorizations) {
        this.oAuth2ScopeGrantPersistence.removeOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2Authorizations);
    }

    public long[] getOAuth2ScopeGrantPrimaryKeys(long oAuth2AuthorizationId) {
        return this.oAuth2AuthorizationPersistence.getOAuth2ScopeGrantPrimaryKeys(oAuth2AuthorizationId);
    }

    public List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId) {
        return this.oAuth2AuthorizationPersistence.getOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId);
    }

    public List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, int start, int end) {
        return this.oAuth2AuthorizationPersistence.getOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, start, end);
    }

    public List<OAuth2Authorization> getOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, int start, int end, OrderByComparator<OAuth2Authorization> orderByComparator) {
        return this.oAuth2AuthorizationPersistence.getOAuth2ScopeGrantOAuth2Authorizations(oAuth2ScopeGrantId, start, end, orderByComparator);
    }

    public int getOAuth2ScopeGrantOAuth2AuthorizationsCount(long oAuth2ScopeGrantId) {
        return this.oAuth2ScopeGrantPersistence.getOAuth2AuthorizationsSize(oAuth2ScopeGrantId);
    }

    public boolean hasOAuth2ScopeGrantOAuth2Authorization(long oAuth2ScopeGrantId, long oAuth2AuthorizationId) {
        return this.oAuth2ScopeGrantPersistence.containsOAuth2Authorization(oAuth2ScopeGrantId, oAuth2AuthorizationId);
    }

    public boolean hasOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId) {
        return this.oAuth2ScopeGrantPersistence.containsOAuth2Authorizations(oAuth2ScopeGrantId);
    }

    public void setOAuth2ScopeGrantOAuth2Authorizations(long oAuth2ScopeGrantId, long[] oAuth2AuthorizationIds) {
        this.oAuth2ScopeGrantPersistence.setOAuth2Authorizations(oAuth2ScopeGrantId, oAuth2AuthorizationIds);
    }

    @Deactivate
    protected void deactivate() {
        OAuth2AuthorizationLocalServiceUtil.setService(null);
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{OAuth2AuthorizationLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.oAuth2AuthorizationLocalService = (OAuth2AuthorizationLocalService)aopProxy;
        OAuth2AuthorizationLocalServiceUtil.setService((OAuth2AuthorizationLocalService)this.oAuth2AuthorizationLocalService);
    }

    public String getOSGiServiceIdentifier() {
        return OAuth2AuthorizationLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return OAuth2Authorization.class;
    }

    protected String getModelClassName() {
        return OAuth2Authorization.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.oAuth2AuthorizationPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

