/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.persistence.impl;

import com.liferay.oauth.exception.NoSuchUserException;
import com.liferay.oauth.model.OAuthUser;
import com.liferay.oauth.model.OAuthUserTable;
import com.liferay.oauth.model.impl.OAuthUserImpl;
import com.liferay.oauth.model.impl.OAuthUserModelImpl;
import com.liferay.oauth.service.persistence.OAuthUserPersistence;
import com.liferay.oauth.service.persistence.OAuthUserUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.ArgumentsResolver;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.permission.InlineSQLHelperUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OAuthUserPersistence.class})
public class OAuthUserPersistenceImpl
extends BasePersistenceImpl<OAuthUser>
implements OAuthUserPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuthUserImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "oAuthUser.userId = ?";
    private FinderPath _finderPathWithPaginationFindByOAuthApplicationId;
    private FinderPath _finderPathWithoutPaginationFindByOAuthApplicationId;
    private FinderPath _finderPathCountByOAuthApplicationId;
    private static final String _FINDER_COLUMN_OAUTHAPPLICATIONID_OAUTHAPPLICATIONID_2 = "oAuthUser.oAuthApplicationId = ?";
    private FinderPath _finderPathFetchByAccessToken;
    private FinderPath _finderPathCountByAccessToken;
    private static final String _FINDER_COLUMN_ACCESSTOKEN_ACCESSTOKEN_2 = "oAuthUser.accessToken = ?";
    private static final String _FINDER_COLUMN_ACCESSTOKEN_ACCESSTOKEN_3 = "(oAuthUser.accessToken IS NULL OR oAuthUser.accessToken = '')";
    private FinderPath _finderPathFetchByU_OAI;
    private FinderPath _finderPathCountByU_OAI;
    private static final String _FINDER_COLUMN_U_OAI_USERID_2 = "oAuthUser.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_OAI_OAUTHAPPLICATIONID_2 = "oAuthUser.oAuthApplicationId = ?";
    private int _valueObjectFinderCacheListThreshold;
    private BundleContext _bundleContext;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OAUTHUSER = "SELECT oAuthUser FROM OAuthUser oAuthUser";
    private static final String _SQL_SELECT_OAUTHUSER_WHERE = "SELECT oAuthUser FROM OAuthUser oAuthUser WHERE ";
    private static final String _SQL_COUNT_OAUTHUSER = "SELECT COUNT(oAuthUser) FROM OAuthUser oAuthUser";
    private static final String _SQL_COUNT_OAUTHUSER_WHERE = "SELECT COUNT(oAuthUser) FROM OAuthUser oAuthUser WHERE ";
    private static final String _FILTER_ENTITY_TABLE_FILTER_PK_COLUMN = "oAuthUser.oAuthUserId";
    private static final String _FILTER_SQL_SELECT_OAUTHUSER_WHERE = "SELECT DISTINCT {oAuthUser.*} FROM OAuth_OAuthUser oAuthUser WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_1 = "SELECT {OAuth_OAuthUser.*} FROM (SELECT DISTINCT oAuthUser.oAuthUserId FROM OAuth_OAuthUser oAuthUser WHERE ";
    private static final String _FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_2 = ") TEMP_TABLE INNER JOIN OAuth_OAuthUser ON TEMP_TABLE.oAuthUserId = OAuth_OAuthUser.oAuthUserId";
    private static final String _FILTER_SQL_COUNT_OAUTHUSER_WHERE = "SELECT COUNT(DISTINCT oAuthUser.oAuthUserId) AS COUNT_VALUE FROM OAuth_OAuthUser oAuthUser WHERE ";
    private static final String _FILTER_ENTITY_ALIAS = "oAuthUser";
    private static final String _FILTER_ENTITY_TABLE = "OAuth_OAuthUser";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuthUser.";
    private static final String _ORDER_BY_ENTITY_TABLE = "OAuth_OAuthUser.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuthUser exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuthUser exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuthUserPersistenceImpl.class);
    private Set<ServiceRegistration<FinderPath>> _serviceRegistrations = new HashSet<ServiceRegistration<FinderPath>>();
    private ServiceRegistration<ArgumentsResolver> _argumentsResolverServiceRegistration;

    public List<OAuthUser> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<OAuthUser> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<OAuthUser> findByUserId(long userId, int start, int end, OrderByComparator<OAuthUser> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<OAuthUser> findByUserId(long userId, int start, int end, OrderByComparator<OAuthUser> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuthUser oAuthUser : list) {
                if (userId == oAuthUser.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHUSER_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthUser findByUserId_First(long userId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        OAuthUser oAuthUser = this.fetchByUserId_First(userId, orderByComparator);
        if (oAuthUser != null) {
            return oAuthUser;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchUserException(sb.toString());
    }

    public OAuthUser fetchByUserId_First(long userId, OrderByComparator<OAuthUser> orderByComparator) {
        List<OAuthUser> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthUser findByUserId_Last(long userId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        OAuthUser oAuthUser = this.fetchByUserId_Last(userId, orderByComparator);
        if (oAuthUser != null) {
            return oAuthUser;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchUserException(sb.toString());
    }

    public OAuthUser fetchByUserId_Last(long userId, OrderByComparator<OAuthUser> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<OAuthUser> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthUser[] findByUserId_PrevAndNext(long oAuthUserId, long userId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        OAuthUser oAuthUser = this.findByPrimaryKey(oAuthUserId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthUser[] array = new OAuthUserImpl[]{this.getByUserId_PrevAndNext(session, oAuthUser, userId, orderByComparator, true), oAuthUser, this.getByUserId_PrevAndNext(session, oAuthUser, userId, orderByComparator, false)};
            OAuthUser[] oAuthUserArray = array;
            return oAuthUserArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthUser getByUserId_PrevAndNext(Session session, OAuthUser oAuthUser, long userId, OrderByComparator<OAuthUser> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTHUSER_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthUser)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthUser)list.get(1);
        }
        return null;
    }

    public List<OAuthUser> filterFindByUserId(long userId) {
        return this.filterFindByUserId(userId, -1, -1, null);
    }

    public List<OAuthUser> filterFindByUserId(long userId, int start, int end) {
        return this.filterFindByUserId(userId, start, end, null);
    }

    public List<OAuthUser> filterFindByUserId(long userId, int start, int end, OrderByComparator<OAuthUser> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUserId(userId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
        } else {
            sb.append(" ORDER BY OAuth_OAuthUser.oAuthUserId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthUser.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthUserImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthUserImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(userId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuthUser[] filterFindByUserId_PrevAndNext(long oAuthUserId, long userId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByUserId_PrevAndNext(oAuthUserId, userId, orderByComparator);
        }
        OAuthUser oAuthUser = this.findByPrimaryKey(oAuthUserId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthUser[] array = new OAuthUserImpl[]{this.filterGetByUserId_PrevAndNext(session, oAuthUser, userId, orderByComparator, true), oAuthUser, this.filterGetByUserId_PrevAndNext(session, oAuthUser, userId, orderByComparator, false)};
            OAuthUser[] oAuthUserArray = array;
            return oAuthUserArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthUser filterGetByUserId_PrevAndNext(Session session, OAuthUser oAuthUser, long userId, OrderByComparator<OAuthUser> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
        } else {
            sb.append(" ORDER BY OAuth_OAuthUser.oAuthUserId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthUser.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthUserImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthUserImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthUser)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuthUser)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (OAuthUser oAuthUser : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)oAuthUser);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHUSER_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByUserId(long userId) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.countByUserId(userId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_OAUTHUSER_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthUser.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(userId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<OAuthUser> findByOAuthApplicationId(long oAuthApplicationId) {
        return this.findByOAuthApplicationId(oAuthApplicationId, -1, -1, null);
    }

    public List<OAuthUser> findByOAuthApplicationId(long oAuthApplicationId, int start, int end) {
        return this.findByOAuthApplicationId(oAuthApplicationId, start, end, null);
    }

    public List<OAuthUser> findByOAuthApplicationId(long oAuthApplicationId, int start, int end, OrderByComparator<OAuthUser> orderByComparator) {
        return this.findByOAuthApplicationId(oAuthApplicationId, start, end, orderByComparator, true);
    }

    public List<OAuthUser> findByOAuthApplicationId(long oAuthApplicationId, int start, int end, OrderByComparator<OAuthUser> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByOAuthApplicationId;
                finderArgs = new Object[]{oAuthApplicationId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByOAuthApplicationId;
            finderArgs = new Object[]{oAuthApplicationId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuthUser oAuthUser : list) {
                if (oAuthApplicationId == oAuthUser.getOAuthApplicationId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHUSER_WHERE);
            sb.append("oAuthUser.oAuthApplicationId = ?");
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(oAuthApplicationId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthUser findByOAuthApplicationId_First(long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        OAuthUser oAuthUser = this.fetchByOAuthApplicationId_First(oAuthApplicationId, orderByComparator);
        if (oAuthUser != null) {
            return oAuthUser;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("oAuthApplicationId=");
        sb.append(oAuthApplicationId);
        sb.append("}");
        throw new NoSuchUserException(sb.toString());
    }

    public OAuthUser fetchByOAuthApplicationId_First(long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator) {
        List<OAuthUser> list = this.findByOAuthApplicationId(oAuthApplicationId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthUser findByOAuthApplicationId_Last(long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        OAuthUser oAuthUser = this.fetchByOAuthApplicationId_Last(oAuthApplicationId, orderByComparator);
        if (oAuthUser != null) {
            return oAuthUser;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("oAuthApplicationId=");
        sb.append(oAuthApplicationId);
        sb.append("}");
        throw new NoSuchUserException(sb.toString());
    }

    public OAuthUser fetchByOAuthApplicationId_Last(long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator) {
        int count = this.countByOAuthApplicationId(oAuthApplicationId);
        if (count == 0) {
            return null;
        }
        List<OAuthUser> list = this.findByOAuthApplicationId(oAuthApplicationId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthUser[] findByOAuthApplicationId_PrevAndNext(long oAuthUserId, long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        OAuthUser oAuthUser = this.findByPrimaryKey(oAuthUserId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthUser[] array = new OAuthUserImpl[]{this.getByOAuthApplicationId_PrevAndNext(session, oAuthUser, oAuthApplicationId, orderByComparator, true), oAuthUser, this.getByOAuthApplicationId_PrevAndNext(session, oAuthUser, oAuthApplicationId, orderByComparator, false)};
            OAuthUser[] oAuthUserArray = array;
            return oAuthUserArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthUser getByOAuthApplicationId_PrevAndNext(Session session, OAuthUser oAuthUser, long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTHUSER_WHERE);
        sb.append("oAuthUser.oAuthApplicationId = ?");
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(oAuthApplicationId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthUser)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthUser)list.get(1);
        }
        return null;
    }

    public List<OAuthUser> filterFindByOAuthApplicationId(long oAuthApplicationId) {
        return this.filterFindByOAuthApplicationId(oAuthApplicationId, -1, -1, null);
    }

    public List<OAuthUser> filterFindByOAuthApplicationId(long oAuthApplicationId, int start, int end) {
        return this.filterFindByOAuthApplicationId(oAuthApplicationId, start, end, null);
    }

    public List<OAuthUser> filterFindByOAuthApplicationId(long oAuthApplicationId, int start, int end, OrderByComparator<OAuthUser> orderByComparator) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByOAuthApplicationId(oAuthApplicationId, start, end, orderByComparator);
        }
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuthUser.oAuthApplicationId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            if (this.getDB().isSupportsInlineDistinct()) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator, true);
            } else {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_TABLE, orderByComparator, true);
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
        } else {
            sb.append(" ORDER BY OAuth_OAuthUser.oAuthUserId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthUser.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            if (this.getDB().isSupportsInlineDistinct()) {
                sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthUserImpl.class);
            } else {
                sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthUserImpl.class);
            }
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(oAuthApplicationId);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuthUser[] filterFindByOAuthApplicationId_PrevAndNext(long oAuthUserId, long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator) throws NoSuchUserException {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.findByOAuthApplicationId_PrevAndNext(oAuthUserId, oAuthApplicationId, orderByComparator);
        }
        OAuthUser oAuthUser = this.findByPrimaryKey(oAuthUserId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthUser[] array = new OAuthUserImpl[]{this.filterGetByOAuthApplicationId_PrevAndNext(session, oAuthUser, oAuthApplicationId, orderByComparator, true), oAuthUser, this.filterGetByOAuthApplicationId_PrevAndNext(session, oAuthUser, oAuthApplicationId, orderByComparator, false)};
            OAuthUser[] oAuthUserArray = array;
            return oAuthUserArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthUser filterGetByOAuthApplicationId_PrevAndNext(Session session, OAuthUser oAuthUser, long oAuthApplicationId, OrderByComparator<OAuthUser> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_WHERE);
        } else {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_1);
        }
        sb.append("oAuthUser.oAuthApplicationId = ?");
        if (!this.getDB().isSupportsInlineDistinct()) {
            sb.append(_FILTER_SQL_SELECT_OAUTHUSER_NO_INLINE_DISTINCT_WHERE_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByConditionFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByConditionFields[i], true));
                }
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                if (this.getDB().isSupportsInlineDistinct()) {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_ALIAS, orderByFields[i], true));
                } else {
                    sb.append(this.getColumnName(_ORDER_BY_ENTITY_TABLE, orderByFields[i], true));
                }
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else if (this.getDB().isSupportsInlineDistinct()) {
            sb.append(" ORDER BY oAuthUser.oAuthUserId ASC");
        } else {
            sb.append(" ORDER BY OAuth_OAuthUser.oAuthUserId ASC");
        }
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthUser.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
        sqlQuery.setFirstResult(0);
        sqlQuery.setMaxResults(2);
        if (this.getDB().isSupportsInlineDistinct()) {
            sqlQuery.addEntity(_FILTER_ENTITY_ALIAS, OAuthUserImpl.class);
        } else {
            sqlQuery.addEntity(_FILTER_ENTITY_TABLE, OAuthUserImpl.class);
        }
        QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
        queryPos.add(oAuthApplicationId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthUser)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = sqlQuery.list()).size() == 2) {
            return (OAuthUser)list.get(1);
        }
        return null;
    }

    public void removeByOAuthApplicationId(long oAuthApplicationId) {
        for (OAuthUser oAuthUser : this.findByOAuthApplicationId(oAuthApplicationId, -1, -1, null)) {
            this.remove((BaseModel)oAuthUser);
        }
    }

    public int countByOAuthApplicationId(long oAuthApplicationId) {
        FinderPath finderPath = this._finderPathCountByOAuthApplicationId;
        Object[] finderArgs = new Object[]{oAuthApplicationId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHUSER_WHERE);
            sb.append("oAuthUser.oAuthApplicationId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(oAuthApplicationId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public int filterCountByOAuthApplicationId(long oAuthApplicationId) {
        if (!InlineSQLHelperUtil.isEnabled()) {
            return this.countByOAuthApplicationId(oAuthApplicationId);
        }
        StringBundler sb = new StringBundler(2);
        sb.append(_FILTER_SQL_COUNT_OAUTHUSER_WHERE);
        sb.append("oAuthUser.oAuthApplicationId = ?");
        String sql = InlineSQLHelperUtil.replacePermissionCheck((String)sb.toString(), (String)OAuthUser.class.getName(), (String)_FILTER_ENTITY_TABLE_FILTER_PK_COLUMN);
        Session session = null;
        try {
            session = this.openSession();
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(oAuthApplicationId);
            Long count = (Long)sqlQuery.uniqueResult();
            int n = count.intValue();
            return n;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public OAuthUser findByAccessToken(String accessToken) throws NoSuchUserException {
        OAuthUser oAuthUser = this.fetchByAccessToken(accessToken);
        if (oAuthUser == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("accessToken=");
            sb.append(accessToken);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchUserException(sb.toString());
        }
        return oAuthUser;
    }

    public OAuthUser fetchByAccessToken(String accessToken) {
        return this.fetchByAccessToken(accessToken, true);
    }

    public OAuthUser fetchByAccessToken(String accessToken, boolean useFinderCache) {
        OAuthUser oAuthUser;
        accessToken = Objects.toString(accessToken, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{accessToken};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByAccessToken, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof OAuthUser && !Objects.equals(accessToken, (oAuthUser = (OAuthUser)result).getAccessToken())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHUSER_WHERE);
            boolean bindAccessToken = false;
            if (accessToken.isEmpty()) {
                sb.append(_FINDER_COLUMN_ACCESSTOKEN_ACCESSTOKEN_3);
            } else {
                bindAccessToken = true;
                sb.append(_FINDER_COLUMN_ACCESSTOKEN_ACCESSTOKEN_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindAccessToken) {
                    queryPos.add(accessToken);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByAccessToken, finderArgs, (Object)list);
                    }
                } else {
                    OAuthUser oAuthUser2 = (OAuthUser)list.get(0);
                    result = oAuthUser2;
                    this.cacheResult(oAuthUser2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuthUser)result;
    }

    public OAuthUser removeByAccessToken(String accessToken) throws NoSuchUserException {
        OAuthUser oAuthUser = this.findByAccessToken(accessToken);
        return (OAuthUser)this.remove((BaseModel)oAuthUser);
    }

    public int countByAccessToken(String accessToken) {
        accessToken = Objects.toString(accessToken, "");
        FinderPath finderPath = this._finderPathCountByAccessToken;
        Object[] finderArgs = new Object[]{accessToken};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHUSER_WHERE);
            boolean bindAccessToken = false;
            if (accessToken.isEmpty()) {
                sb.append(_FINDER_COLUMN_ACCESSTOKEN_ACCESSTOKEN_3);
            } else {
                bindAccessToken = true;
                sb.append(_FINDER_COLUMN_ACCESSTOKEN_ACCESSTOKEN_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindAccessToken) {
                    queryPos.add(accessToken);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuthUser findByU_OAI(long userId, long oAuthApplicationId) throws NoSuchUserException {
        OAuthUser oAuthUser = this.fetchByU_OAI(userId, oAuthApplicationId);
        if (oAuthUser == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("userId=");
            sb.append(userId);
            sb.append(", oAuthApplicationId=");
            sb.append(oAuthApplicationId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchUserException(sb.toString());
        }
        return oAuthUser;
    }

    public OAuthUser fetchByU_OAI(long userId, long oAuthApplicationId) {
        return this.fetchByU_OAI(userId, oAuthApplicationId, true);
    }

    public OAuthUser fetchByU_OAI(long userId, long oAuthApplicationId, boolean useFinderCache) {
        OAuthUser oAuthUser;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{userId, oAuthApplicationId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByU_OAI, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof OAuthUser && (userId != (oAuthUser = (OAuthUser)result).getUserId() || oAuthApplicationId != oAuthUser.getOAuthApplicationId())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTHUSER_WHERE);
            sb.append(_FINDER_COLUMN_U_OAI_USERID_2);
            sb.append("oAuthUser.oAuthApplicationId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                queryPos.add(oAuthApplicationId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByU_OAI, finderArgs, (Object)list);
                    }
                } else {
                    OAuthUser oAuthUser2 = (OAuthUser)list.get(0);
                    result = oAuthUser2;
                    this.cacheResult(oAuthUser2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuthUser)result;
    }

    public OAuthUser removeByU_OAI(long userId, long oAuthApplicationId) throws NoSuchUserException {
        OAuthUser oAuthUser = this.findByU_OAI(userId, oAuthApplicationId);
        return (OAuthUser)this.remove((BaseModel)oAuthUser);
    }

    public int countByU_OAI(long userId, long oAuthApplicationId) {
        FinderPath finderPath = this._finderPathCountByU_OAI;
        Object[] finderArgs = new Object[]{userId, oAuthApplicationId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OAUTHUSER_WHERE);
            sb.append(_FINDER_COLUMN_U_OAI_USERID_2);
            sb.append("oAuthUser.oAuthApplicationId = ?");
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                queryPos.add(oAuthApplicationId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuthUserPersistenceImpl() {
        this.setModelClass(OAuthUser.class);
        this.setModelImplClass(OAuthUserImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)OAuthUserTable.INSTANCE);
    }

    public void cacheResult(OAuthUser oAuthUser) {
        this.entityCache.putResult(OAuthUserImpl.class, (Serializable)Long.valueOf(oAuthUser.getPrimaryKey()), (Serializable)oAuthUser);
        this.finderCache.putResult(this._finderPathFetchByAccessToken, new Object[]{oAuthUser.getAccessToken()}, (Object)oAuthUser);
        this.finderCache.putResult(this._finderPathFetchByU_OAI, new Object[]{oAuthUser.getUserId(), oAuthUser.getOAuthApplicationId()}, (Object)oAuthUser);
    }

    public void cacheResult(List<OAuthUser> oAuthUsers) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && oAuthUsers.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (OAuthUser oAuthUser : oAuthUsers) {
            if (this.entityCache.getResult(OAuthUserImpl.class, (Serializable)Long.valueOf(oAuthUser.getPrimaryKey())) != null) continue;
            this.cacheResult(oAuthUser);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuthUserImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(OAuthUser oAuthUser) {
        this.entityCache.removeResult(OAuthUserImpl.class, (BaseModel)oAuthUser);
    }

    public void clearCache(List<OAuthUser> oAuthUsers) {
        for (OAuthUser oAuthUser : oAuthUsers) {
            this.entityCache.removeResult(OAuthUserImpl.class, (BaseModel)oAuthUser);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(OAuthUserImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(OAuthUserModelImpl oAuthUserModelImpl) {
        Object[] args = new Object[]{oAuthUserModelImpl.getAccessToken()};
        this.finderCache.putResult(this._finderPathCountByAccessToken, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByAccessToken, args, (Object)oAuthUserModelImpl, false);
        args = new Object[]{oAuthUserModelImpl.getUserId(), oAuthUserModelImpl.getOAuthApplicationId()};
        this.finderCache.putResult(this._finderPathCountByU_OAI, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByU_OAI, args, (Object)oAuthUserModelImpl, false);
    }

    public OAuthUser create(long oAuthUserId) {
        OAuthUserImpl oAuthUser = new OAuthUserImpl();
        oAuthUser.setNew(true);
        oAuthUser.setPrimaryKey(oAuthUserId);
        oAuthUser.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuthUser;
    }

    public OAuthUser remove(long oAuthUserId) throws NoSuchUserException {
        return this.remove(Long.valueOf(oAuthUserId));
    }

    public OAuthUser remove(Serializable primaryKey) throws NoSuchUserException {
        Session session = null;
        try {
            session = this.openSession();
            OAuthUser oAuthUser = (OAuthUser)session.get(OAuthUserImpl.class, primaryKey);
            if (oAuthUser == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchUserException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OAuthUser oAuthUser2 = (OAuthUser)this.remove((BaseModel)oAuthUser);
            return oAuthUser2;
        }
        catch (NoSuchUserException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthUser removeImpl(OAuthUser oAuthUser) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuthUser)) {
                oAuthUser = (OAuthUser)session.get(OAuthUserImpl.class, oAuthUser.getPrimaryKeyObj());
            }
            if (oAuthUser != null) {
                session.delete((Object)oAuthUser);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuthUser != null) {
            this.clearCache(oAuthUser);
        }
        return oAuthUser;
    }

    public OAuthUser updateImpl(OAuthUser oAuthUser) {
        boolean isNew = oAuthUser.isNew();
        if (!(oAuthUser instanceof OAuthUserModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(oAuthUser.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuthUser);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuthUser proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuthUser implementation " + oAuthUser.getClass());
        }
        OAuthUserModelImpl oAuthUserModelImpl = (OAuthUserModelImpl)oAuthUser;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && oAuthUser.getCreateDate() == null) {
            if (serviceContext == null) {
                oAuthUser.setCreateDate(date);
            } else {
                oAuthUser.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!oAuthUserModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                oAuthUser.setModifiedDate(date);
            } else {
                oAuthUser.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)oAuthUser);
            } else {
                oAuthUser = (OAuthUser)session.merge((Object)oAuthUser);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(OAuthUserImpl.class, (BaseModel)oAuthUserModelImpl, false, true);
        this.cacheUniqueFindersCache(oAuthUserModelImpl);
        if (isNew) {
            oAuthUser.setNew(false);
        }
        oAuthUser.resetOriginalValues();
        return oAuthUser;
    }

    public OAuthUser findByPrimaryKey(Serializable primaryKey) throws NoSuchUserException {
        OAuthUser oAuthUser = (OAuthUser)this.fetchByPrimaryKey(primaryKey);
        if (oAuthUser == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchUserException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return oAuthUser;
    }

    public OAuthUser findByPrimaryKey(long oAuthUserId) throws NoSuchUserException {
        return this.findByPrimaryKey(Long.valueOf(oAuthUserId));
    }

    public OAuthUser fetchByPrimaryKey(long oAuthUserId) {
        return (OAuthUser)this.fetchByPrimaryKey(Long.valueOf(oAuthUserId));
    }

    public List<OAuthUser> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuthUser> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuthUser> findAll(int start, int end, OrderByComparator<OAuthUser> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuthUser> findAll(int start, int end, OrderByComparator<OAuthUser> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OAUTHUSER);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OAUTHUSER;
                sql = sql.concat(" ORDER BY oAuthUser.oAuthUserId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuthUser oAuthUser : this.findAll()) {
            this.remove((BaseModel)oAuthUser);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OAUTHUSER);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "oAuthUserId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OAUTHUSER;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuthUserModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate(BundleContext bundleContext) {
        this._bundleContext = bundleContext;
        this._argumentsResolverServiceRegistration = this._bundleContext.registerService(ArgumentsResolver.class, (Object)new OAuthUserModelArgumentsResolver(), MapUtil.singletonDictionary((Object)"model.class.name", (Object)OAuthUser.class.getName()));
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId"}, true);
        this._finderPathWithoutPaginationFindByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, true);
        this._finderPathCountByUserId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, false);
        this._finderPathWithPaginationFindByOAuthApplicationId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByOAuthApplicationId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"oAuthApplicationId"}, true);
        this._finderPathWithoutPaginationFindByOAuthApplicationId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByOAuthApplicationId", new String[]{Long.class.getName()}, new String[]{"oAuthApplicationId"}, true);
        this._finderPathCountByOAuthApplicationId = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByOAuthApplicationId", new String[]{Long.class.getName()}, new String[]{"oAuthApplicationId"}, false);
        this._finderPathFetchByAccessToken = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByAccessToken", new String[]{String.class.getName()}, new String[]{"accessToken"}, true);
        this._finderPathCountByAccessToken = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByAccessToken", new String[]{String.class.getName()}, new String[]{"accessToken"}, false);
        this._finderPathFetchByU_OAI = this._createFinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByU_OAI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"userId", "oAuthApplicationId"}, true);
        this._finderPathCountByU_OAI = this._createFinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByU_OAI", new String[]{Long.class.getName(), Long.class.getName()}, new String[]{"userId", "oAuthApplicationId"}, false);
        OAuthUserUtil.setPersistence((OAuthUserPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        OAuthUserUtil.setPersistence(null);
        this.entityCache.removeCache(OAuthUserImpl.class.getName());
        this._argumentsResolverServiceRegistration.unregister();
        for (ServiceRegistration<FinderPath> serviceRegistration : this._serviceRegistrations) {
            serviceRegistration.unregister();
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.oauth.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    private FinderPath _createFinderPath(String cacheName, String methodName, String[] params, String[] columnNames, boolean baseModelResult) {
        FinderPath finderPath = new FinderPath(cacheName, methodName, params, columnNames, baseModelResult);
        if (!cacheName.equals(FINDER_CLASS_NAME_LIST_WITH_PAGINATION)) {
            this._serviceRegistrations.add((ServiceRegistration<FinderPath>)this._bundleContext.registerService(FinderPath.class, (Object)finderPath, MapUtil.singletonDictionary((Object)"cache.name", (Object)cacheName)));
        }
        return finderPath;
    }

    private static class OAuthUserModelArgumentsResolver
    implements ArgumentsResolver {
        private static final Map<FinderPath, Long> _finderPathColumnBitmasksCache = new ConcurrentHashMap<FinderPath, Long>();

        private OAuthUserModelArgumentsResolver() {
        }

        public Object[] getArguments(FinderPath finderPath, BaseModel<?> baseModel, boolean checkColumn, boolean original) {
            String[] columnNames = finderPath.getColumnNames();
            if (columnNames == null || columnNames.length == 0) {
                if (baseModel.isNew()) {
                    return new Object[0];
                }
                return null;
            }
            OAuthUserModelImpl oAuthUserModelImpl = (OAuthUserModelImpl)baseModel;
            long columnBitmask = oAuthUserModelImpl.getColumnBitmask();
            if (!checkColumn || columnBitmask == 0L) {
                return OAuthUserModelArgumentsResolver._getValue(oAuthUserModelImpl, columnNames, original);
            }
            Long finderPathColumnBitmask = _finderPathColumnBitmasksCache.get(finderPath);
            if (finderPathColumnBitmask == null) {
                finderPathColumnBitmask = 0L;
                for (String columnName : columnNames) {
                    finderPathColumnBitmask = finderPathColumnBitmask | OAuthUserModelImpl.getColumnBitmask(columnName);
                }
                _finderPathColumnBitmasksCache.put(finderPath, finderPathColumnBitmask);
            }
            if ((columnBitmask & finderPathColumnBitmask) != 0L) {
                return OAuthUserModelArgumentsResolver._getValue(oAuthUserModelImpl, columnNames, original);
            }
            return null;
        }

        private static Object[] _getValue(OAuthUserModelImpl oAuthUserModelImpl, String[] columnNames, boolean original) {
            Object[] arguments = new Object[columnNames.length];
            for (int i = 0; i < arguments.length; ++i) {
                String columnName = columnNames[i];
                arguments[i] = original ? oAuthUserModelImpl.getColumnOriginalValue(columnName) : oAuthUserModelImpl.getColumnValue(columnName);
            }
            return arguments;
        }
    }
}

