/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.impl;

import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.model.OAuthUser;
import com.liferay.oauth.service.base.OAuthUserServiceBaseImpl;
import com.liferay.oauth.service.permission.OAuthUserPermission;
import com.liferay.oauth.util.OAuth;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=oauth", "json.web.service.context.path=OAuthUser"}, service={AopService.class})
public class OAuthUserServiceImpl
extends OAuthUserServiceBaseImpl {
    @Reference
    private OAuth _oAuth;

    public OAuthUser addOAuthUser(String consumerKey, ServiceContext serviceContext) throws PortalException {
        OAuthApplication oAuthApplication = this.oAuthApplicationPersistence.findByConsumerKey(consumerKey);
        User user = this.getUser();
        OAuthUser oAuthUser = this.oAuthUserPersistence.fetchByU_OAI(user.getUserId(), oAuthApplication.getOAuthApplicationId());
        if (oAuthUser != null) {
            return oAuthUser;
        }
        String accessToken = this._oAuth.randomizeToken(oAuthApplication.getConsumerKey());
        String accessSecret = this._oAuth.randomizeToken(consumerKey.concat(accessToken));
        return this.oAuthUserLocalService.addOAuthUser(user.getUserId(), oAuthApplication.getOAuthApplicationId(), accessToken, accessSecret, serviceContext);
    }

    public OAuthUser deleteOAuthUser(long oAuthApplicationId) throws PortalException {
        OAuthUser oAuthUser = this.oAuthUserPersistence.findByU_OAI(this.getUserId(), oAuthApplicationId);
        OAuthUserPermission.check((PermissionChecker)this.getPermissionChecker(), (OAuthUser)oAuthUser, (String)"DELETE");
        return this.oAuthUserLocalService.deleteOAuthUser(this.getUserId(), oAuthApplicationId);
    }
}

