/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.impl;

import com.liferay.oauth.model.OAuthUser;
import com.liferay.oauth.service.base.OAuthUserLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.oauth.model.OAuthUser"}, service={AopService.class})
public class OAuthUserLocalServiceImpl
extends OAuthUserLocalServiceBaseImpl {
    public OAuthUser addOAuthUser(long userId, long oAuthApplicationId, String accessToken, String accessSecret, ServiceContext serviceContext) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        Date now = new Date();
        this.validate(oAuthApplicationId);
        long oAuthUserId = this.counterLocalService.increment();
        OAuthUser oAuthUser = this.oAuthUserPersistence.create(oAuthUserId);
        oAuthUser.setCompanyId(user.getCompanyId());
        oAuthUser.setUserId(user.getUserId());
        oAuthUser.setUserName(user.getFullName());
        oAuthUser.setCreateDate(serviceContext.getCreateDate(now));
        oAuthUser.setModifiedDate(serviceContext.getModifiedDate(now));
        oAuthUser.setOAuthApplicationId(oAuthApplicationId);
        oAuthUser.setAccessToken(accessToken);
        oAuthUser.setAccessSecret(accessSecret);
        oAuthUser = (OAuthUser)this.oAuthUserPersistence.update((BaseModel)oAuthUser);
        this.resourceLocalService.addModelResources((AuditedModel)oAuthUser, serviceContext);
        return oAuthUser;
    }

    public OAuthUser deleteOAuthUser(long userId, long oAuthApplicationId) throws PortalException {
        OAuthUser oAuthUser = this.oAuthUserPersistence.findByU_OAI(userId, oAuthApplicationId);
        return this.deleteOAuthUser(oAuthUser);
    }

    @Override
    public OAuthUser deleteOAuthUser(OAuthUser oAuthUser) throws PortalException {
        this.oAuthUserPersistence.remove((BaseModel)oAuthUser);
        this.resourceLocalService.deleteResource((AuditedModel)oAuthUser, 4);
        return oAuthUser;
    }

    public OAuthUser fetchOAuthUser(long userId, long oAuthApplicationId) {
        return this.oAuthUserPersistence.fetchByU_OAI(userId, oAuthApplicationId);
    }

    public OAuthUser fetchOAuthUser(String accessToken) {
        return this.oAuthUserPersistence.fetchByAccessToken(accessToken);
    }

    public List<OAuthUser> getOAuthApplicationOAuthUsers(long oAuthApplicationId, int start, int end, OrderByComparator<OAuthUser> orderByComparator) {
        return this.oAuthUserPersistence.findByOAuthApplicationId(oAuthApplicationId, start, end, orderByComparator);
    }

    public int getOAuthApplicationOAuthUsersCount(long oAuthApplicationId) {
        return this.oAuthUserPersistence.countByOAuthApplicationId(oAuthApplicationId);
    }

    public OAuthUser getOAuthUser(long userId, long oAuthApplicationId) throws PortalException {
        return this.oAuthUserPersistence.findByU_OAI(userId, oAuthApplicationId);
    }

    public OAuthUser getOAuthUser(String accessToken) throws PortalException {
        return this.oAuthUserPersistence.findByAccessToken(accessToken);
    }

    public List<OAuthUser> getUserOAuthUsers(long userId, int start, int end, OrderByComparator<OAuthUser> orderByComparator) {
        return this.oAuthUserPersistence.findByUserId(userId, start, end, orderByComparator);
    }

    public int getUserOAuthUsersCount(long userId) {
        return this.oAuthUserPersistence.countByUserId(userId);
    }

    public OAuthUser updateOAuthUser(long userId, long oAuthApplicationId, String accessToken, String accessSecret, ServiceContext serviceContext) throws PortalException {
        OAuthUser oAuthUser = this.oAuthUserPersistence.findByU_OAI(userId, oAuthApplicationId);
        oAuthUser.setAccessToken(accessToken);
        oAuthUser.setAccessSecret(accessSecret);
        return (OAuthUser)this.oAuthUserPersistence.update((BaseModel)oAuthUser);
    }

    protected void validate(long oAuthApplicationId) throws PortalException {
        this.oAuthApplicationPersistence.findByPrimaryKey(oAuthApplicationId);
    }
}

