/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.impl;

import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.service.base.OAuthApplicationServiceBaseImpl;
import com.liferay.oauth.service.permission.OAuthApplicationPermission;
import com.liferay.oauth.service.permission.OAuthPermission;
import com.liferay.oauth.util.OAuth;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import java.io.InputStream;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=oauth", "json.web.service.context.path=OAuthApplication"}, service={AopService.class})
public class OAuthApplicationServiceImpl
extends OAuthApplicationServiceBaseImpl {
    @Reference
    private OAuth _oAuth;

    public OAuthApplication addOAuthApplication(String name, String description, int accessLevel, boolean shareableAccessToken, String callbackURI, String websiteURL, ServiceContext serviceContext) throws PortalException {
        OAuthPermission.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_APPLICATION");
        String consumerKey = serviceContext.getUuid();
        if (Validator.isNull((String)consumerKey)) {
            consumerKey = PortalUUIDUtil.generate();
        }
        return this.oAuthApplicationLocalService.addOAuthApplication(this.getUserId(), name, description, this._oAuth.randomizeToken(consumerKey), accessLevel, shareableAccessToken, callbackURI, websiteURL, serviceContext);
    }

    public void deleteLogo(long oAuthApplicationId) throws PortalException {
        OAuthApplicationPermission.check((PermissionChecker)this.getPermissionChecker(), (long)oAuthApplicationId, (String)"UPDATE");
        this.oAuthApplicationLocalService.deleteLogo(oAuthApplicationId);
    }

    public OAuthApplication deleteOAuthApplication(long oAuthApplicationId) throws PortalException {
        OAuthApplication oAuthApplication = this.oAuthApplicationPersistence.findByPrimaryKey(oAuthApplicationId);
        OAuthApplicationPermission.check((PermissionChecker)this.getPermissionChecker(), (OAuthApplication)oAuthApplication, (String)"DELETE");
        return this.oAuthApplicationLocalService.deleteOAuthApplication(oAuthApplication);
    }

    public OAuthApplication updateLogo(long oAuthApplicationId, InputStream inputStream) throws PortalException {
        OAuthApplicationPermission.check((PermissionChecker)this.getPermissionChecker(), (long)oAuthApplicationId, (String)"UPDATE");
        return this.oAuthApplicationLocalService.updateLogo(oAuthApplicationId, inputStream);
    }

    public OAuthApplication updateOAuthApplication(long oAuthApplicationId, String name, String description, boolean shareableAccessToken, String callbackURI, String websiteURL, ServiceContext serviceContext) throws PortalException {
        OAuthApplicationPermission.check((PermissionChecker)this.getPermissionChecker(), (long)oAuthApplicationId, (String)"UPDATE");
        return this.oAuthApplicationLocalService.updateOAuthApplication(oAuthApplicationId, name, description, shareableAccessToken, callbackURI, websiteURL, serviceContext);
    }
}

