/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.internal;

import com.liferay.oauth.configuration.OAuthConfigurationValues;
import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.model.OAuthUser;
import com.liferay.oauth.service.OAuthApplicationLocalService;
import com.liferay.oauth.service.OAuthUserLocalService;
import com.liferay.oauth.util.DefaultOAuthAccessor;
import com.liferay.oauth.util.DefaultOAuthConsumer;
import com.liferay.oauth.util.DefaultOAuthMessage;
import com.liferay.oauth.util.DefaultOAuthValidator;
import com.liferay.oauth.util.OAuthAccessor;
import com.liferay.oauth.util.OAuthConsumer;
import com.liferay.oauth.util.OAuthMessage;
import com.liferay.oauth.util.OAuthValidator;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.cluster.ClusterExecutor;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiServiceUtil;
import com.liferay.portal.kernel.oauth.OAuthException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;
import net.oauth.server.OAuthServlet;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={com.liferay.oauth.util.OAuth.class})
public class V10aOAuth
implements IdentifiableOSGiService,
com.liferay.oauth.util.OAuth {
    private static final Log _log = LogFactoryUtil.getLog(V10aOAuth.class);
    private static final MethodKey _putMethodKey = new MethodKey(V10aOAuth.class, "_put", new Class[]{String.class, String.class, byte[].class});
    @Reference
    private ClusterExecutor _clusterExecutor;
    @Reference
    private OAuthApplicationLocalService _oAuthApplicationLocalService;
    @Reference
    private OAuthUserLocalService _oAuthUserLocalService;
    private OAuthValidator _oAuthValidator;
    @Reference
    private Portal _portal;
    private PortalCache<Serializable, Object> _portalCache;
    @Reference
    private SingleVMPool _singleVMPool;

    public String addParameters(String url, String ... parameters) throws OAuthException {
        try {
            return OAuth.addParameters((String)url, (String[])parameters);
        }
        catch (IOException ioException) {
            throw new OAuthException((Throwable)ioException);
        }
    }

    public void authorize(OAuthAccessor oAuthAccessor, long userId, ServiceContext serviceContext) throws PortalException {
        Boolean authorized = (Boolean)oAuthAccessor.getProperty("authorized");
        if (authorized != null && authorized.booleanValue() && Validator.isNotNull((String)oAuthAccessor.getRequestToken())) {
            throw new OAuthException("token_expired");
        }
        oAuthAccessor.setProperty("authorized", (Object)Boolean.TRUE);
        oAuthAccessor.setProperty("userId", (Object)userId);
        this._put(oAuthAccessor.getRequestToken(), oAuthAccessor);
    }

    public void formEncode(String token, String tokenSecret, OutputStream outputStream) throws OAuthException {
        List parameters = OAuth.newList((String[])new String[]{"oauth_token", token, "oauth_token_secret", tokenSecret});
        try {
            OAuth.formEncode((Iterable)parameters, (OutputStream)outputStream);
        }
        catch (IOException ioException) {
            throw new OAuthException((Throwable)ioException);
        }
    }

    public void generateAccessToken(OAuthAccessor oAuthAccessor, long userId, ServiceContext serviceContext) throws PortalException {
        Boolean authorized = (Boolean)oAuthAccessor.getProperty("authorized");
        if (authorized != null && authorized.booleanValue() && Validator.isNotNull((String)oAuthAccessor.getAccessToken())) {
            throw new OAuthException("token_expired");
        }
        OAuthConsumer oAuthConsumer = oAuthAccessor.getOAuthConsumer();
        OAuthApplication oAuthApplication = oAuthConsumer.getOAuthApplication();
        String consumerKey = oAuthApplication.getConsumerKey();
        String token = this.randomizeToken(consumerKey);
        oAuthAccessor.setAccessToken(token);
        oAuthAccessor.setRequestToken(null);
        oAuthAccessor.setTokenSecret(this.randomizeToken(consumerKey.concat(token)));
        OAuthUser oAuthUser = this._oAuthUserLocalService.fetchOAuthUser(userId, oAuthApplication.getOAuthApplicationId());
        if (oAuthUser == null) {
            this._oAuthUserLocalService.addOAuthUser(userId, oAuthApplication.getOAuthApplicationId(), oAuthAccessor.getAccessToken(), oAuthAccessor.getTokenSecret(), serviceContext);
        } else if (oAuthApplication.isShareableAccessToken()) {
            oAuthAccessor.setAccessToken(oAuthUser.getAccessToken());
            oAuthAccessor.setTokenSecret(oAuthUser.getAccessSecret());
        } else {
            this._oAuthUserLocalService.updateOAuthUser(userId, oAuthUser.getOAuthApplicationId(), oAuthAccessor.getAccessToken(), oAuthAccessor.getTokenSecret(), serviceContext);
        }
        this._put(token, oAuthAccessor);
    }

    public void generateRequestToken(OAuthAccessor oAuthAccessor) {
        OAuthConsumer oAuthConsumer = oAuthAccessor.getOAuthConsumer();
        OAuthApplication oAuthApplication = oAuthConsumer.getOAuthApplication();
        String consumerKey = oAuthApplication.getConsumerKey();
        oAuthAccessor.setAccessToken(null);
        String token = this.randomizeToken(consumerKey);
        oAuthAccessor.setRequestToken(token);
        oAuthAccessor.setTokenSecret(this.randomizeToken(consumerKey.concat(token)));
        this._put(token, oAuthAccessor);
    }

    public OAuthAccessor getOAuthAccessor(OAuthMessage oAuthMessage) throws OAuthException {
        String token = null;
        try {
            token = oAuthMessage.getToken();
        }
        catch (IOException ioException) {
            throw new OAuthException((Throwable)ioException);
        }
        OAuthAccessor oAuthAccessor = (OAuthAccessor)this._portalCache.get((Serializable)((Object)token));
        if (oAuthAccessor == null) {
            throw new OAuthException("token_expired");
        }
        return oAuthAccessor;
    }

    public OAuthConsumer getOAuthConsumer(OAuthMessage requestMessage) throws PortalException {
        String consumerKey = null;
        try {
            consumerKey = requestMessage.getConsumerKey();
        }
        catch (IOException ioException) {
            throw new OAuthException((Throwable)ioException);
        }
        OAuthApplication oAuthApplication = this._oAuthApplicationLocalService.fetchOAuthApplication(consumerKey);
        if (oAuthApplication == null) {
            throw new OAuthException("consumer_key_refused");
        }
        return new DefaultOAuthConsumer(oAuthApplication);
    }

    public OAuthMessage getOAuthMessage(HttpServletRequest httpServletRequest) {
        return this.getOAuthMessage(httpServletRequest, null);
    }

    public OAuthMessage getOAuthMessage(HttpServletRequest httpServletRequest, String url) {
        return new DefaultOAuthMessage(OAuthServlet.getMessage((HttpServletRequest)httpServletRequest, (String)url));
    }

    public OAuthMessage getOAuthMessage(PortletRequest portletRequest) {
        return this.getOAuthMessage(portletRequest, null);
    }

    public OAuthMessage getOAuthMessage(PortletRequest portletRequest, String url) {
        return this.getOAuthMessage(this._portal.getHttpServletRequest(portletRequest), url);
    }

    public String getOSGiServiceIdentifier() {
        return V10aOAuth.class.getName();
    }

    public void handleException(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Exception exception1, boolean sendBody) throws OAuthException {
        if (exception1.getCause() != null) {
            exception1 = (Exception)exception1.getCause();
        }
        try {
            OAuthServlet.handleException((HttpServletResponse)httpServletResponse, (Exception)exception1, (String)OAuthConfigurationValues.OAUTH_REALM, (boolean)sendBody);
        }
        catch (Exception exception2) {
            throw new OAuthException((Throwable)exception2);
        }
    }

    public String randomizeToken(String token) {
        return DigesterUtil.digestHex((String)"MD5", (String[])new String[]{token, PwdGenerator.getPassword()});
    }

    public void validateOAuthMessage(OAuthMessage oAuthMessage, OAuthAccessor accessor) throws OAuthException {
        this._oAuthValidator.validateOAuthMessage(oAuthMessage, accessor);
    }

    protected static OAuthAccessor deserialize(byte[] bytes) {
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(bytes));
        try {
            return (OAuthAccessor)deserializer.readObject();
        }
        catch (ClassNotFoundException classNotFoundException) {
            _log.error((Throwable)classNotFoundException);
            return null;
        }
    }

    @Activate
    protected void activate() {
        this._oAuthValidator = new DefaultOAuthValidator();
        this._portalCache = this._singleVMPool.getPortalCache(V10aOAuth.class.getName());
        if (_log.isDebugEnabled()) {
            this._portalCache.registerPortalCacheListener((PortalCacheListener)new V10aOAuthDebugCacheListener());
        }
    }

    protected byte[] serialize(OAuthAccessor oAuthAccessor) {
        Serializer serializer = new Serializer();
        serializer.writeObject((Serializable)((DefaultOAuthAccessor)oAuthAccessor));
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        return byteBuffer.array();
    }

    private static void _put(String osgiServiceIdentifier, String key, byte[] bytes) {
        OAuthAccessor oAuthAccessor = V10aOAuth.deserialize(bytes);
        V10aOAuth v10aOAuth = (V10aOAuth)IdentifiableOSGiServiceUtil.getIdentifiableOSGiService((String)osgiServiceIdentifier);
        PortalCache<Serializable, Object> portalCache = v10aOAuth._portalCache;
        portalCache.put((Serializable)((Object)key), (Object)oAuthAccessor);
    }

    private void _notifyCluster(String key, OAuthAccessor oAuthAccessor) throws Exception {
        MethodHandler putMethodHandler = new MethodHandler(_putMethodKey, new Object[]{this.getOSGiServiceIdentifier(), key, this.serialize(oAuthAccessor)});
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)putMethodHandler, (boolean)true);
        FutureClusterResponses futureClusterResponses = this._clusterExecutor.execute(clusterRequest);
        futureClusterResponses.get();
    }

    private void _put(String key, OAuthAccessor oAuthAccessor) {
        this._portalCache.put((Serializable)((Object)key), (Object)oAuthAccessor);
        if (this._clusterExecutor.isEnabled()) {
            try {
                this._notifyCluster(key, oAuthAccessor);
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Notified cluster");
                }
            }
            catch (Exception exception) {
                _log.error((Object)"Unable to notify cluster", (Throwable)exception);
            }
        }
    }

    private static class V10aOAuthDebugCacheListener
    implements PortalCacheListener<Serializable, Object> {
        public void dispose() {
        }

        public void notifyEntryEvicted(PortalCache<Serializable, Object> portalCache, Serializable key, Object value, int timeToLive) throws PortalCacheException {
            this._logDebug("Entry evicted", key, value);
        }

        public void notifyEntryExpired(PortalCache<Serializable, Object> portalCache, Serializable key, Object value, int timeToLive) throws PortalCacheException {
            this._logDebug("Entry expired", key, value);
        }

        public void notifyEntryPut(PortalCache<Serializable, Object> portalCache, Serializable key, Object value, int timeToLive) throws PortalCacheException {
            this._logDebug("Entry put", key, value);
        }

        public void notifyEntryRemoved(PortalCache<Serializable, Object> portalCache, Serializable key, Object value, int timeToLive) throws PortalCacheException {
            this._logDebug("Entry removed", key, value);
        }

        public void notifyEntryUpdated(PortalCache<Serializable, Object> portalCache, Serializable key, Object value, int timeToLive) throws PortalCacheException {
            this._logDebug("Entry updated", key, value);
        }

        public void notifyRemoveAll(PortalCache<Serializable, Object> portalCache) throws PortalCacheException {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Remove all " + portalCache.getPortalCacheName()));
            }
        }

        private V10aOAuthDebugCacheListener() {
        }

        private void _logDebug(String method, Serializable key, Object value) {
            if (!_log.isDebugEnabled()) {
                return;
            }
            if (!(value instanceof OAuthAccessor)) {
                return;
            }
            OAuthAccessor oAuthAccessor = (OAuthAccessor)value;
            StringBundler sb = new StringBundler(7);
            sb.append(method);
            sb.append("  ");
            sb.append((Object)key);
            sb.append(":");
            sb.append(oAuthAccessor.getRequestToken());
            sb.append(":");
            sb.append(oAuthAccessor.getProperty("authorized"));
            _log.debug((Object)sb.toString());
        }
    }
}

