/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.oauth.model.impl;

import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.service.OAuthApplicationLocalServiceUtil;

/**
 * The extended model base implementation for the OAuthApplication service. Represents a row in the &quot;OAuth_OAuthApplication&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link OAuthApplicationImpl}.
 * </p>
 *
 * @author Ivica Cardic
 * @see OAuthApplicationImpl
 * @see OAuthApplication
 * @generated
 */
public abstract class OAuthApplicationBaseImpl
	extends OAuthApplicationModelImpl implements OAuthApplication {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a o auth application model instance should use the <code>OAuthApplication</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			OAuthApplicationLocalServiceUtil.addOAuthApplication(this);
		}
		else {
			OAuthApplicationLocalServiceUtil.updateOAuthApplication(this);
		}
	}

}