/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.persistence.impl;

import com.liferay.oauth.exception.NoSuchApplicationException;
import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.model.impl.OAuthApplicationImpl;
import com.liferay.oauth.model.impl.OAuthApplicationModelImpl;
import com.liferay.oauth.service.persistence.OAuthApplicationPersistence;
import com.liferay.oauth.service.persistence.OAuthApplicationUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={OAuthApplicationPersistence.class})
public class OAuthApplicationPersistenceImpl
extends BasePersistenceImpl<OAuthApplication>
implements OAuthApplicationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = OAuthApplicationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCompanyId;
    private FinderPath _finderPathWithoutPaginationFindByCompanyId;
    private FinderPath _finderPathCountByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "oAuthApplication.companyId = ?";
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "oAuthApplication.userId = ?";
    private FinderPath _finderPathFetchByConsumerKey;
    private FinderPath _finderPathCountByConsumerKey;
    private static final String _FINDER_COLUMN_CONSUMERKEY_CONSUMERKEY_2 = "oAuthApplication.consumerKey = ?";
    private static final String _FINDER_COLUMN_CONSUMERKEY_CONSUMERKEY_3 = "(oAuthApplication.consumerKey IS NULL OR oAuthApplication.consumerKey = '')";
    private FinderPath _finderPathWithPaginationFindByC_N;
    private FinderPath _finderPathWithPaginationCountByC_N;
    private static final String _FINDER_COLUMN_C_N_COMPANYID_2 = "oAuthApplication.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_N_NAME_2 = "lower(oAuthApplication.name) LIKE ?";
    private static final String _FINDER_COLUMN_C_N_NAME_3 = "(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')";
    private FinderPath _finderPathWithPaginationFindByU_N;
    private FinderPath _finderPathWithPaginationCountByU_N;
    private static final String _FINDER_COLUMN_U_N_USERID_2 = "oAuthApplication.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_N_NAME_2 = "lower(oAuthApplication.name) LIKE ?";
    private static final String _FINDER_COLUMN_U_N_NAME_3 = "(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')";
    private int _valueObjectFinderCacheListThreshold;
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_OAUTHAPPLICATION = "SELECT oAuthApplication FROM OAuthApplication oAuthApplication";
    private static final String _SQL_SELECT_OAUTHAPPLICATION_WHERE = "SELECT oAuthApplication FROM OAuthApplication oAuthApplication WHERE ";
    private static final String _SQL_COUNT_OAUTHAPPLICATION = "SELECT COUNT(oAuthApplication) FROM OAuthApplication oAuthApplication";
    private static final String _SQL_COUNT_OAUTHAPPLICATION_WHERE = "SELECT COUNT(oAuthApplication) FROM OAuthApplication oAuthApplication WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "oAuthApplication.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No OAuthApplication exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No OAuthApplication exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(OAuthApplicationPersistenceImpl.class);

    public List<OAuthApplication> findByCompanyId(long companyId) {
        return this.findByCompanyId(companyId, -1, -1, null);
    }

    public List<OAuthApplication> findByCompanyId(long companyId, int start, int end) {
        return this.findByCompanyId(companyId, start, end, null);
    }

    public List<OAuthApplication> findByCompanyId(long companyId, int start, int end, OrderByComparator<OAuthApplication> orderByComparator) {
        return this.findByCompanyId(companyId, start, end, orderByComparator, true);
    }

    public List<OAuthApplication> findByCompanyId(long companyId, int start, int end, OrderByComparator<OAuthApplication> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCompanyId;
                finderArgs = new Object[]{companyId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCompanyId;
            finderArgs = new Object[]{companyId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuthApplication oAuthApplication : list) {
                if (companyId == oAuthApplication.getCompanyId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthApplication findByCompanyId_First(long companyId, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByCompanyId_First(companyId, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByCompanyId_First(long companyId, OrderByComparator<OAuthApplication> orderByComparator) {
        List<OAuthApplication> list = this.findByCompanyId(companyId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication findByCompanyId_Last(long companyId, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByCompanyId_Last(companyId, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByCompanyId_Last(long companyId, OrderByComparator<OAuthApplication> orderByComparator) {
        int count = this.countByCompanyId(companyId);
        if (count == 0) {
            return null;
        }
        List<OAuthApplication> list = this.findByCompanyId(companyId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication[] findByCompanyId_PrevAndNext(long oAuthApplicationId, long companyId, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.findByPrimaryKey(oAuthApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthApplication[] array = new OAuthApplicationImpl[]{this.getByCompanyId_PrevAndNext(session, oAuthApplication, companyId, orderByComparator, true), oAuthApplication, this.getByCompanyId_PrevAndNext(session, oAuthApplication, companyId, orderByComparator, false)};
            OAuthApplication[] oAuthApplicationArray = array;
            return oAuthApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthApplication getByCompanyId_PrevAndNext(Session session, OAuthApplication oAuthApplication, long companyId, OrderByComparator<OAuthApplication> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
        sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthApplication)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthApplication)list.get(1);
        }
        return null;
    }

    public void removeByCompanyId(long companyId) {
        for (OAuthApplication oAuthApplication : this.findByCompanyId(companyId, -1, -1, null)) {
            this.remove((BaseModel)oAuthApplication);
        }
    }

    public int countByCompanyId(long companyId) {
        FinderPath finderPath = this._finderPathCountByCompanyId;
        Object[] finderArgs = new Object[]{companyId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuthApplication> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<OAuthApplication> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<OAuthApplication> findByUserId(long userId, int start, int end, OrderByComparator<OAuthApplication> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<OAuthApplication> findByUserId(long userId, int start, int end, OrderByComparator<OAuthApplication> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuthApplication oAuthApplication : list) {
                if (userId == oAuthApplication.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthApplication findByUserId_First(long userId, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByUserId_First(userId, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByUserId_First(long userId, OrderByComparator<OAuthApplication> orderByComparator) {
        List<OAuthApplication> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication findByUserId_Last(long userId, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByUserId_Last(userId, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByUserId_Last(long userId, OrderByComparator<OAuthApplication> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<OAuthApplication> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication[] findByUserId_PrevAndNext(long oAuthApplicationId, long userId, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.findByPrimaryKey(oAuthApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthApplication[] array = new OAuthApplicationImpl[]{this.getByUserId_PrevAndNext(session, oAuthApplication, userId, orderByComparator, true), oAuthApplication, this.getByUserId_PrevAndNext(session, oAuthApplication, userId, orderByComparator, false)};
            OAuthApplication[] oAuthApplicationArray = array;
            return oAuthApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthApplication getByUserId_PrevAndNext(Session session, OAuthApplication oAuthApplication, long userId, OrderByComparator<OAuthApplication> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthApplication)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthApplication)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (OAuthApplication oAuthApplication : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)oAuthApplication);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuthApplication findByConsumerKey(String consumerKey) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByConsumerKey(consumerKey);
        if (oAuthApplication == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("consumerKey=");
            sb.append(consumerKey);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchApplicationException(sb.toString());
        }
        return oAuthApplication;
    }

    public OAuthApplication fetchByConsumerKey(String consumerKey) {
        return this.fetchByConsumerKey(consumerKey, true);
    }

    public OAuthApplication fetchByConsumerKey(String consumerKey, boolean useFinderCache) {
        OAuthApplication oAuthApplication;
        consumerKey = Objects.toString(consumerKey, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{consumerKey};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByConsumerKey, finderArgs, (BasePersistenceImpl)this);
        }
        if (result instanceof OAuthApplication && !Objects.equals(consumerKey, (oAuthApplication = (OAuthApplication)result).getConsumerKey())) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
            boolean bindConsumerKey = false;
            if (consumerKey.isEmpty()) {
                sb.append(_FINDER_COLUMN_CONSUMERKEY_CONSUMERKEY_3);
            } else {
                bindConsumerKey = true;
                sb.append(_FINDER_COLUMN_CONSUMERKEY_CONSUMERKEY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindConsumerKey) {
                    queryPos.add(consumerKey);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByConsumerKey, finderArgs, (Object)list);
                    }
                } else {
                    OAuthApplication oAuthApplication2 = (OAuthApplication)list.get(0);
                    result = oAuthApplication2;
                    this.cacheResult(oAuthApplication2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByConsumerKey, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (OAuthApplication)result;
    }

    public OAuthApplication removeByConsumerKey(String consumerKey) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.findByConsumerKey(consumerKey);
        return (OAuthApplication)this.remove((BaseModel)oAuthApplication);
    }

    public int countByConsumerKey(String consumerKey) {
        consumerKey = Objects.toString(consumerKey, "");
        FinderPath finderPath = this._finderPathCountByConsumerKey;
        Object[] finderArgs = new Object[]{consumerKey};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_OAUTHAPPLICATION_WHERE);
            boolean bindConsumerKey = false;
            if (consumerKey.isEmpty()) {
                sb.append(_FINDER_COLUMN_CONSUMERKEY_CONSUMERKEY_3);
            } else {
                bindConsumerKey = true;
                sb.append(_FINDER_COLUMN_CONSUMERKEY_CONSUMERKEY_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                if (bindConsumerKey) {
                    queryPos.add(consumerKey);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuthApplication> findByC_N(long companyId, String name) {
        return this.findByC_N(companyId, name, -1, -1, null);
    }

    public List<OAuthApplication> findByC_N(long companyId, String name, int start, int end) {
        return this.findByC_N(companyId, name, start, end, null);
    }

    public List<OAuthApplication> findByC_N(long companyId, String name, int start, int end, OrderByComparator<OAuthApplication> orderByComparator) {
        return this.findByC_N(companyId, name, start, end, orderByComparator, true);
    }

    public List<OAuthApplication> findByC_N(long companyId, String name, int start, int end, OrderByComparator<OAuthApplication> orderByComparator, boolean useFinderCache) {
        name = Objects.toString(name, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_N;
        finderArgs = new Object[]{companyId, name, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuthApplication oAuthApplication : list) {
                if (companyId == oAuthApplication.getCompanyId() && StringUtil.wildcardMatches((String)oAuthApplication.getName(), (String)name, (char)'_', (char)'%', (char)'\\', (boolean)false)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_C_N_COMPANYID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append("(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')");
            } else {
                bindName = true;
                sb.append("lower(oAuthApplication.name) LIKE ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindName) {
                    queryPos.add(StringUtil.toLowerCase((String)name));
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthApplication findByC_N_First(long companyId, String name, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByC_N_First(companyId, name, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", nameLIKE");
        sb.append(name);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByC_N_First(long companyId, String name, OrderByComparator<OAuthApplication> orderByComparator) {
        List<OAuthApplication> list = this.findByC_N(companyId, name, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication findByC_N_Last(long companyId, String name, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByC_N_Last(companyId, name, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", nameLIKE");
        sb.append(name);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByC_N_Last(long companyId, String name, OrderByComparator<OAuthApplication> orderByComparator) {
        int count = this.countByC_N(companyId, name);
        if (count == 0) {
            return null;
        }
        List<OAuthApplication> list = this.findByC_N(companyId, name, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication[] findByC_N_PrevAndNext(long oAuthApplicationId, long companyId, String name, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        name = Objects.toString(name, "");
        OAuthApplication oAuthApplication = this.findByPrimaryKey(oAuthApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthApplication[] array = new OAuthApplicationImpl[]{this.getByC_N_PrevAndNext(session, oAuthApplication, companyId, name, orderByComparator, true), oAuthApplication, this.getByC_N_PrevAndNext(session, oAuthApplication, companyId, name, orderByComparator, false)};
            OAuthApplication[] oAuthApplicationArray = array;
            return oAuthApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthApplication getByC_N_PrevAndNext(Session session, OAuthApplication oAuthApplication, long companyId, String name, OrderByComparator<OAuthApplication> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
        sb.append(_FINDER_COLUMN_C_N_COMPANYID_2);
        boolean bindName = false;
        if (name.isEmpty()) {
            sb.append("(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')");
        } else {
            bindName = true;
            sb.append("lower(oAuthApplication.name) LIKE ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        if (bindName) {
            queryPos.add(StringUtil.toLowerCase((String)name));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthApplication)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthApplication)list.get(1);
        }
        return null;
    }

    public void removeByC_N(long companyId, String name) {
        for (OAuthApplication oAuthApplication : this.findByC_N(companyId, name, -1, -1, null)) {
            this.remove((BaseModel)oAuthApplication);
        }
    }

    public int countByC_N(long companyId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByC_N;
        Object[] finderArgs = new Object[]{companyId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_C_N_COMPANYID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append("(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')");
            } else {
                bindName = true;
                sb.append("lower(oAuthApplication.name) LIKE ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                if (bindName) {
                    queryPos.add(StringUtil.toLowerCase((String)name));
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<OAuthApplication> findByU_N(long userId, String name) {
        return this.findByU_N(userId, name, -1, -1, null);
    }

    public List<OAuthApplication> findByU_N(long userId, String name, int start, int end) {
        return this.findByU_N(userId, name, start, end, null);
    }

    public List<OAuthApplication> findByU_N(long userId, String name, int start, int end, OrderByComparator<OAuthApplication> orderByComparator) {
        return this.findByU_N(userId, name, start, end, orderByComparator, true);
    }

    public List<OAuthApplication> findByU_N(long userId, String name, int start, int end, OrderByComparator<OAuthApplication> orderByComparator, boolean useFinderCache) {
        name = Objects.toString(name, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByU_N;
        finderArgs = new Object[]{userId, name, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (OAuthApplication oAuthApplication : list) {
                if (userId == oAuthApplication.getUserId() && StringUtil.wildcardMatches((String)oAuthApplication.getName(), (String)name, (char)'_', (char)'%', (char)'\\', (boolean)false)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_U_N_USERID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append("(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')");
            } else {
                bindName = true;
                sb.append("lower(oAuthApplication.name) LIKE ?");
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindName) {
                    queryPos.add(StringUtil.toLowerCase((String)name));
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public OAuthApplication findByU_N_First(long userId, String name, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByU_N_First(userId, name, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append(", nameLIKE");
        sb.append(name);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByU_N_First(long userId, String name, OrderByComparator<OAuthApplication> orderByComparator) {
        List<OAuthApplication> list = this.findByU_N(userId, name, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication findByU_N_Last(long userId, String name, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = this.fetchByU_N_Last(userId, name, orderByComparator);
        if (oAuthApplication != null) {
            return oAuthApplication;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append(", nameLIKE");
        sb.append(name);
        sb.append("}");
        throw new NoSuchApplicationException(sb.toString());
    }

    public OAuthApplication fetchByU_N_Last(long userId, String name, OrderByComparator<OAuthApplication> orderByComparator) {
        int count = this.countByU_N(userId, name);
        if (count == 0) {
            return null;
        }
        List<OAuthApplication> list = this.findByU_N(userId, name, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public OAuthApplication[] findByU_N_PrevAndNext(long oAuthApplicationId, long userId, String name, OrderByComparator<OAuthApplication> orderByComparator) throws NoSuchApplicationException {
        name = Objects.toString(name, "");
        OAuthApplication oAuthApplication = this.findByPrimaryKey(oAuthApplicationId);
        Session session = null;
        try {
            session = this.openSession();
            OAuthApplication[] array = new OAuthApplicationImpl[]{this.getByU_N_PrevAndNext(session, oAuthApplication, userId, name, orderByComparator, true), oAuthApplication, this.getByU_N_PrevAndNext(session, oAuthApplication, userId, name, orderByComparator, false)};
            OAuthApplication[] oAuthApplicationArray = array;
            return oAuthApplicationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthApplication getByU_N_PrevAndNext(Session session, OAuthApplication oAuthApplication, long userId, String name, OrderByComparator<OAuthApplication> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_OAUTHAPPLICATION_WHERE);
        sb.append(_FINDER_COLUMN_U_N_USERID_2);
        boolean bindName = false;
        if (name.isEmpty()) {
            sb.append("(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')");
        } else {
            bindName = true;
            sb.append("lower(oAuthApplication.name) LIKE ?");
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (bindName) {
            queryPos.add(StringUtil.toLowerCase((String)name));
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)oAuthApplication)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (OAuthApplication)list.get(1);
        }
        return null;
    }

    public void removeByU_N(long userId, String name) {
        for (OAuthApplication oAuthApplication : this.findByU_N(userId, name, -1, -1, null)) {
            this.remove((BaseModel)oAuthApplication);
        }
    }

    public int countByU_N(long userId, String name) {
        name = Objects.toString(name, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByU_N;
        Object[] finderArgs = new Object[]{userId, name};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_OAUTHAPPLICATION_WHERE);
            sb.append(_FINDER_COLUMN_U_N_USERID_2);
            boolean bindName = false;
            if (name.isEmpty()) {
                sb.append("(oAuthApplication.name IS NULL OR oAuthApplication.name LIKE '')");
            } else {
                bindName = true;
                sb.append("lower(oAuthApplication.name) LIKE ?");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindName) {
                    queryPos.add(StringUtil.toLowerCase((String)name));
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public OAuthApplicationPersistenceImpl() {
        this.setModelClass(OAuthApplication.class);
        this.setModelImplClass(OAuthApplicationImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(OAuthApplication oAuthApplication) {
        this.entityCache.putResult(this.entityCacheEnabled, OAuthApplicationImpl.class, (Serializable)Long.valueOf(oAuthApplication.getPrimaryKey()), (Serializable)oAuthApplication);
        this.finderCache.putResult(this._finderPathFetchByConsumerKey, new Object[]{oAuthApplication.getConsumerKey()}, (Object)oAuthApplication);
        oAuthApplication.resetOriginalValues();
    }

    public void cacheResult(List<OAuthApplication> oAuthApplications) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && oAuthApplications.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (OAuthApplication oAuthApplication : oAuthApplications) {
            if (this.entityCache.getResult(this.entityCacheEnabled, OAuthApplicationImpl.class, (Serializable)Long.valueOf(oAuthApplication.getPrimaryKey())) == null) {
                this.cacheResult(oAuthApplication);
                continue;
            }
            oAuthApplication.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(OAuthApplicationImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(OAuthApplication oAuthApplication) {
        this.entityCache.removeResult(this.entityCacheEnabled, OAuthApplicationImpl.class, (Serializable)Long.valueOf(oAuthApplication.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((OAuthApplicationModelImpl)oAuthApplication, true);
    }

    public void clearCache(List<OAuthApplication> oAuthApplications) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (OAuthApplication oAuthApplication : oAuthApplications) {
            this.entityCache.removeResult(this.entityCacheEnabled, OAuthApplicationImpl.class, (Serializable)Long.valueOf(oAuthApplication.getPrimaryKey()));
            this.clearUniqueFindersCache((OAuthApplicationModelImpl)oAuthApplication, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, OAuthApplicationImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(OAuthApplicationModelImpl oAuthApplicationModelImpl) {
        Object[] args = new Object[]{oAuthApplicationModelImpl.getConsumerKey()};
        this.finderCache.putResult(this._finderPathCountByConsumerKey, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByConsumerKey, args, (Object)oAuthApplicationModelImpl, false);
    }

    protected void clearUniqueFindersCache(OAuthApplicationModelImpl oAuthApplicationModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{oAuthApplicationModelImpl.getConsumerKey()};
            this.finderCache.removeResult(this._finderPathCountByConsumerKey, args);
            this.finderCache.removeResult(this._finderPathFetchByConsumerKey, args);
        }
        if ((oAuthApplicationModelImpl.getColumnBitmask() & this._finderPathFetchByConsumerKey.getColumnBitmask()) != 0L) {
            args = new Object[]{oAuthApplicationModelImpl.getOriginalConsumerKey()};
            this.finderCache.removeResult(this._finderPathCountByConsumerKey, args);
            this.finderCache.removeResult(this._finderPathFetchByConsumerKey, args);
        }
    }

    public OAuthApplication create(long oAuthApplicationId) {
        OAuthApplicationImpl oAuthApplication = new OAuthApplicationImpl();
        oAuthApplication.setNew(true);
        oAuthApplication.setPrimaryKey(oAuthApplicationId);
        oAuthApplication.setCompanyId(CompanyThreadLocal.getCompanyId());
        return oAuthApplication;
    }

    public OAuthApplication remove(long oAuthApplicationId) throws NoSuchApplicationException {
        return this.remove(Long.valueOf(oAuthApplicationId));
    }

    public OAuthApplication remove(Serializable primaryKey) throws NoSuchApplicationException {
        Session session = null;
        try {
            session = this.openSession();
            OAuthApplication oAuthApplication = (OAuthApplication)session.get(OAuthApplicationImpl.class, primaryKey);
            if (oAuthApplication == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchApplicationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            OAuthApplication oAuthApplication2 = (OAuthApplication)this.remove((BaseModel)oAuthApplication);
            return oAuthApplication2;
        }
        catch (NoSuchApplicationException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected OAuthApplication removeImpl(OAuthApplication oAuthApplication) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)oAuthApplication)) {
                oAuthApplication = (OAuthApplication)session.get(OAuthApplicationImpl.class, oAuthApplication.getPrimaryKeyObj());
            }
            if (oAuthApplication != null) {
                session.delete((Object)oAuthApplication);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (oAuthApplication != null) {
            this.clearCache(oAuthApplication);
        }
        return oAuthApplication;
    }

    public OAuthApplication updateImpl(OAuthApplication oAuthApplication) {
        boolean isNew = oAuthApplication.isNew();
        if (!(oAuthApplication instanceof OAuthApplicationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(oAuthApplication.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)oAuthApplication);
                throw new IllegalArgumentException("Implement ModelWrapper in oAuthApplication proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom OAuthApplication implementation " + oAuthApplication.getClass());
        }
        OAuthApplicationModelImpl oAuthApplicationModelImpl = (OAuthApplicationModelImpl)oAuthApplication;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && oAuthApplication.getCreateDate() == null) {
            if (serviceContext == null) {
                oAuthApplication.setCreateDate(date);
            } else {
                oAuthApplication.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!oAuthApplicationModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                oAuthApplication.setModifiedDate(date);
            } else {
                oAuthApplication.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)oAuthApplication);
                oAuthApplication.setNew(false);
            } else {
                oAuthApplication = (OAuthApplication)session.merge((Object)oAuthApplication);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{oAuthApplicationModelImpl.getCompanyId()};
            this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            args = new Object[]{oAuthApplicationModelImpl.getUserId()};
            this.finderCache.removeResult(this._finderPathCountByUserId, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((oAuthApplicationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByCompanyId.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuthApplicationModelImpl.getOriginalCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
                args = new Object[]{oAuthApplicationModelImpl.getCompanyId()};
                this.finderCache.removeResult(this._finderPathCountByCompanyId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByCompanyId, args);
            }
            if ((oAuthApplicationModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByUserId.getColumnBitmask()) != 0L) {
                args = new Object[]{oAuthApplicationModelImpl.getOriginalUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
                args = new Object[]{oAuthApplicationModelImpl.getUserId()};
                this.finderCache.removeResult(this._finderPathCountByUserId, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByUserId, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, OAuthApplicationImpl.class, (Serializable)Long.valueOf(oAuthApplication.getPrimaryKey()), (Serializable)oAuthApplication, false);
        this.clearUniqueFindersCache(oAuthApplicationModelImpl, false);
        this.cacheUniqueFindersCache(oAuthApplicationModelImpl);
        oAuthApplication.resetOriginalValues();
        return oAuthApplication;
    }

    public OAuthApplication findByPrimaryKey(Serializable primaryKey) throws NoSuchApplicationException {
        OAuthApplication oAuthApplication = (OAuthApplication)this.fetchByPrimaryKey(primaryKey);
        if (oAuthApplication == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchApplicationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return oAuthApplication;
    }

    public OAuthApplication findByPrimaryKey(long oAuthApplicationId) throws NoSuchApplicationException {
        return this.findByPrimaryKey(Long.valueOf(oAuthApplicationId));
    }

    public OAuthApplication fetchByPrimaryKey(long oAuthApplicationId) {
        return (OAuthApplication)this.fetchByPrimaryKey(Long.valueOf(oAuthApplicationId));
    }

    public List<OAuthApplication> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<OAuthApplication> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<OAuthApplication> findAll(int start, int end, OrderByComparator<OAuthApplication> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<OAuthApplication> findAll(int start, int end, OrderByComparator<OAuthApplication> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_OAUTHAPPLICATION);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_OAUTHAPPLICATION;
                sql = sql.concat(" ORDER BY oAuthApplication.oAuthApplicationId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (OAuthApplication oAuthApplication : this.findAll()) {
            this.remove((BaseModel)oAuthApplication);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_OAUTHAPPLICATION);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "oAuthApplicationId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_OAUTHAPPLICATION;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return OAuthApplicationModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        OAuthApplicationModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        OAuthApplicationModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCompanyId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCompanyId", new String[]{Long.class.getName()}, 1L);
        this._finderPathCountByCompanyId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCompanyId", new String[]{Long.class.getName()});
        this._finderPathWithPaginationFindByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, 8L);
        this._finderPathCountByUserId = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()});
        this._finderPathFetchByConsumerKey = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByConsumerKey", new String[]{String.class.getName()}, 2L);
        this._finderPathCountByConsumerKey = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByConsumerKey", new String[]{String.class.getName()});
        this._finderPathWithPaginationFindByC_N = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_N", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByC_N = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_N", new String[]{Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByU_N = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, OAuthApplicationImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByU_N", new String[]{Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByU_N = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByU_N", new String[]{Long.class.getName(), String.class.getName()});
        OAuthApplicationUtil.setPersistence((OAuthApplicationPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        OAuthApplicationUtil.setPersistence(null);
        this.entityCache.removeCache(OAuthApplicationImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.oauth.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.oauth.model.OAuthApplication"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.oauth.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }
}

