/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.service.http;

import com.liferay.oauth.model.OAuthUser;
import com.liferay.oauth.service.OAuthUserServiceUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.auth.HttpPrincipal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.http.TunnelUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;

public class OAuthUserServiceHttp {
    private static Log _log = LogFactoryUtil.getLog(OAuthUserServiceHttp.class);
    private static final Class<?>[] _addOAuthUserParameterTypes0 = new Class[]{String.class, ServiceContext.class};
    private static final Class<?>[] _deleteOAuthUserParameterTypes1 = new Class[]{Long.TYPE};

    public static OAuthUser addOAuthUser(HttpPrincipal httpPrincipal, String consumerKey, ServiceContext serviceContext) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthUserServiceUtil.class, "addOAuthUser", (Class[])_addOAuthUserParameterTypes0);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{consumerKey, serviceContext});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthUser)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }

    public static OAuthUser deleteOAuthUser(HttpPrincipal httpPrincipal, long oAuthApplicationId) throws PortalException {
        try {
            MethodKey methodKey = new MethodKey(OAuthUserServiceUtil.class, "deleteOAuthUser", (Class[])_deleteOAuthUserParameterTypes1);
            MethodHandler methodHandler = new MethodHandler(methodKey, new Object[]{oAuthApplicationId});
            Object returnObj = null;
            try {
                returnObj = TunnelUtil.invoke((HttpPrincipal)httpPrincipal, (MethodHandler)methodHandler);
            }
            catch (Exception exception) {
                if (exception instanceof PortalException) {
                    throw (PortalException)((Object)exception);
                }
                throw new SystemException((Throwable)exception);
            }
            return (OAuthUser)returnObj;
        }
        catch (SystemException systemException) {
            _log.error((Object)systemException, (Throwable)systemException);
            throw systemException;
        }
    }
}

