/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.oauth.model.OAuthUser;
import com.liferay.oauth.model.OAuthUserModel;
import com.liferay.oauth.model.OAuthUserSoap;
import com.liferay.oauth.model.impl.OAuthUserCacheModel;
import com.liferay.oauth.model.impl.OAuthUserImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

@JSON(strict=true)
public class OAuthUserModelImpl
extends BaseModelImpl<OAuthUser>
implements OAuthUserModel {
    public static final String TABLE_NAME = "OAuth_OAuthUser";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"oAuthUserId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"oAuthApplicationId", -5}, {"accessToken", 12}, {"accessSecret", 12}};
    public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();
    public static final String TABLE_SQL_CREATE = "create table OAuth_OAuthUser (oAuthUserId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,oAuthApplicationId LONG,accessToken VARCHAR(75) null,accessSecret VARCHAR(75) null)";
    public static final String TABLE_SQL_DROP = "drop table OAuth_OAuthUser";
    public static final String ORDER_BY_JPQL = " ORDER BY oAuthUser.oAuthUserId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY OAuth_OAuthUser.oAuthUserId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final long ACCESSTOKEN_COLUMN_BITMASK = 1L;
    public static final long OAUTHAPPLICATIONID_COLUMN_BITMASK = 2L;
    public static final long USERID_COLUMN_BITMASK = 4L;
    public static final long OAUTHUSERID_COLUMN_BITMASK = 8L;
    private static final Map<String, Function<OAuthUser, Object>> _attributeGetterFunctions;
    private static final Map<String, BiConsumer<OAuthUser, Object>> _attributeSetterBiConsumers;
    private static boolean _entityCacheEnabled;
    private static boolean _finderCacheEnabled;
    private long _oAuthUserId;
    private long _companyId;
    private long _userId;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private boolean _setModifiedDate;
    private long _oAuthApplicationId;
    private long _originalOAuthApplicationId;
    private boolean _setOriginalOAuthApplicationId;
    private String _accessToken;
    private String _originalAccessToken;
    private String _accessSecret;
    private long _columnBitmask;
    private OAuthUser _escapedModel;

    public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
        _entityCacheEnabled = entityCacheEnabled;
    }

    public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
        _finderCacheEnabled = finderCacheEnabled;
    }

    public static OAuthUser toModel(OAuthUserSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        OAuthUserImpl model = new OAuthUserImpl();
        model.setOAuthUserId(soapModel.getOAuthUserId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setOAuthApplicationId(soapModel.getOAuthApplicationId());
        model.setAccessToken(soapModel.getAccessToken());
        model.setAccessSecret(soapModel.getAccessSecret());
        return model;
    }

    public static List<OAuthUser> toModels(OAuthUserSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<OAuthUser> models = new ArrayList<OAuthUser>(soapModels.length);
        for (OAuthUserSoap soapModel : soapModels) {
            models.add(OAuthUserModelImpl.toModel(soapModel));
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._oAuthUserId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setOAuthUserId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._oAuthUserId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return OAuthUser.class;
    }

    public String getModelClassName() {
        return OAuthUser.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, Function<OAuthUser, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        for (Map.Entry<String, Function<OAuthUser, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<OAuthUser, Object> attributeGetterFunction = entry.getValue();
            attributes.put(attributeName, attributeGetterFunction.apply((OAuthUser)this));
        }
        attributes.put("entityCacheEnabled", this.isEntityCacheEnabled());
        attributes.put("finderCacheEnabled", this.isFinderCacheEnabled());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        Map<String, BiConsumer<OAuthUser, Object>> attributeSetterBiConsumers = this.getAttributeSetterBiConsumers();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            BiConsumer<OAuthUser, Object> attributeSetterBiConsumer = attributeSetterBiConsumers.get(attributeName);
            if (attributeSetterBiConsumer == null) continue;
            attributeSetterBiConsumer.accept((OAuthUser)this, entry.getValue());
        }
    }

    public Map<String, Function<OAuthUser, Object>> getAttributeGetterFunctions() {
        return _attributeGetterFunctions;
    }

    public Map<String, BiConsumer<OAuthUser, Object>> getAttributeSetterBiConsumers() {
        return _attributeSetterBiConsumers;
    }

    @JSON
    public long getOAuthUserId() {
        return this._oAuthUserId;
    }

    public void setOAuthUserId(long oAuthUserId) {
        this._oAuthUserId = oAuthUserId;
    }

    public String getOAuthUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById((long)this.getOAuthUserId());
            return user.getUuid();
        }
        catch (PortalException portalException) {
            return "";
        }
    }

    public void setOAuthUserUuid(String oAuthUserUuid) {
    }

    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._companyId = companyId;
    }

    @JSON
    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._columnBitmask |= 4L;
        if (!this._setOriginalUserId) {
            this._setOriginalUserId = true;
            this._originalUserId = this._userId;
        }
        this._userId = userId;
    }

    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById((long)this.getUserId());
            return user.getUuid();
        }
        catch (PortalException portalException) {
            return "";
        }
    }

    public void setUserUuid(String userUuid) {
    }

    public long getOriginalUserId() {
        return this._originalUserId;
    }

    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public boolean hasSetModifiedDate() {
        return this._setModifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._setModifiedDate = true;
        this._modifiedDate = modifiedDate;
    }

    @JSON
    public long getOAuthApplicationId() {
        return this._oAuthApplicationId;
    }

    public void setOAuthApplicationId(long oAuthApplicationId) {
        this._columnBitmask |= 2L;
        if (!this._setOriginalOAuthApplicationId) {
            this._setOriginalOAuthApplicationId = true;
            this._originalOAuthApplicationId = this._oAuthApplicationId;
        }
        this._oAuthApplicationId = oAuthApplicationId;
    }

    public long getOriginalOAuthApplicationId() {
        return this._originalOAuthApplicationId;
    }

    @JSON
    public String getAccessToken() {
        if (this._accessToken == null) {
            return "";
        }
        return this._accessToken;
    }

    public void setAccessToken(String accessToken) {
        this._columnBitmask |= 1L;
        if (this._originalAccessToken == null) {
            this._originalAccessToken = this._accessToken;
        }
        this._accessToken = accessToken;
    }

    public String getOriginalAccessToken() {
        return GetterUtil.getString((String)this._originalAccessToken);
    }

    @JSON
    public String getAccessSecret() {
        if (this._accessSecret == null) {
            return "";
        }
        return this._accessSecret;
    }

    public void setAccessSecret(String accessSecret) {
        this._accessSecret = accessSecret;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)OAuthUser.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public OAuthUser toEscapedModel() {
        if (this._escapedModel == null) {
            Function escapedModelProxyProviderFunction = EscapedModelProxyProviderFunctionHolder._escapedModelProxyProviderFunction;
            this._escapedModel = (OAuthUser)escapedModelProxyProviderFunction.apply(new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModel;
    }

    public Object clone() {
        OAuthUserImpl oAuthUserImpl = new OAuthUserImpl();
        oAuthUserImpl.setOAuthUserId(this.getOAuthUserId());
        oAuthUserImpl.setCompanyId(this.getCompanyId());
        oAuthUserImpl.setUserId(this.getUserId());
        oAuthUserImpl.setUserName(this.getUserName());
        oAuthUserImpl.setCreateDate(this.getCreateDate());
        oAuthUserImpl.setModifiedDate(this.getModifiedDate());
        oAuthUserImpl.setOAuthApplicationId(this.getOAuthApplicationId());
        oAuthUserImpl.setAccessToken(this.getAccessToken());
        oAuthUserImpl.setAccessSecret(this.getAccessSecret());
        oAuthUserImpl.resetOriginalValues();
        return oAuthUserImpl;
    }

    public int compareTo(OAuthUser oAuthUser) {
        long primaryKey = oAuthUser.getPrimaryKey();
        if (this.getPrimaryKey() < primaryKey) {
            return -1;
        }
        if (this.getPrimaryKey() > primaryKey) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OAuthUser)) {
            return false;
        }
        OAuthUser oAuthUser = (OAuthUser)object;
        long primaryKey = oAuthUser.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public boolean isEntityCacheEnabled() {
        return _entityCacheEnabled;
    }

    public boolean isFinderCacheEnabled() {
        return _finderCacheEnabled;
    }

    public void resetOriginalValues() {
        this._originalUserId = this._userId;
        this._setOriginalUserId = false;
        this._setModifiedDate = false;
        this._originalOAuthApplicationId = this._oAuthApplicationId;
        this._setOriginalOAuthApplicationId = false;
        this._originalAccessToken = this._accessToken;
        this._columnBitmask = 0L;
    }

    public CacheModel<OAuthUser> toCacheModel() {
        String accessSecret;
        Date createDate;
        OAuthUserCacheModel oAuthUserCacheModel = new OAuthUserCacheModel();
        oAuthUserCacheModel.oAuthUserId = this.getOAuthUserId();
        oAuthUserCacheModel.companyId = this.getCompanyId();
        oAuthUserCacheModel.userId = this.getUserId();
        oAuthUserCacheModel.userName = this.getUserName();
        String userName = oAuthUserCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            oAuthUserCacheModel.userName = null;
        }
        oAuthUserCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        oAuthUserCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        oAuthUserCacheModel.oAuthApplicationId = this.getOAuthApplicationId();
        oAuthUserCacheModel.accessToken = this.getAccessToken();
        String accessToken = oAuthUserCacheModel.accessToken;
        if (accessToken != null && accessToken.length() == 0) {
            oAuthUserCacheModel.accessToken = null;
        }
        if ((accessSecret = (oAuthUserCacheModel.accessSecret = this.getAccessSecret())) != null && accessSecret.length() == 0) {
            oAuthUserCacheModel.accessSecret = null;
        }
        return oAuthUserCacheModel;
    }

    public String toString() {
        Map<String, Function<OAuthUser, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 2);
        sb.append("{");
        for (Map.Entry<String, Function<OAuthUser, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<OAuthUser, Object> attributeGetterFunction = entry.getValue();
            sb.append("\"");
            sb.append(attributeName);
            sb.append("\": ");
            Object value = attributeGetterFunction.apply((OAuthUser)this);
            if (value == null) {
                sb.append("null");
            } else if (value instanceof Blob || value instanceof Date || value instanceof Map || value instanceof String) {
                sb.append("\"" + StringUtil.replace((String)value.toString(), (String)"\"", (String)"'") + "\"");
            } else {
                sb.append(value);
            }
            sb.append(", ");
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        Map<String, Function<OAuthUser, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 4);
        sb.append("<model><model-name>");
        sb.append(this.getModelClassName());
        sb.append("</model-name>");
        for (Map.Entry<String, Function<OAuthUser, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<OAuthUser, Object> attributeGetterFunction = entry.getValue();
            sb.append("<column><column-name>");
            sb.append(attributeName);
            sb.append("</column-name><column-value><![CDATA[");
            sb.append(attributeGetterFunction.apply((OAuthUser)this));
            sb.append("]]></column-value></column>");
        }
        sb.append("</model>");
        return sb.toString();
    }

    static {
        TABLE_COLUMNS_MAP.put("oAuthUserId", -5);
        TABLE_COLUMNS_MAP.put("companyId", -5);
        TABLE_COLUMNS_MAP.put("userId", -5);
        TABLE_COLUMNS_MAP.put("userName", 12);
        TABLE_COLUMNS_MAP.put("createDate", 93);
        TABLE_COLUMNS_MAP.put("modifiedDate", 93);
        TABLE_COLUMNS_MAP.put("oAuthApplicationId", -5);
        TABLE_COLUMNS_MAP.put("accessToken", 12);
        TABLE_COLUMNS_MAP.put("accessSecret", 12);
        LinkedHashMap<String, Function<OAuthUser, Object>> attributeGetterFunctions = new LinkedHashMap<String, Function<OAuthUser, Object>>();
        attributeGetterFunctions.put("oAuthUserId", OAuthUserModel::getOAuthUserId);
        attributeGetterFunctions.put("companyId", OAuthUserModel::getCompanyId);
        attributeGetterFunctions.put("userId", OAuthUserModel::getUserId);
        attributeGetterFunctions.put("userName", OAuthUserModel::getUserName);
        attributeGetterFunctions.put("createDate", OAuthUserModel::getCreateDate);
        attributeGetterFunctions.put("modifiedDate", OAuthUserModel::getModifiedDate);
        attributeGetterFunctions.put("oAuthApplicationId", OAuthUserModel::getOAuthApplicationId);
        attributeGetterFunctions.put("accessToken", OAuthUserModel::getAccessToken);
        attributeGetterFunctions.put("accessSecret", OAuthUserModel::getAccessSecret);
        _attributeGetterFunctions = Collections.unmodifiableMap(attributeGetterFunctions);
        LinkedHashMap<String, BiConsumer<OAuthUser, Object>> attributeSetterBiConsumers = new LinkedHashMap<String, BiConsumer<OAuthUser, Object>>();
        attributeSetterBiConsumers.put("oAuthUserId", OAuthUserModel::setOAuthUserId);
        attributeSetterBiConsumers.put("companyId", OAuthUserModel::setCompanyId);
        attributeSetterBiConsumers.put("userId", OAuthUserModel::setUserId);
        attributeSetterBiConsumers.put("userName", OAuthUserModel::setUserName);
        attributeSetterBiConsumers.put("createDate", OAuthUserModel::setCreateDate);
        attributeSetterBiConsumers.put("modifiedDate", OAuthUserModel::setModifiedDate);
        attributeSetterBiConsumers.put("oAuthApplicationId", OAuthUserModel::setOAuthApplicationId);
        attributeSetterBiConsumers.put("accessToken", OAuthUserModel::setAccessToken);
        attributeSetterBiConsumers.put("accessSecret", OAuthUserModel::setAccessSecret);
        _attributeSetterBiConsumers = Collections.unmodifiableMap(attributeSetterBiConsumers);
    }

    private static class EscapedModelProxyProviderFunctionHolder {
        private static final Function<InvocationHandler, OAuthUser> _escapedModelProxyProviderFunction = ProxyUtil.getProxyProviderFunction((Class[])new Class[]{OAuthUser.class, ModelWrapper.class});

        private EscapedModelProxyProviderFunctionHolder() {
        }
    }
}

