/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.oauth.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.oauth.model.OAuthApplication;
import com.liferay.oauth.model.OAuthApplicationModel;
import com.liferay.oauth.model.OAuthApplicationSoap;
import com.liferay.oauth.model.impl.OAuthApplicationCacheModel;
import com.liferay.oauth.model.impl.OAuthApplicationImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;

@JSON(strict=true)
public class OAuthApplicationModelImpl
extends BaseModelImpl<OAuthApplication>
implements OAuthApplicationModel {
    public static final String TABLE_NAME = "OAuth_OAuthApplication";
    public static final Object[][] TABLE_COLUMNS = new Object[][]{{"oAuthApplicationId", -5}, {"companyId", -5}, {"userId", -5}, {"userName", 12}, {"createDate", 93}, {"modifiedDate", 93}, {"name", 12}, {"description", 12}, {"consumerKey", 12}, {"consumerSecret", 12}, {"accessLevel", 4}, {"logoId", -5}, {"shareableAccessToken", 16}, {"callbackURI", 12}, {"websiteURL", 12}};
    public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();
    public static final String TABLE_SQL_CREATE = "create table OAuth_OAuthApplication (oAuthApplicationId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,name VARCHAR(75) null,description STRING null,consumerKey VARCHAR(75) null,consumerSecret VARCHAR(75) null,accessLevel INTEGER,logoId LONG,shareableAccessToken BOOLEAN,callbackURI STRING null,websiteURL STRING null)";
    public static final String TABLE_SQL_DROP = "drop table OAuth_OAuthApplication";
    public static final String ORDER_BY_JPQL = " ORDER BY oAuthApplication.oAuthApplicationId ASC";
    public static final String ORDER_BY_SQL = " ORDER BY OAuth_OAuthApplication.oAuthApplicationId ASC";
    public static final String DATA_SOURCE = "liferayDataSource";
    public static final String SESSION_FACTORY = "liferaySessionFactory";
    public static final String TX_MANAGER = "liferayTransactionManager";
    public static final long COMPANYID_COLUMN_BITMASK = 1L;
    public static final long CONSUMERKEY_COLUMN_BITMASK = 2L;
    public static final long NAME_COLUMN_BITMASK = 4L;
    public static final long USERID_COLUMN_BITMASK = 8L;
    public static final long OAUTHAPPLICATIONID_COLUMN_BITMASK = 16L;
    private static final Map<String, Function<OAuthApplication, Object>> _attributeGetterFunctions;
    private static final Map<String, BiConsumer<OAuthApplication, Object>> _attributeSetterBiConsumers;
    private static boolean _entityCacheEnabled;
    private static boolean _finderCacheEnabled;
    private long _oAuthApplicationId;
    private long _companyId;
    private long _originalCompanyId;
    private boolean _setOriginalCompanyId;
    private long _userId;
    private long _originalUserId;
    private boolean _setOriginalUserId;
    private String _userName;
    private Date _createDate;
    private Date _modifiedDate;
    private boolean _setModifiedDate;
    private String _name;
    private String _originalName;
    private String _description;
    private String _consumerKey;
    private String _originalConsumerKey;
    private String _consumerSecret;
    private int _accessLevel;
    private long _logoId;
    private boolean _shareableAccessToken;
    private String _callbackURI;
    private String _websiteURL;
    private long _columnBitmask;
    private OAuthApplication _escapedModel;

    public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
        _entityCacheEnabled = entityCacheEnabled;
    }

    public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
        _finderCacheEnabled = finderCacheEnabled;
    }

    public static OAuthApplication toModel(OAuthApplicationSoap soapModel) {
        if (soapModel == null) {
            return null;
        }
        OAuthApplicationImpl model = new OAuthApplicationImpl();
        model.setOAuthApplicationId(soapModel.getOAuthApplicationId());
        model.setCompanyId(soapModel.getCompanyId());
        model.setUserId(soapModel.getUserId());
        model.setUserName(soapModel.getUserName());
        model.setCreateDate(soapModel.getCreateDate());
        model.setModifiedDate(soapModel.getModifiedDate());
        model.setName(soapModel.getName());
        model.setDescription(soapModel.getDescription());
        model.setConsumerKey(soapModel.getConsumerKey());
        model.setConsumerSecret(soapModel.getConsumerSecret());
        model.setAccessLevel(soapModel.getAccessLevel());
        model.setLogoId(soapModel.getLogoId());
        model.setShareableAccessToken(soapModel.isShareableAccessToken());
        model.setCallbackURI(soapModel.getCallbackURI());
        model.setWebsiteURL(soapModel.getWebsiteURL());
        return model;
    }

    public static List<OAuthApplication> toModels(OAuthApplicationSoap[] soapModels) {
        if (soapModels == null) {
            return null;
        }
        ArrayList<OAuthApplication> models = new ArrayList<OAuthApplication>(soapModels.length);
        for (OAuthApplicationSoap soapModel : soapModels) {
            models.add(OAuthApplicationModelImpl.toModel(soapModel));
        }
        return models;
    }

    public long getPrimaryKey() {
        return this._oAuthApplicationId;
    }

    public void setPrimaryKey(long primaryKey) {
        this.setOAuthApplicationId(primaryKey);
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this._oAuthApplicationId);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this.setPrimaryKey((Long)primaryKeyObj);
    }

    public Class<?> getModelClass() {
        return OAuthApplication.class;
    }

    public String getModelClassName() {
        return OAuthApplication.class.getName();
    }

    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        Map<String, Function<OAuthApplication, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        for (Map.Entry<String, Function<OAuthApplication, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<OAuthApplication, Object> attributeGetterFunction = entry.getValue();
            attributes.put(attributeName, attributeGetterFunction.apply((OAuthApplication)this));
        }
        attributes.put("entityCacheEnabled", this.isEntityCacheEnabled());
        attributes.put("finderCacheEnabled", this.isFinderCacheEnabled());
        return attributes;
    }

    public void setModelAttributes(Map<String, Object> attributes) {
        Map<String, BiConsumer<OAuthApplication, Object>> attributeSetterBiConsumers = this.getAttributeSetterBiConsumers();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String attributeName = entry.getKey();
            BiConsumer<OAuthApplication, Object> attributeSetterBiConsumer = attributeSetterBiConsumers.get(attributeName);
            if (attributeSetterBiConsumer == null) continue;
            attributeSetterBiConsumer.accept((OAuthApplication)this, entry.getValue());
        }
    }

    public Map<String, Function<OAuthApplication, Object>> getAttributeGetterFunctions() {
        return _attributeGetterFunctions;
    }

    public Map<String, BiConsumer<OAuthApplication, Object>> getAttributeSetterBiConsumers() {
        return _attributeSetterBiConsumers;
    }

    @JSON
    public long getOAuthApplicationId() {
        return this._oAuthApplicationId;
    }

    public void setOAuthApplicationId(long oAuthApplicationId) {
        this._oAuthApplicationId = oAuthApplicationId;
    }

    @JSON
    public long getCompanyId() {
        return this._companyId;
    }

    public void setCompanyId(long companyId) {
        this._columnBitmask |= 1L;
        if (!this._setOriginalCompanyId) {
            this._setOriginalCompanyId = true;
            this._originalCompanyId = this._companyId;
        }
        this._companyId = companyId;
    }

    public long getOriginalCompanyId() {
        return this._originalCompanyId;
    }

    @JSON
    public long getUserId() {
        return this._userId;
    }

    public void setUserId(long userId) {
        this._columnBitmask |= 8L;
        if (!this._setOriginalUserId) {
            this._setOriginalUserId = true;
            this._originalUserId = this._userId;
        }
        this._userId = userId;
    }

    public String getUserUuid() {
        try {
            User user = UserLocalServiceUtil.getUserById((long)this.getUserId());
            return user.getUuid();
        }
        catch (PortalException portalException) {
            return "";
        }
    }

    public void setUserUuid(String userUuid) {
    }

    public long getOriginalUserId() {
        return this._originalUserId;
    }

    @JSON
    public String getUserName() {
        if (this._userName == null) {
            return "";
        }
        return this._userName;
    }

    public void setUserName(String userName) {
        this._userName = userName;
    }

    @JSON
    public Date getCreateDate() {
        return this._createDate;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    @JSON
    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public boolean hasSetModifiedDate() {
        return this._setModifiedDate;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._setModifiedDate = true;
        this._modifiedDate = modifiedDate;
    }

    @JSON
    public String getName() {
        if (this._name == null) {
            return "";
        }
        return this._name;
    }

    public void setName(String name) {
        this._columnBitmask |= 4L;
        if (this._originalName == null) {
            this._originalName = this._name;
        }
        this._name = name;
    }

    public String getOriginalName() {
        return GetterUtil.getString((String)this._originalName);
    }

    @JSON
    public String getDescription() {
        if (this._description == null) {
            return "";
        }
        return this._description;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    @JSON
    public String getConsumerKey() {
        if (this._consumerKey == null) {
            return "";
        }
        return this._consumerKey;
    }

    public void setConsumerKey(String consumerKey) {
        this._columnBitmask |= 2L;
        if (this._originalConsumerKey == null) {
            this._originalConsumerKey = this._consumerKey;
        }
        this._consumerKey = consumerKey;
    }

    public String getOriginalConsumerKey() {
        return GetterUtil.getString((String)this._originalConsumerKey);
    }

    @JSON
    public String getConsumerSecret() {
        if (this._consumerSecret == null) {
            return "";
        }
        return this._consumerSecret;
    }

    public void setConsumerSecret(String consumerSecret) {
        this._consumerSecret = consumerSecret;
    }

    @JSON
    public int getAccessLevel() {
        return this._accessLevel;
    }

    public void setAccessLevel(int accessLevel) {
        this._accessLevel = accessLevel;
    }

    @JSON
    public long getLogoId() {
        return this._logoId;
    }

    public void setLogoId(long logoId) {
        this._logoId = logoId;
    }

    @JSON
    public boolean getShareableAccessToken() {
        return this._shareableAccessToken;
    }

    @JSON
    public boolean isShareableAccessToken() {
        return this._shareableAccessToken;
    }

    public void setShareableAccessToken(boolean shareableAccessToken) {
        this._shareableAccessToken = shareableAccessToken;
    }

    @JSON
    public String getCallbackURI() {
        if (this._callbackURI == null) {
            return "";
        }
        return this._callbackURI;
    }

    public void setCallbackURI(String callbackURI) {
        this._callbackURI = callbackURI;
    }

    @JSON
    public String getWebsiteURL() {
        if (this._websiteURL == null) {
            return "";
        }
        return this._websiteURL;
    }

    public void setWebsiteURL(String websiteURL) {
        this._websiteURL = websiteURL;
    }

    public long getColumnBitmask() {
        return this._columnBitmask;
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)OAuthApplication.class.getName(), (long)this.getPrimaryKey());
    }

    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        expandoBridge.setAttributes(serviceContext);
    }

    public OAuthApplication toEscapedModel() {
        if (this._escapedModel == null) {
            Function escapedModelProxyProviderFunction = EscapedModelProxyProviderFunctionHolder._escapedModelProxyProviderFunction;
            this._escapedModel = (OAuthApplication)escapedModelProxyProviderFunction.apply(new AutoEscapeBeanHandler((Object)this));
        }
        return this._escapedModel;
    }

    public Object clone() {
        OAuthApplicationImpl oAuthApplicationImpl = new OAuthApplicationImpl();
        oAuthApplicationImpl.setOAuthApplicationId(this.getOAuthApplicationId());
        oAuthApplicationImpl.setCompanyId(this.getCompanyId());
        oAuthApplicationImpl.setUserId(this.getUserId());
        oAuthApplicationImpl.setUserName(this.getUserName());
        oAuthApplicationImpl.setCreateDate(this.getCreateDate());
        oAuthApplicationImpl.setModifiedDate(this.getModifiedDate());
        oAuthApplicationImpl.setName(this.getName());
        oAuthApplicationImpl.setDescription(this.getDescription());
        oAuthApplicationImpl.setConsumerKey(this.getConsumerKey());
        oAuthApplicationImpl.setConsumerSecret(this.getConsumerSecret());
        oAuthApplicationImpl.setAccessLevel(this.getAccessLevel());
        oAuthApplicationImpl.setLogoId(this.getLogoId());
        oAuthApplicationImpl.setShareableAccessToken(this.isShareableAccessToken());
        oAuthApplicationImpl.setCallbackURI(this.getCallbackURI());
        oAuthApplicationImpl.setWebsiteURL(this.getWebsiteURL());
        oAuthApplicationImpl.resetOriginalValues();
        return oAuthApplicationImpl;
    }

    public int compareTo(OAuthApplication oAuthApplication) {
        long primaryKey = oAuthApplication.getPrimaryKey();
        if (this.getPrimaryKey() < primaryKey) {
            return -1;
        }
        if (this.getPrimaryKey() > primaryKey) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof OAuthApplication)) {
            return false;
        }
        OAuthApplication oAuthApplication = (OAuthApplication)object;
        long primaryKey = oAuthApplication.getPrimaryKey();
        return this.getPrimaryKey() == primaryKey;
    }

    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    public boolean isEntityCacheEnabled() {
        return _entityCacheEnabled;
    }

    public boolean isFinderCacheEnabled() {
        return _finderCacheEnabled;
    }

    public void resetOriginalValues() {
        this._originalCompanyId = this._companyId;
        this._setOriginalCompanyId = false;
        this._originalUserId = this._userId;
        this._setOriginalUserId = false;
        this._setModifiedDate = false;
        this._originalName = this._name;
        this._originalConsumerKey = this._consumerKey;
        this._columnBitmask = 0L;
    }

    public CacheModel<OAuthApplication> toCacheModel() {
        String websiteURL;
        String consumerSecret;
        String consumerKey;
        String description;
        Date createDate;
        OAuthApplicationCacheModel oAuthApplicationCacheModel = new OAuthApplicationCacheModel();
        oAuthApplicationCacheModel.oAuthApplicationId = this.getOAuthApplicationId();
        oAuthApplicationCacheModel.companyId = this.getCompanyId();
        oAuthApplicationCacheModel.userId = this.getUserId();
        oAuthApplicationCacheModel.userName = this.getUserName();
        String userName = oAuthApplicationCacheModel.userName;
        if (userName != null && userName.length() == 0) {
            oAuthApplicationCacheModel.userName = null;
        }
        oAuthApplicationCacheModel.createDate = (createDate = this.getCreateDate()) != null ? createDate.getTime() : Long.MIN_VALUE;
        Date modifiedDate = this.getModifiedDate();
        oAuthApplicationCacheModel.modifiedDate = modifiedDate != null ? modifiedDate.getTime() : Long.MIN_VALUE;
        oAuthApplicationCacheModel.name = this.getName();
        String name = oAuthApplicationCacheModel.name;
        if (name != null && name.length() == 0) {
            oAuthApplicationCacheModel.name = null;
        }
        if ((description = (oAuthApplicationCacheModel.description = this.getDescription())) != null && description.length() == 0) {
            oAuthApplicationCacheModel.description = null;
        }
        if ((consumerKey = (oAuthApplicationCacheModel.consumerKey = this.getConsumerKey())) != null && consumerKey.length() == 0) {
            oAuthApplicationCacheModel.consumerKey = null;
        }
        if ((consumerSecret = (oAuthApplicationCacheModel.consumerSecret = this.getConsumerSecret())) != null && consumerSecret.length() == 0) {
            oAuthApplicationCacheModel.consumerSecret = null;
        }
        oAuthApplicationCacheModel.accessLevel = this.getAccessLevel();
        oAuthApplicationCacheModel.logoId = this.getLogoId();
        oAuthApplicationCacheModel.shareableAccessToken = this.isShareableAccessToken();
        oAuthApplicationCacheModel.callbackURI = this.getCallbackURI();
        String callbackURI = oAuthApplicationCacheModel.callbackURI;
        if (callbackURI != null && callbackURI.length() == 0) {
            oAuthApplicationCacheModel.callbackURI = null;
        }
        if ((websiteURL = (oAuthApplicationCacheModel.websiteURL = this.getWebsiteURL())) != null && websiteURL.length() == 0) {
            oAuthApplicationCacheModel.websiteURL = null;
        }
        return oAuthApplicationCacheModel;
    }

    public String toString() {
        Map<String, Function<OAuthApplication, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 2);
        sb.append("{");
        for (Map.Entry<String, Function<OAuthApplication, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<OAuthApplication, Object> attributeGetterFunction = entry.getValue();
            sb.append("\"");
            sb.append(attributeName);
            sb.append("\": ");
            Object value = attributeGetterFunction.apply((OAuthApplication)this);
            if (value == null) {
                sb.append("null");
            } else if (value instanceof Blob || value instanceof Date || value instanceof Map || value instanceof String) {
                sb.append("\"" + StringUtil.replace((String)value.toString(), (String)"\"", (String)"'") + "\"");
            } else {
                sb.append(value);
            }
            sb.append(", ");
        }
        if (sb.index() > 1) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public String toXmlString() {
        Map<String, Function<OAuthApplication, Object>> attributeGetterFunctions = this.getAttributeGetterFunctions();
        StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 4);
        sb.append("<model><model-name>");
        sb.append(this.getModelClassName());
        sb.append("</model-name>");
        for (Map.Entry<String, Function<OAuthApplication, Object>> entry : attributeGetterFunctions.entrySet()) {
            String attributeName = entry.getKey();
            Function<OAuthApplication, Object> attributeGetterFunction = entry.getValue();
            sb.append("<column><column-name>");
            sb.append(attributeName);
            sb.append("</column-name><column-value><![CDATA[");
            sb.append(attributeGetterFunction.apply((OAuthApplication)this));
            sb.append("]]></column-value></column>");
        }
        sb.append("</model>");
        return sb.toString();
    }

    static {
        TABLE_COLUMNS_MAP.put("oAuthApplicationId", -5);
        TABLE_COLUMNS_MAP.put("companyId", -5);
        TABLE_COLUMNS_MAP.put("userId", -5);
        TABLE_COLUMNS_MAP.put("userName", 12);
        TABLE_COLUMNS_MAP.put("createDate", 93);
        TABLE_COLUMNS_MAP.put("modifiedDate", 93);
        TABLE_COLUMNS_MAP.put("name", 12);
        TABLE_COLUMNS_MAP.put("description", 12);
        TABLE_COLUMNS_MAP.put("consumerKey", 12);
        TABLE_COLUMNS_MAP.put("consumerSecret", 12);
        TABLE_COLUMNS_MAP.put("accessLevel", 4);
        TABLE_COLUMNS_MAP.put("logoId", -5);
        TABLE_COLUMNS_MAP.put("shareableAccessToken", 16);
        TABLE_COLUMNS_MAP.put("callbackURI", 12);
        TABLE_COLUMNS_MAP.put("websiteURL", 12);
        LinkedHashMap<String, Function<OAuthApplication, Object>> attributeGetterFunctions = new LinkedHashMap<String, Function<OAuthApplication, Object>>();
        attributeGetterFunctions.put("oAuthApplicationId", OAuthApplicationModel::getOAuthApplicationId);
        attributeGetterFunctions.put("companyId", OAuthApplicationModel::getCompanyId);
        attributeGetterFunctions.put("userId", OAuthApplicationModel::getUserId);
        attributeGetterFunctions.put("userName", OAuthApplicationModel::getUserName);
        attributeGetterFunctions.put("createDate", OAuthApplicationModel::getCreateDate);
        attributeGetterFunctions.put("modifiedDate", OAuthApplicationModel::getModifiedDate);
        attributeGetterFunctions.put("name", OAuthApplicationModel::getName);
        attributeGetterFunctions.put("description", OAuthApplicationModel::getDescription);
        attributeGetterFunctions.put("consumerKey", OAuthApplicationModel::getConsumerKey);
        attributeGetterFunctions.put("consumerSecret", OAuthApplicationModel::getConsumerSecret);
        attributeGetterFunctions.put("accessLevel", OAuthApplicationModel::getAccessLevel);
        attributeGetterFunctions.put("logoId", OAuthApplicationModel::getLogoId);
        attributeGetterFunctions.put("shareableAccessToken", OAuthApplicationModel::getShareableAccessToken);
        attributeGetterFunctions.put("callbackURI", OAuthApplicationModel::getCallbackURI);
        attributeGetterFunctions.put("websiteURL", OAuthApplicationModel::getWebsiteURL);
        _attributeGetterFunctions = Collections.unmodifiableMap(attributeGetterFunctions);
        LinkedHashMap<String, BiConsumer<OAuthApplication, Object>> attributeSetterBiConsumers = new LinkedHashMap<String, BiConsumer<OAuthApplication, Object>>();
        attributeSetterBiConsumers.put("oAuthApplicationId", OAuthApplicationModel::setOAuthApplicationId);
        attributeSetterBiConsumers.put("companyId", OAuthApplicationModel::setCompanyId);
        attributeSetterBiConsumers.put("userId", OAuthApplicationModel::setUserId);
        attributeSetterBiConsumers.put("userName", OAuthApplicationModel::setUserName);
        attributeSetterBiConsumers.put("createDate", OAuthApplicationModel::setCreateDate);
        attributeSetterBiConsumers.put("modifiedDate", OAuthApplicationModel::setModifiedDate);
        attributeSetterBiConsumers.put("name", OAuthApplicationModel::setName);
        attributeSetterBiConsumers.put("description", OAuthApplicationModel::setDescription);
        attributeSetterBiConsumers.put("consumerKey", OAuthApplicationModel::setConsumerKey);
        attributeSetterBiConsumers.put("consumerSecret", OAuthApplicationModel::setConsumerSecret);
        attributeSetterBiConsumers.put("accessLevel", OAuthApplicationModel::setAccessLevel);
        attributeSetterBiConsumers.put("logoId", OAuthApplicationModel::setLogoId);
        attributeSetterBiConsumers.put("shareableAccessToken", OAuthApplicationModel::setShareableAccessToken);
        attributeSetterBiConsumers.put("callbackURI", OAuthApplicationModel::setCallbackURI);
        attributeSetterBiConsumers.put("websiteURL", OAuthApplicationModel::setWebsiteURL);
        _attributeSetterBiConsumers = Collections.unmodifiableMap(attributeSetterBiConsumers);
    }

    private static class EscapedModelProxyProviderFunctionHolder {
        private static final Function<InvocationHandler, OAuthApplication> _escapedModelProxyProviderFunction = ProxyUtil.getProxyProviderFunction((Class[])new Class[]{OAuthApplication.class, ModelWrapper.class});

        private EscapedModelProxyProviderFunctionHolder() {
        }
    }
}

