/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;

public class DefaultUsersProvider
implements UsersProvider {
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final UserLocalService _userLocalService;

    public DefaultUsersProvider(PermissionCheckerFactory permissionCheckerFactory, UserLocalService userLocalService) {
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._userLocalService = userLocalService;
    }

    @Override
    public String getRecipientType() {
        return "user";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext, List<String> values) throws PortalException {
        return TransformUtil.unsafeTransform(values, value -> {
            User user = this._userLocalService.getUserByScreenName(notificationContext.getCompanyId(), value);
            if (!ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW").booleanValue()) {
                return null;
            }
            return user;
        });
    }
}

