/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.service.NotificationRecipientLocalService;
import com.liferay.notification.service.persistence.NotificationRecipientPersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class NotificationRecipientLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
NotificationRecipientLocalService {
    protected NotificationRecipientLocalService notificationRecipientLocalService;
    @Reference
    protected NotificationRecipientPersistence notificationRecipientPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(NotificationRecipientLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public NotificationRecipient addNotificationRecipient(NotificationRecipient notificationRecipient) {
        notificationRecipient.setNew(true);
        return (NotificationRecipient)this.notificationRecipientPersistence.update((BaseModel)notificationRecipient);
    }

    @Transactional(enabled=false)
    public NotificationRecipient createNotificationRecipient(long notificationRecipientId) {
        return this.notificationRecipientPersistence.create(notificationRecipientId);
    }

    @Indexable(type=IndexableType.DELETE)
    public NotificationRecipient deleteNotificationRecipient(long notificationRecipientId) throws PortalException {
        return this.notificationRecipientPersistence.remove(notificationRecipientId);
    }

    @Indexable(type=IndexableType.DELETE)
    public NotificationRecipient deleteNotificationRecipient(NotificationRecipient notificationRecipient) {
        return (NotificationRecipient)this.notificationRecipientPersistence.remove((BaseModel)notificationRecipient);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.notificationRecipientPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(NotificationRecipient.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.notificationRecipientPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.notificationRecipientPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.notificationRecipientPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.notificationRecipientPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.notificationRecipientPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public NotificationRecipient fetchNotificationRecipient(long notificationRecipientId) {
        return this.notificationRecipientPersistence.fetchByPrimaryKey(notificationRecipientId);
    }

    public NotificationRecipient fetchNotificationRecipientByUuidAndCompanyId(String uuid, long companyId) {
        return this.notificationRecipientPersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public NotificationRecipient getNotificationRecipient(long notificationRecipientId) throws PortalException {
        return this.notificationRecipientPersistence.findByPrimaryKey(notificationRecipientId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.notificationRecipientLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(NotificationRecipient.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("notificationRecipientId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.notificationRecipientLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(NotificationRecipient.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("notificationRecipientId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.notificationRecipientLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(NotificationRecipient.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("notificationRecipientId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        final ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
                StagedModelType stagedModelType = exportActionableDynamicQuery.getStagedModelType();
                long referrerClassNameId = stagedModelType.getReferrerClassNameId();
                Property classNameIdProperty = PropertyFactoryUtil.forName((String)"classNameId");
                if (referrerClassNameId != -1L && referrerClassNameId != -2L) {
                    dynamicQuery.add(classNameIdProperty.eq((Object)stagedModelType.getReferrerClassNameId()));
                } else if (referrerClassNameId == -2L) {
                    dynamicQuery.add(classNameIdProperty.isNotNull());
                }
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<NotificationRecipient>(){

            public void performAction(NotificationRecipient notificationRecipient) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)notificationRecipient);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)NotificationRecipient.class.getName()), -1L));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.notificationRecipientPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement NotificationRecipientLocalServiceImpl#deleteNotificationRecipient(NotificationRecipient) to avoid orphaned data");
        }
        return this.notificationRecipientLocalService.deleteNotificationRecipient((NotificationRecipient)persistedModel);
    }

    public BasePersistence<NotificationRecipient> getBasePersistence() {
        return this.notificationRecipientPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.notificationRecipientPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public NotificationRecipient getNotificationRecipientByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.notificationRecipientPersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<NotificationRecipient> getNotificationRecipients(int start, int end) {
        return this.notificationRecipientPersistence.findAll(start, end);
    }

    public int getNotificationRecipientsCount() {
        return this.notificationRecipientPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationRecipient updateNotificationRecipient(NotificationRecipient notificationRecipient) {
        return (NotificationRecipient)this.notificationRecipientPersistence.update((BaseModel)notificationRecipient);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{NotificationRecipientLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.notificationRecipientLocalService = (NotificationRecipientLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return NotificationRecipientLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return NotificationRecipient.class;
    }

    protected String getModelClassName() {
        return NotificationRecipient.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.notificationRecipientPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

