/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.upgrade.v3_10_4;

import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.PortalUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class DeleteStaleNotificationQueueEntriesAndNotificationTemplatesUpgradeProcess
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(DeleteStaleNotificationQueueEntriesAndNotificationTemplatesUpgradeProcess.class);
    private final ClassNameLocalService _classNameLocalService;
    private final GroupLocalService _groupLocalService;
    private final PortletFileRepository _portletFileRepository;
    private final ResourcePermissionLocalService _resourcePermissionLocalService;

    public DeleteStaleNotificationQueueEntriesAndNotificationTemplatesUpgradeProcess(ClassNameLocalService classNameLocalService, GroupLocalService groupLocalService, PortletFileRepository portletFileRepository, ResourcePermissionLocalService resourcePermissionLocalService) {
        this._classNameLocalService = classNameLocalService;
        this._groupLocalService = groupLocalService;
        this._portletFileRepository = portletFileRepository;
        this._resourcePermissionLocalService = resourcePermissionLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._deleteNotificationQueueEntries();
        this._deleteNotificationTemplates();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void _deleteNotificationQueueEntries() throws Exception {
        try (PreparedStatement deletePreparedStatement1 = this._getDeletePreparedStatement("notificationQueueEntryId", "NQueueEntryAttachment");
             PreparedStatement deletePreparedStatement2 = this._getDeletePreparedStatement("notificationQueueEntryId", "NotificationQueueEntry");
             PreparedStatement selectPreparedStatement1 = this._getSelectPreparedStatement();
             PreparedStatement selectPreparedStatement2 = this._getSelectPreparedStatement("NotificationQueueEntry");
             ResultSet resultSet1 = selectPreparedStatement2.executeQuery();){
            while (resultSet1.next()) {
                long notificationQueueEntryId = resultSet1.getLong("notificationQueueEntryId");
                long companyId = resultSet1.getLong("companyId");
                this._deleteResourcePermissions(companyId, NotificationQueueEntry.class.getName(), notificationQueueEntryId);
                deletePreparedStatement1.setLong(1, notificationQueueEntryId);
                deletePreparedStatement1.addBatch();
                deletePreparedStatement2.setLong(1, notificationQueueEntryId);
                deletePreparedStatement2.addBatch();
                selectPreparedStatement1.setLong(1, PortalUtil.getClassNameId((String)NotificationQueueEntry.class.getName()));
                selectPreparedStatement1.setLong(2, notificationQueueEntryId);
                ResultSet resultSet2 = selectPreparedStatement1.executeQuery();
                while (resultSet2.next()) {
                    this._deleteNotificationRecipient(resultSet2.getLong(1));
                }
                Repository repository = this._getRepository(companyId);
                if (repository == null) continue;
                try {
                    Folder folder = this._portletFileRepository.getPortletFolder(repository.getRepositoryId(), 0L, String.valueOf(notificationQueueEntryId));
                    this._portletFileRepository.deletePortletFolder(folder.getFolderId());
                }
                catch (PortalException portalException) {
                    if (!_log.isDebugEnabled()) continue;
                    _log.debug((Throwable)portalException);
                }
            }
            deletePreparedStatement1.executeBatch();
            deletePreparedStatement2.executeBatch();
            return;
        }
    }

    private void _deleteNotificationRecipient(long notificationRecipientId) throws Exception {
        this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from NotificationRecipient where ", "notificationRecipientId = ", notificationRecipientId}));
        this.runSQL(StringBundler.concat((Object[])new Object[]{"delete from NotificationRecipientSetting where ", "notificationRecipientId = ", notificationRecipientId}));
    }

    private void _deleteNotificationTemplates() throws Exception {
        try (PreparedStatement deletePreparedStatement1 = this._getDeletePreparedStatement("notificationTemplateId", "NTemplateAttachment");
             PreparedStatement deletePreparedStatement2 = this._getDeletePreparedStatement("notificationTemplateId", "NotificationTemplate");
             PreparedStatement preparedStatement1 = this._getSelectPreparedStatement();
             PreparedStatement preparedStatement2 = this._getSelectPreparedStatement("NotificationTemplate");
             ResultSet resultSet1 = preparedStatement2.executeQuery();){
            while (resultSet1.next()) {
                long notificationTemplateId = resultSet1.getLong("notificationTemplateId");
                this._deleteResourcePermissions(resultSet1.getLong("companyId"), NotificationTemplate.class.getName(), notificationTemplateId);
                deletePreparedStatement1.setLong(1, notificationTemplateId);
                deletePreparedStatement2.setLong(1, notificationTemplateId);
                deletePreparedStatement1.addBatch();
                deletePreparedStatement2.addBatch();
                preparedStatement1.setLong(1, PortalUtil.getClassNameId((String)NotificationTemplate.class.getName()));
                preparedStatement1.setLong(2, notificationTemplateId);
                ResultSet resultSet2 = preparedStatement1.executeQuery();
                while (resultSet2.next()) {
                    this._deleteNotificationRecipient(resultSet2.getLong(1));
                }
            }
            deletePreparedStatement1.executeBatch();
            deletePreparedStatement2.executeBatch();
        }
    }

    private void _deleteResourcePermissions(long companyId, String className, long primarykey) throws Exception {
        this._resourcePermissionLocalService.deleteResourcePermissions(companyId, className, 4, String.valueOf(primarykey));
    }

    private PreparedStatement _getDeletePreparedStatement(String columnName, String tableName) throws Exception {
        return AutoBatchPreparedStatementUtil.concurrentAutoBatch((Connection)this.connection, (String)StringBundler.concat((String[])new String[]{"delete from ", tableName, " where ", columnName, " = ?"}));
    }

    private Repository _getRepository(long companyId) {
        try {
            Group group = this._groupLocalService.getCompanyGroup(companyId);
            return this._portletFileRepository.addPortletRepository(group.getGroupId(), "com_liferay_notification_web_internal_portlet_NotificationTemplatesPortlet", new ServiceContext());
        }
        catch (PortalException portalException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)portalException);
            }
            return null;
        }
    }

    private PreparedStatement _getSelectPreparedStatement() throws Exception {
        return this.connection.prepareStatement("select notificationRecipientId from NotificationRecipient where classNameId = ? and classPK = ?");
    }

    private PreparedStatement _getSelectPreparedStatement(String tableName) throws SQLException {
        return this.connection.prepareStatement(StringBundler.concat((String[])new String[]{"select * from ", tableName, " where not exists (select 1 from Company where ", "Company.companyId = ", tableName, ".companyId)"}));
    }
}

