/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.email.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.email.provider.EmailProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.UserGroupLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class UserGroupEmailProvider
implements EmailProvider {
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final UserGroupLocalService _userGroupLocalService;
    private final UserLocalService _userLocalService;

    public UserGroupEmailProvider(PermissionCheckerFactory permissionCheckerFactory, UserGroupLocalService userGroupLocalService, UserLocalService userLocalService) {
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._userGroupLocalService = userGroupLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String provide(NotificationContext notificationContext, Object value) throws PortalException {
        if (value == null) {
            return "";
        }
        HashSet emailAddresses = new HashSet();
        for (Map userGroupMap : (List)value) {
            UserGroup userGroup = this._userGroupLocalService.fetchUserGroup(notificationContext.getCompanyId(), (String)userGroupMap.get("userGroupName"));
            if (userGroup == null) continue;
            ListUtil.isNotEmptyForEach((List)this._userLocalService.getUserGroupUsers(userGroup.getUserGroupId()), user -> {
                if (!ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW").booleanValue()) {
                    return;
                }
                emailAddresses.add(user.getEmailAddress());
            });
        }
        return StringUtil.merge(emailAddresses);
    }
}

