/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.email.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.email.provider.EmailProvider;
import com.liferay.notification.internal.type.email.provider.RoleEmailProvider;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.notification.type.util.NotificationTypeUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionUtil;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;

public class TermEmailProvider
implements EmailProvider {
    private final NotificationTermEvaluatorTracker _notificationTermEvaluatorTracker;
    private final PermissionCheckerFactory _permissionCheckerFactory;
    private final RoleEmailProvider _roleEmailProvider;
    private final RoleLocalService _roleLocalService;
    private final UserLocalService _userLocalService;

    public TermEmailProvider(NotificationTermEvaluatorTracker notificationTermEvaluatorTracker, PermissionCheckerFactory permissionCheckerFactory, RoleEmailProvider roleEmailProvider, RoleLocalService roleLocalService, UserLocalService userLocalService) {
        this._notificationTermEvaluatorTracker = notificationTermEvaluatorTracker;
        this._permissionCheckerFactory = permissionCheckerFactory;
        this._roleEmailProvider = roleEmailProvider;
        this._roleLocalService = roleLocalService;
        this._userLocalService = userLocalService;
    }

    @Override
    public String provide(NotificationContext notificationContext, Object value) throws PortalException {
        if (value == null) {
            return "";
        }
        HashSet<String> emailAddresses = new HashSet<String>();
        for (String termName : StringUtil.split((String)GetterUtil.getString((Object)value))) {
            if (!NotificationTypeUtil.isTermValue((String)termName)) continue;
            for (NotificationTermEvaluator notificationTermEvaluator : this._notificationTermEvaluatorTracker.getNotificationTermEvaluators(notificationContext.getClassName())) {
                String termValue = notificationTermEvaluator.evaluate(NotificationTermEvaluator.Context.RECIPIENT, (Object)notificationContext.getTermValues(), termName);
                if (Objects.equals(termName, termValue)) continue;
                if (NotificationTypeUtil.isEmailAddress((String)termValue)) {
                    emailAddresses.add(termValue);
                    continue;
                }
                Role role = this._roleLocalService.fetchRole(GetterUtil.getLong((String)termValue));
                if (role != null) {
                    return this._roleEmailProvider.provide(notificationContext, Collections.singletonList(Collections.singletonMap("roleName", role.getName())));
                }
                User user = this._userLocalService.getUser(GetterUtil.getLong((String)termValue));
                if (!ModelResourcePermissionUtil.contains((PermissionChecker)this._permissionCheckerFactory.create(user), (long)notificationContext.getGroupId(), (String)notificationContext.getClassName(), (long)notificationContext.getClassPK(), (String)"VIEW").booleanValue()) continue;
                emailAddresses.add(user.getEmailAddress());
            }
        }
        return StringUtil.merge(emailAddresses);
    }
}

