/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.email.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.email.provider.EmailProvider;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.notification.type.util.NotificationTypeUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultEmailProvider
implements EmailProvider {
    private static final Pattern _emailAddressPattern = Pattern.compile("[\\w!#$%&'*+/=?^_`{|}~-]+(?:\\.[\\w!#$%&'*+/=?^_`{|}~-]+)*@(?:\\w(?:[\\w-]*\\w)?\\.)+(\\w(?:[\\w-]*\\w))");
    private final NotificationTermEvaluatorTracker _notificationTermEvaluatorTracker;

    public DefaultEmailProvider(NotificationTermEvaluatorTracker notificationTermEvaluatorTracker) {
        this._notificationTermEvaluatorTracker = notificationTermEvaluatorTracker;
    }

    @Override
    public String provide(NotificationContext notificationContext, Object value) throws PortalException {
        String content;
        if (value == null) {
            return "";
        }
        if (!(value instanceof Map)) {
            return NotificationTypeUtil.evaluateTerms((String)((String)value), (NotificationContext)notificationContext, (NotificationTermEvaluatorTracker)this._notificationTermEvaluatorTracker);
        }
        Map valueMap = (Map)value;
        String valueString = (String)valueMap.get(notificationContext.getUserLocale());
        if (Validator.isNull((String)valueString)) {
            valueString = (String)valueMap.get(notificationContext.getSiteDefaultLocale());
        }
        if (Validator.isNull((String)(content = NotificationTypeUtil.evaluateTerms((String)valueString, (NotificationContext)notificationContext, (NotificationTermEvaluatorTracker)this._notificationTermEvaluatorTracker)))) {
            return "";
        }
        HashSet<String> emailAddresses = new HashSet<String>();
        Matcher matcher = _emailAddressPattern.matcher(content);
        while (matcher.find()) {
            emailAddresses.add(matcher.group());
        }
        return StringUtil.merge(emailAddresses);
    }
}

