/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.exportimport.kernel.lar.ExportImportHelperUtil;
import com.liferay.exportimport.kernel.lar.ManifestSummary;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationTemplateLocalService;
import com.liferay.notification.service.persistence.NotificationTemplatePersistence;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class NotificationTemplateLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
IdentifiableOSGiService,
NotificationTemplateLocalService {
    protected NotificationTemplateLocalService notificationTemplateLocalService;
    @Reference
    protected NotificationTemplatePersistence notificationTemplatePersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(NotificationTemplateLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate addNotificationTemplate(NotificationTemplate notificationTemplate) {
        notificationTemplate.setNew(true);
        return (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationTemplate);
    }

    @Transactional(enabled=false)
    public NotificationTemplate createNotificationTemplate(long notificationTemplateId) {
        return this.notificationTemplatePersistence.create(notificationTemplateId);
    }

    @Indexable(type=IndexableType.DELETE)
    public NotificationTemplate deleteNotificationTemplate(long notificationTemplateId) throws PortalException {
        return this.notificationTemplatePersistence.remove(notificationTemplateId);
    }

    @Indexable(type=IndexableType.DELETE)
    public NotificationTemplate deleteNotificationTemplate(NotificationTemplate notificationTemplate) throws PortalException {
        return (NotificationTemplate)this.notificationTemplatePersistence.remove((BaseModel)notificationTemplate);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.notificationTemplatePersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(NotificationTemplate.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.notificationTemplatePersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.notificationTemplatePersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.notificationTemplatePersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.notificationTemplatePersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.notificationTemplatePersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public NotificationTemplate fetchNotificationTemplate(long notificationTemplateId) {
        return this.notificationTemplatePersistence.fetchByPrimaryKey(notificationTemplateId);
    }

    public NotificationTemplate fetchNotificationTemplateByUuidAndCompanyId(String uuid, long companyId) {
        return this.notificationTemplatePersistence.fetchByUuid_C_First(uuid, companyId, null);
    }

    public NotificationTemplate fetchNotificationTemplateByExternalReferenceCode(String externalReferenceCode, long companyId) {
        return this.notificationTemplatePersistence.fetchByERC_C(externalReferenceCode, companyId);
    }

    public NotificationTemplate getNotificationTemplateByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        return this.notificationTemplatePersistence.findByERC_C(externalReferenceCode, companyId);
    }

    public NotificationTemplate getNotificationTemplate(long notificationTemplateId) throws PortalException {
        return this.notificationTemplatePersistence.findByPrimaryKey(notificationTemplateId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.notificationTemplateLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(NotificationTemplate.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("notificationTemplateId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.notificationTemplateLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(NotificationTemplate.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("notificationTemplateId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.notificationTemplateLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(NotificationTemplate.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("notificationTemplateId");
    }

    public ExportActionableDynamicQuery getExportActionableDynamicQuery(final PortletDataContext portletDataContext) {
        ExportActionableDynamicQuery exportActionableDynamicQuery = new ExportActionableDynamicQuery(){

            public long performCount() throws PortalException {
                ManifestSummary manifestSummary = portletDataContext.getManifestSummary();
                StagedModelType stagedModelType = this.getStagedModelType();
                long modelAdditionCount = super.performCount();
                manifestSummary.addModelAdditionCount(stagedModelType, modelAdditionCount);
                long modelDeletionCount = ExportImportHelperUtil.getModelDeletionCount((PortletDataContext)portletDataContext, (StagedModelType)stagedModelType);
                manifestSummary.addModelDeletionCount(stagedModelType, modelDeletionCount);
                return modelAdditionCount;
            }
        };
        this.initActionableDynamicQuery((ActionableDynamicQuery)exportActionableDynamicQuery);
        exportActionableDynamicQuery.setAddCriteriaMethod(new ActionableDynamicQuery.AddCriteriaMethod(){

            public void addCriteria(DynamicQuery dynamicQuery) {
                portletDataContext.addDateRangeCriteria(dynamicQuery, "modifiedDate");
            }
        });
        exportActionableDynamicQuery.setCompanyId(portletDataContext.getCompanyId());
        exportActionableDynamicQuery.setPerformActionMethod((ActionableDynamicQuery.PerformActionMethod)new ActionableDynamicQuery.PerformActionMethod<NotificationTemplate>(){

            public void performAction(NotificationTemplate notificationTemplate) throws PortalException {
                StagedModelDataHandlerUtil.exportStagedModel((PortletDataContext)portletDataContext, (StagedModel)notificationTemplate);
            }
        });
        exportActionableDynamicQuery.setStagedModelType(new StagedModelType(PortalUtil.getClassNameId((String)NotificationTemplate.class.getName())));
        return exportActionableDynamicQuery;
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.notificationTemplatePersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement NotificationTemplateLocalServiceImpl#deleteNotificationTemplate(NotificationTemplate) to avoid orphaned data");
        }
        return this.notificationTemplateLocalService.deleteNotificationTemplate((NotificationTemplate)persistedModel);
    }

    public BasePersistence<NotificationTemplate> getBasePersistence() {
        return this.notificationTemplatePersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.notificationTemplatePersistence.findByPrimaryKey(primaryKeyObj);
    }

    public NotificationTemplate getNotificationTemplateByUuidAndCompanyId(String uuid, long companyId) throws PortalException {
        return this.notificationTemplatePersistence.findByUuid_C_First(uuid, companyId, null);
    }

    public List<NotificationTemplate> getNotificationTemplates(int start, int end) {
        return this.notificationTemplatePersistence.findAll(start, end);
    }

    public int getNotificationTemplatesCount() {
        return this.notificationTemplatePersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationTemplate updateNotificationTemplate(NotificationTemplate notificationTemplate) {
        return (NotificationTemplate)this.notificationTemplatePersistence.update((BaseModel)notificationTemplate);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{NotificationTemplateLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.notificationTemplateLocalService = (NotificationTemplateLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return NotificationTemplateLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return NotificationTemplate.class;
    }

    protected String getModelClassName() {
        return NotificationTemplate.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.notificationTemplatePersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

