/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type;

import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryOrganizationRelLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.info.field.InfoField;
import com.liferay.info.field.InfoFieldValue;
import com.liferay.info.item.InfoItemFieldValues;
import com.liferay.info.item.InfoItemServiceRegistry;
import com.liferay.info.item.provider.InfoItemFieldValuesProvider;
import com.liferay.mail.kernel.model.MailMessage;
import com.liferay.notification.constants.NotificationRecipientSettingConstants;
import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.exception.NotificationRecipientSettingValueException;
import com.liferay.notification.internal.type.email.provider.DefaultEmailProvider;
import com.liferay.notification.internal.type.email.provider.EmailProvider;
import com.liferay.notification.internal.type.email.provider.RoleEmailProvider;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationQueueEntryAttachment;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.service.NotificationQueueEntryAttachmentLocalService;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.notification.type.BaseNotificationType;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.util.NotificationTypeUtil;
import com.liferay.notification.util.NotificationRecipientSettingUtil;
import com.liferay.object.action.util.ObjectActionThreadLocal;
import com.liferay.object.service.ObjectDefinitionLocalService;
import com.liferay.object.service.ObjectFieldLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.MessageBusUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.EmailAddressValidator;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.OrganizationLocalService;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.template.StringTemplateResource;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.templateparser.TemplateNode;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.security.auth.EmailAddressValidatorFactory;
import com.liferay.portal.service.PersistedModelLocalServiceRegistryUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.template.transformer.TemplateNodeFactory;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={NotificationType.class})
public class EmailNotificationType
extends BaseNotificationType {
    private static final Log _log = LogFactoryUtil.getLog(EmailNotificationType.class);
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryOrganizationRelLocalService _accountEntryOrganizationRelLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    private final Map<String, EmailProvider> _emailProviders = new HashMap<String, EmailProvider>();
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private InfoItemServiceRegistry _infoItemServiceRegistry;
    @Reference
    private Language _language;
    @Reference
    private NotificationQueueEntryAttachmentLocalService _notificationQueueEntryAttachmentLocalService;
    @Reference
    private ObjectDefinitionLocalService _objectDefinitionLocalService;
    @Reference
    private ObjectFieldLocalService _objectFieldLocalService;
    @Reference
    private OrganizationLocalService _organizationLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TemplateNodeFactory _templateNodeFactory;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Map<String, String> evaluateNotificationRecipientSettings(long companyId, NotificationContext notificationContext, Map<String, Object> notificationRecipientSettings) throws PortalException {
        return HashMapBuilder.put((Object)"bcc", (Object)this._getValue(companyId, notificationContext, "bcc", notificationRecipientSettings)).put((Object)"bccType", (Object)"email").put((Object)"cc", (Object)this._getValue(companyId, notificationContext, "cc", notificationRecipientSettings)).put((Object)"ccType", (Object)"email").put((Object)"to", (Object)this._getValue(companyId, notificationContext, "to", notificationRecipientSettings)).put((Object)"toType", (Object)"email").build();
    }

    public Set<String> getAllowedNotificationRecipientSettingsNames() {
        Set names = SetUtil.fromArray((Object[])new String[]{"bcc", "cc", "from", "fromName", "singleRecipient", "to"});
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-11165")) {
            names.addAll(SetUtil.fromArray((Object[])new String[]{"bccType", "ccType", "toType"}));
        }
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-21580")) {
            names.add("usePreferredLocaleForGuestUsers");
        }
        return names;
    }

    public String getFromName(NotificationQueueEntry notificationQueueEntry) {
        Map notificationRecipientSettingsMap = NotificationRecipientSettingUtil.getNotificationRecipientSettingsMap((NotificationQueueEntry)notificationQueueEntry);
        return String.valueOf(notificationRecipientSettingsMap.get("fromName"));
    }

    public String getRecipientSummary(NotificationQueueEntry notificationQueueEntry) {
        Map notificationRecipientSettingsMap = NotificationRecipientSettingUtil.getNotificationRecipientSettingsMap((NotificationQueueEntry)notificationQueueEntry);
        return String.valueOf(notificationRecipientSettingsMap.get("to"));
    }

    public String getType() {
        return "email";
    }

    public String getTypeLanguageKey() {
        return "email";
    }

    public void resendNotification(NotificationQueueEntry notificationQueueEntry) throws PortalException {
        if (notificationQueueEntry.getStatus() != 2) {
            notificationQueueEntry = this.notificationQueueEntryLocalService.updateStatus(notificationQueueEntry.getNotificationQueueEntryId(), 2);
        }
        this.sendNotification(notificationQueueEntry);
    }

    public void resendNotifications(int status, String type) throws PortalException {
        for (NotificationQueueEntry notificationQueueEntry : this.notificationQueueEntryLocalService.getNotificationEntries(type, status)) {
            this.resendNotification(notificationQueueEntry);
        }
    }

    public void sendNotification(NotificationContext notificationContext) throws PortalException {
        long groupId = 0L;
        User user = this.userLocalService.getUser(notificationContext.getUserId());
        Group userGroup = user.getGroup();
        if (userGroup == null && user.isGuestUser()) {
            userGroup = this._groupLocalService.getGroup(user.getCompanyId(), "Guest");
        }
        if (userGroup != null) {
            groupId = userGroup.getGroupId();
        }
        this.siteDefaultLocale = this.portal.getSiteDefaultLocale(groupId);
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        Map notificationRecipientSettings = NotificationRecipientSettingUtil.toMap((List)notificationRecipient.getNotificationRecipientSettings());
        String useMostRelevantLocaleForGuestUsers = this._getBooleanValue("usePreferredLocaleForGuestUsers", notificationRecipientSettings);
        this.userLocale = user.getLocale();
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-21580") && user.isGuestUser() && GetterUtil.getBoolean((String)useMostRelevantLocaleForGuestUsers)) {
            this.userLocale = LocaleUtil.fromLanguageId((String)notificationContext.getPreferredLanguageId());
        }
        String body = this._formatBody(notificationTemplate.getBodyMap(), userGroup, notificationContext);
        String subject = this.formatLocalizedContent(notificationTemplate.getSubjectMap(), notificationContext);
        HashMap evaluatedNotificationRecipientSettings = HashMapBuilder.put((Object)"from", (Object)NotificationTypeUtil.evaluateTerms((String)((String)notificationRecipientSettings.get("from")), (NotificationContext)notificationContext, (NotificationTermEvaluatorTracker)this.notificationTermEvaluatorTracker)).put((Object)"fromName", (Object)this.formatLocalizedContent((Map)notificationRecipientSettings.get("fromName"), notificationContext)).put((Object)"singleRecipient", (Object)this._getBooleanValue("singleRecipient", notificationRecipientSettings)).putAll(this.evaluateNotificationRecipientSettings(notificationTemplate.getCompanyId(), notificationContext, notificationRecipientSettings)).build();
        String validEmailAddresses = this._getValidEmailAddresses(user.getCompanyId(), (String)evaluatedNotificationRecipientSettings.get("to"));
        if (Validator.isNull((String)validEmailAddresses) && Objects.equals(notificationRecipientSettings.get("toType"), "role")) {
            return;
        }
        if (!GetterUtil.getBoolean((String)((String)evaluatedNotificationRecipientSettings.get("singleRecipient")))) {
            this.prepareNotificationContext(user, body, notificationContext, HashMapBuilder.putAll((Map)evaluatedNotificationRecipientSettings).put((Object)"to", (Object)validEmailAddresses).build(), subject);
            this.sendNotification(this.notificationQueueEntryLocalService.addNotificationQueueEntry(notificationContext));
            return;
        }
        for (String emailAddress : StringUtil.split((String)validEmailAddresses)) {
            User emailAddressUser = this.userLocalService.fetchUserByEmailAddress(user.getCompanyId(), emailAddress);
            if (emailAddressUser == null) {
                emailAddressUser = this.userLocalService.getGuestUser(CompanyThreadLocal.getCompanyId().longValue());
            }
            this.prepareNotificationContext(emailAddressUser, body, notificationContext, HashMapBuilder.putAll((Map)evaluatedNotificationRecipientSettings).put((Object)"to", (Object)emailAddress).build(), subject);
            this.sendNotification(this.notificationQueueEntryLocalService.addNotificationQueueEntry(notificationContext));
        }
    }

    public void sendNotification(NotificationQueueEntry notificationQueueEntry) {
        TransactionCommitCallbackUtil.registerCallback(() -> {
            block3: {
                try {
                    Map notificationRecipientSettingsMap = NotificationRecipientSettingUtil.getNotificationRecipientSettingsMap((NotificationQueueEntry)notificationQueueEntry);
                    MailMessage mailMessage = new MailMessage(new InternetAddress(String.valueOf(notificationRecipientSettingsMap.get("from")), String.valueOf(notificationRecipientSettingsMap.get("fromName"))), notificationQueueEntry.getSubject(), notificationQueueEntry.getBody(), true);
                    this._addFileAttachments(mailMessage, notificationQueueEntry.getNotificationQueueEntryId());
                    mailMessage.setBCC(this._toInternetAddresses(String.valueOf(notificationRecipientSettingsMap.get("bcc"))));
                    mailMessage.setCC(this._toInternetAddresses(String.valueOf(notificationRecipientSettingsMap.get("cc"))));
                    mailMessage.setTo(this._toInternetAddresses(String.valueOf(notificationRecipientSettingsMap.get("to"))));
                    MessageBusUtil.sendMessage((String)"liferay/mail", (Object)mailMessage);
                    this.notificationQueueEntryLocalService.updateStatus(notificationQueueEntry.getNotificationQueueEntryId(), 1);
                }
                catch (Exception exception) {
                    if (_log.isDebugEnabled()) {
                        _log.debug((Throwable)exception);
                    }
                    if (notificationQueueEntry.getStatus() == 0) break block3;
                    this.notificationQueueEntryLocalService.updateStatus(notificationQueueEntry.getNotificationQueueEntryId(), 0);
                }
            }
            return null;
        });
    }

    public Object[] toRecipients(List<NotificationRecipientSetting> notificationRecipientSettings) {
        return new Object[]{NotificationRecipientSettingUtil.toMap(notificationRecipientSettings)};
    }

    public void validateNotificationQueueEntry(NotificationContext notificationContext) throws PortalException {
        super.validateNotificationQueueEntry(notificationContext);
        this._validateNotificationRecipientSettings(NotificationRecipientSettingUtil.toMap((List)notificationContext.getNotificationRecipientSettings()));
    }

    public void validateNotificationTemplate(NotificationContext notificationContext) throws PortalException {
        super.validateNotificationTemplate(notificationContext);
        this._validateNotificationRecipientSettings(NotificationRecipientSettingUtil.toMap((List)notificationContext.getNotificationRecipientSettings()));
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._emailProviders.put("email", new DefaultEmailProvider(this.notificationTermEvaluatorTracker));
        this._emailProviders.put("role", new RoleEmailProvider(this._accountEntryLocalService, this._accountEntryOrganizationRelLocalService, this._accountEntryUserRelLocalService, this._groupLocalService, this._objectDefinitionLocalService, this._objectFieldLocalService, this._organizationLocalService, this._roleLocalService, this._userGroupRoleLocalService, this._userLocalService));
    }

    private void _addFileAttachments(MailMessage mailMessage, long notificationQueueEntryId) {
        for (NotificationQueueEntryAttachment notificationQueueEntryAttachment : this._notificationQueueEntryAttachmentLocalService.getNotificationQueueEntryNotificationQueueEntryAttachments(notificationQueueEntryId)) {
            try {
                FileEntry fileEntry = this._portletFileRepository.getPortletFileEntry(notificationQueueEntryAttachment.getFileEntryId());
                mailMessage.addFileAttachment(FileUtil.createTempFile((InputStream)fileEntry.getContentStream()), fileEntry.getFileName());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String _formatBody(Map<Locale, String> bodyMap, Group group, NotificationContext notificationContext) throws PortalException {
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        if (Objects.equals("richText", notificationTemplate.getEditorType())) {
            return this.formatLocalizedContent(bodyMap, notificationContext);
        }
        StringWriter stringWriter = new StringWriter();
        String body = notificationTemplate.getBody(this.userLocale);
        if (Validator.isNull((String)body)) {
            body = notificationTemplate.getBody(this.siteDefaultLocale);
        }
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)new StringTemplateResource(NotificationTemplate.class.getName() + "#" + notificationTemplate.getNotificationTemplateId(), body), (!PropsValues.NOTIFICATION_EMAIL_TEMPLATE_ENABLED ? 1 : 0) != 0);
        ThemeDisplay themeDisplay = new ThemeDisplay();
        themeDisplay.setLocale(this.siteDefaultLocale);
        InfoItemFieldValuesProvider infoItemFieldValuesProvider = (InfoItemFieldValuesProvider)this._infoItemServiceRegistry.getFirstInfoItemService(InfoItemFieldValuesProvider.class, notificationContext.getClassName());
        PersistedModelLocalService persistedModelLocalService = PersistedModelLocalServiceRegistryUtil.getPersistedModelLocalService((String)notificationContext.getClassName());
        ServiceContextThreadLocal.pushServiceContext((ServiceContext)this._getServiceContext(group, notificationContext.getUserId()));
        try {
            InfoItemFieldValues infoItemFieldValues = infoItemFieldValuesProvider.getInfoItemFieldValues((Object)persistedModelLocalService.getPersistedModel((Serializable)Long.valueOf(notificationContext.getClassPK())));
            for (InfoFieldValue infoFieldValue : infoItemFieldValues.getInfoFieldValues()) {
                InfoField infoField = infoFieldValue.getInfoField();
                if (StringUtil.startsWith((String)infoField.getName(), (String)"ddmTemplate_")) continue;
                TemplateNode templateNode = this._templateNodeFactory.createTemplateNode(infoFieldValue, themeDisplay);
                template.put((Object)infoField.getName(), (Object)templateNode);
                template.put((Object)infoField.getUniqueId(), (Object)templateNode);
            }
            HttpServletRequest httpServletRequest = ObjectActionThreadLocal.getHttpServletRequest();
            if (httpServletRequest != null) {
                template.put((Object)"portalURL", (Object)this.portal.getPortalURL(httpServletRequest));
            }
        }
        finally {
            ServiceContextThreadLocal.popServiceContext();
        }
        template.processTemplate((Writer)stringWriter);
        return stringWriter.toString();
    }

    private String _getBooleanValue(String key, Map<String, Object> notificationRecipientSettings) {
        if (!notificationRecipientSettings.containsKey(key)) {
            return "true";
        }
        return String.valueOf(notificationRecipientSettings.get(key));
    }

    private ServiceContext _getServiceContext(Group group, long userId) {
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        if (serviceContext == null) {
            serviceContext = new ServiceContext();
        }
        serviceContext = (ServiceContext)serviceContext.clone();
        serviceContext.setCompanyId(group.getCompanyId());
        serviceContext.setLanguageId(this._language.getLanguageId(this.siteDefaultLocale));
        serviceContext.setScopeGroupId(group.getGroupId());
        serviceContext.setUserId(userId);
        return serviceContext;
    }

    private String _getValidEmailAddresses(long companyId, String emailAddresses) {
        StringBundler sb = new StringBundler();
        for (String emailAddress : StringUtil.split((String)emailAddresses)) {
            EmailAddressValidator emailAddressValidator = EmailAddressValidatorFactory.getInstance();
            if (!emailAddressValidator.validate(companyId, emailAddress)) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Invalid email address " + emailAddress));
                continue;
            }
            if (sb.index() > 0) {
                sb.append(",");
            }
            sb.append(emailAddress);
        }
        return sb.toString();
    }

    private String _getValue(long companyId, NotificationContext notificationContext, String notificationRecipientSettingName, Map<String, Object> notificationRecipientSettings) throws PortalException {
        EmailProvider emailProvider = this._emailProviders.get(GetterUtil.getString((Object)notificationRecipientSettings.get(NotificationRecipientSettingConstants.getRecipientTypeName((String)notificationRecipientSettingName)), (String)"email"));
        notificationContext.setCompanyId(companyId);
        notificationContext.setSiteDefaultLocale(this.siteDefaultLocale);
        notificationContext.setUserLocale(this.userLocale);
        return emailProvider.provide(notificationContext, notificationRecipientSettings.get(notificationRecipientSettingName));
    }

    private InternetAddress[] _toInternetAddresses(String string) throws Exception {
        ArrayList<InternetAddress> internetAddresses = new ArrayList<InternetAddress>();
        for (String internetAddressString : StringUtil.split((String)string)) {
            internetAddresses.add(new InternetAddress(internetAddressString));
        }
        return internetAddresses.toArray(new InternetAddress[0]);
    }

    private void _validateNotificationRecipientSettings(Map<String, Object> notificationRecipientSettingsMap) throws PortalException {
        if (Validator.isNull((Object)notificationRecipientSettingsMap.get("from"))) {
            throw new NotificationRecipientSettingValueException.FromMustNotBeNull();
        }
        if (Validator.isNull((Object)notificationRecipientSettingsMap.get("fromName"))) {
            throw new NotificationRecipientSettingValueException.FromNameMustNotBeNull();
        }
        if (Validator.isNull((Object)notificationRecipientSettingsMap.get("to"))) {
            throw new NotificationRecipientSettingValueException.ToMustNotBeNull();
        }
    }
}

