/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.scheduler;

import com.liferay.notification.internal.configuration.NotificationQueueConfiguration;
import com.liferay.notification.service.NotificationQueueEntryLocalService;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import java.util.Date;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.notification.internal.configuration.NotificationQueueConfiguration"}, service={SchedulerJobConfiguration.class})
public class CheckNotificationQueueEntrySchedulerJobConfiguration
implements SchedulerJobConfiguration {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private NotificationQueueEntryLocalService _notificationQueueEntryLocalService;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> {
            NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType("email");
            notificationType.resendNotifications(0, "email");
            notificationType.resendNotifications(2, "email");
            NotificationQueueConfiguration notificationQueueConfiguration = (NotificationQueueConfiguration)this._configurationProvider.getSystemConfiguration(NotificationQueueConfiguration.class);
            long deleteInterval = (long)notificationQueueConfiguration.deleteInterval() * 60000L;
            this._notificationQueueEntryLocalService.deleteNotificationQueueEntries(new Date(System.currentTimeMillis() - deleteInterval));
        };
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return TriggerConfiguration.createTriggerConfiguration((int)15, (TimeUnit)TimeUnit.MINUTE);
    }
}

