/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.notification.model.impl;

import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.service.NotificationRecipientSettingLocalServiceUtil;

/**
 * The extended model base implementation for the NotificationRecipientSetting service. Represents a row in the &quot;NotificationRecipientSetting&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationRecipientSettingImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationRecipientSettingImpl
 * @see NotificationRecipientSetting
 * @generated
 */
public abstract class NotificationRecipientSettingBaseImpl
	extends NotificationRecipientSettingModelImpl
	implements NotificationRecipientSetting {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification recipient setting model instance should use the <code>NotificationRecipientSetting</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			NotificationRecipientSettingLocalServiceUtil.
				addNotificationRecipientSetting(this);
		}
		else {
			NotificationRecipientSettingLocalServiceUtil.
				updateNotificationRecipientSetting(this);
		}
	}

}