/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.service.impl;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.exception.NotificationQueueEntryStatusException;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.service.NotificationQueueEntryAttachmentLocalService;
import com.liferay.notification.service.NotificationRecipientLocalService;
import com.liferay.notification.service.NotificationRecipientSettingLocalService;
import com.liferay.notification.service.base.NotificationQueueEntryLocalServiceBaseImpl;
import com.liferay.notification.type.NotificationType;
import com.liferay.notification.type.NotificationTypeServiceTracker;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.notification.model.NotificationQueueEntry"}, service={AopService.class})
public class NotificationQueueEntryLocalServiceImpl
extends NotificationQueueEntryLocalServiceBaseImpl {
    @Reference
    private NotificationQueueEntryAttachmentLocalService _notificationQueueEntryAttachmentLocalService;
    @Reference
    private NotificationRecipientLocalService _notificationRecipientLocalService;
    @Reference
    private NotificationRecipientSettingLocalService _notificationRecipientSettingLocalService;
    @Reference
    private NotificationTypeServiceTracker _notificationTypeServiceTracker;
    @Reference
    private Portal _portal;
    @Reference
    private ResourceLocalService _resourceLocalService;

    public NotificationQueueEntry addNotificationQueueEntry(NotificationContext notificationContext) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = notificationContext.getNotificationQueueEntry();
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(notificationQueueEntry.getType());
        notificationType.validateNotificationQueueEntry(notificationContext);
        notificationQueueEntry.setNotificationQueueEntryId(this.counterLocalService.increment());
        notificationQueueEntry = (NotificationQueueEntry)this.notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
        this._resourceLocalService.addResources(notificationQueueEntry.getCompanyId(), 0L, notificationQueueEntry.getUserId(), NotificationQueueEntry.class.getName(), notificationQueueEntry.getNotificationQueueEntryId(), false, true, true);
        Iterator iterator = notificationContext.getFileEntryIds().iterator();
        while (iterator.hasNext()) {
            long fileEntryId = (Long)iterator.next();
            this._notificationQueueEntryAttachmentLocalService.addNotificationQueueEntryAttachment(notificationQueueEntry.getCompanyId(), fileEntryId, notificationQueueEntry.getNotificationQueueEntryId());
        }
        NotificationRecipient notificationRecipient = notificationContext.getNotificationRecipient();
        notificationRecipient.setNotificationRecipientId(this.counterLocalService.increment());
        notificationRecipient.setClassNameId(this._portal.getClassNameId(NotificationQueueEntry.class));
        notificationRecipient.setClassPK(notificationQueueEntry.getNotificationQueueEntryId());
        notificationRecipient = this._notificationRecipientLocalService.updateNotificationRecipient(notificationRecipient);
        for (NotificationRecipientSetting notificationRecipientSetting : notificationContext.getNotificationRecipientSettings()) {
            notificationRecipientSetting.setNotificationRecipientSettingId(this.counterLocalService.increment());
            notificationRecipientSetting.setNotificationRecipientId(notificationRecipient.getNotificationRecipientId());
            this._notificationRecipientSettingLocalService.updateNotificationRecipientSetting(notificationRecipientSetting);
        }
        return notificationQueueEntry;
    }

    public void deleteNotificationQueueEntries(Date sentDate) throws PortalException {
        for (NotificationQueueEntry notificationQueueEntry : this.notificationQueueEntryPersistence.findByLtSentDate(sentDate)) {
            this.notificationQueueEntryLocalService.deleteNotificationQueueEntry(notificationQueueEntry);
        }
    }

    @Override
    public NotificationQueueEntry deleteNotificationQueueEntry(long notificationQueueEntryId) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = this.notificationQueueEntryPersistence.findByPrimaryKey(notificationQueueEntryId);
        return this.notificationQueueEntryLocalService.deleteNotificationQueueEntry(notificationQueueEntry);
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    @SystemEvent(type=1)
    public NotificationQueueEntry deleteNotificationQueueEntry(NotificationQueueEntry notificationQueueEntry) throws PortalException {
        notificationQueueEntry = (NotificationQueueEntry)this.notificationQueueEntryPersistence.remove((BaseModel)notificationQueueEntry);
        this._resourceLocalService.deleteResource((AuditedModel)notificationQueueEntry, 4);
        this._notificationQueueEntryAttachmentLocalService.deleteNotificationQueueEntryAttachments(notificationQueueEntry.getNotificationQueueEntryId());
        NotificationRecipient notificationRecipient = notificationQueueEntry.getNotificationRecipient();
        this._notificationRecipientLocalService.deleteNotificationRecipient(notificationRecipient);
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            this._notificationRecipientSettingLocalService.deleteNotificationRecipientSetting(notificationRecipientSetting);
        }
        return notificationQueueEntry;
    }

    public List<NotificationQueueEntry> getNotificationEntries(String type, int status) {
        return this.notificationQueueEntryPersistence.findByT_S(type, status);
    }

    public NotificationQueueEntry resendNotificationQueueEntry(long notificationQueueEntryId) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = this.getNotificationQueueEntry(notificationQueueEntryId);
        if (notificationQueueEntry.getStatus() == 1) {
            throw new NotificationQueueEntryStatusException("Notification queue entry " + notificationQueueEntry.getNotificationQueueEntryId() + " was already sent");
        }
        NotificationType notificationType = this._notificationTypeServiceTracker.getNotificationType(notificationQueueEntry.getType());
        notificationType.resendNotification(notificationQueueEntry);
        return this.getNotificationQueueEntry(notificationQueueEntryId);
    }

    @Override
    @Indexable(type=IndexableType.REINDEX)
    public NotificationQueueEntry updateNotificationQueueEntry(NotificationQueueEntry notificationQueueEntry) {
        return (NotificationQueueEntry)this.notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public NotificationQueueEntry updateStatus(long notificationQueueEntryId, int status) throws PortalException {
        NotificationQueueEntry notificationQueueEntry = this.notificationQueueEntryPersistence.findByPrimaryKey(notificationQueueEntryId);
        if (status == 1) {
            notificationQueueEntry.setSentDate(new Date());
        } else {
            notificationQueueEntry.setSentDate(null);
        }
        notificationQueueEntry.setStatus(status);
        return (NotificationQueueEntry)this.notificationQueueEntryPersistence.update((BaseModel)notificationQueueEntry);
    }
}

