/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.notification.internal.type.users.provider;

import com.liferay.notification.context.NotificationContext;
import com.liferay.notification.internal.type.users.provider.BaseUsersProvider;
import com.liferay.notification.internal.type.users.provider.UsersProvider;
import com.liferay.notification.model.NotificationRecipient;
import com.liferay.notification.model.NotificationRecipientSetting;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.term.evaluator.NotificationTermEvaluator;
import com.liferay.notification.term.evaluator.NotificationTermEvaluatorTracker;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"recipient.type=term"}, service={UsersProvider.class})
public class TermUsersProvider
extends BaseUsersProvider
implements UsersProvider {
    private static final Pattern _pattern = Pattern.compile("\\[%[^\\[%]+%\\]", 2);
    @Reference
    private NotificationTermEvaluatorTracker _notificationTermEvaluatorTracker;
    @Reference
    private UserLocalService _userLocalService;

    @Override
    public String getRecipientType() {
        return "term";
    }

    @Override
    public List<User> provide(NotificationContext notificationContext) throws PortalException {
        ArrayList<User> users = new ArrayList<User>();
        ArrayList<String> screenNames = new ArrayList<String>();
        ArrayList<String> terms = new ArrayList<String>();
        NotificationTemplate notificationTemplate = notificationContext.getNotificationTemplate();
        NotificationRecipient notificationRecipient = notificationTemplate.getNotificationRecipient();
        for (NotificationRecipientSetting notificationRecipientSetting : notificationRecipient.getNotificationRecipientSettings()) {
            Matcher matcher = _pattern.matcher(notificationRecipientSetting.getValue());
            if (matcher.find()) {
                terms.add(notificationRecipientSetting.getValue());
                continue;
            }
            screenNames.add(notificationRecipientSetting.getValue());
        }
        users.addAll(TransformUtil.unsafeTransform(screenNames, screenName -> {
            User user = this._userLocalService.getUserByScreenName(notificationRecipient.getCompanyId(), screenName);
            if (!this.hasViewPermission(notificationContext.getClassName(), notificationContext.getClassPK(), user)) {
                return null;
            }
            return user;
        }));
        for (NotificationTermEvaluator notificationTermEvaluator : this._notificationTermEvaluatorTracker.getNotificationTermEvaluators(notificationContext.getClassName())) {
            users.addAll(TransformUtil.unsafeTransform(terms, term -> {
                User user = this._userLocalService.getUser(GetterUtil.getLong((String)notificationTermEvaluator.evaluate(NotificationTermEvaluator.Context.RECIPIENT, (Object)notificationContext.getTermValues(), term)));
                if (!this.hasViewPermission(notificationContext.getClassName(), notificationContext.getClassPK(), user)) {
                    return null;
                }
                return user;
            }));
        }
        return users;
    }
}

