/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.service.impl;

import com.liferay.notification.model.NotificationTemplateAttachment;
import com.liferay.notification.service.base.NotificationTemplateAttachmentLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;

import java.util.List;

import org.osgi.service.component.annotations.Component;

/**
 * @author Carolina Barbosa
 */
@Component(
	property = "model.class.name=com.liferay.notification.model.NotificationTemplateAttachment",
	service = AopService.class
)
public class NotificationTemplateAttachmentLocalServiceImpl
	extends NotificationTemplateAttachmentLocalServiceBaseImpl {

	@Override
	public NotificationTemplateAttachment addNotificationTemplateAttachment(
			long companyId, long notificationTemplateId, long objectFieldId)
		throws PortalException {

		NotificationTemplateAttachment notificationTemplateAttachment =
			notificationTemplateAttachmentPersistence.create(
				counterLocalService.increment());

		notificationTemplateAttachment.setCompanyId(companyId);
		notificationTemplateAttachment.setNotificationTemplateId(
			notificationTemplateId);
		notificationTemplateAttachment.setObjectFieldId(objectFieldId);

		return notificationTemplateAttachmentPersistence.update(
			notificationTemplateAttachment);
	}

	@Override
	public List<NotificationTemplateAttachment>
		getNotificationTemplateAttachments(long notificationTemplateId) {

		return notificationTemplateAttachmentPersistence.
			findByNotificationTemplateId(notificationTemplateId);
	}

}