/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.service.impl;

import com.liferay.notification.model.NotificationQueueEntryAttachment;
import com.liferay.notification.service.base.NotificationQueueEntryAttachmentLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Carolina Barbosa
 */
@Component(
	property = "model.class.name=com.liferay.notification.model.NotificationQueueEntryAttachment",
	service = AopService.class
)
public class NotificationQueueEntryAttachmentLocalServiceImpl
	extends NotificationQueueEntryAttachmentLocalServiceBaseImpl {

	@Override
	public NotificationQueueEntryAttachment addNotificationQueueEntryAttachment(
			long companyId, long fileEntryId, long notificationQueueEntryId)
		throws PortalException {

		NotificationQueueEntryAttachment notificationQueueEntryAttachment =
			notificationQueueEntryAttachmentPersistence.create(
				counterLocalService.increment());

		notificationQueueEntryAttachment.setCompanyId(companyId);
		notificationQueueEntryAttachment.setFileEntryId(fileEntryId);
		notificationQueueEntryAttachment.setNotificationQueueEntryId(
			notificationQueueEntryId);

		return notificationQueueEntryAttachmentPersistence.update(
			notificationQueueEntryAttachment);
	}

	@Override
	public void deleteNotificationQueueEntryAttachments(
			long notificationQueueEntryId)
		throws PortalException {

		for (NotificationQueueEntryAttachment notificationQueueEntryAttachment :
				notificationQueueEntryAttachmentPersistence.
					findByNotificationQueueEntryId(notificationQueueEntryId)) {

			notificationQueueEntryAttachmentPersistence.remove(
				notificationQueueEntryAttachment.
					getNotificationQueueEntryAttachmentId());

			_portletFileRepository.deletePortletFileEntry(
				notificationQueueEntryAttachment.getFileEntryId());
		}
	}

	@Reference
	private PortletFileRepository _portletFileRepository;

}