/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.notification.model.NotificationTemplate;
import com.liferay.notification.model.NotificationTemplateModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the NotificationTemplate service. Represents a row in the &quot;NotificationTemplate&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>NotificationTemplateModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationTemplateImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationTemplateImpl
 * @generated
 */
@JSON(strict = true)
public class NotificationTemplateModelImpl
	extends BaseModelImpl<NotificationTemplate>
	implements NotificationTemplateModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification template model instance should use the <code>NotificationTemplate</code> interface instead.
	 */
	public static final String TABLE_NAME = "NotificationTemplate";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"notificationTemplateId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"objectDefinitionId", Types.BIGINT}, {"bcc", Types.VARCHAR},
		{"body", Types.CLOB}, {"cc", Types.VARCHAR},
		{"description", Types.VARCHAR}, {"from_", Types.VARCHAR},
		{"fromName", Types.VARCHAR}, {"name", Types.VARCHAR},
		{"subject", Types.VARCHAR}, {"to_", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("notificationTemplateId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("objectDefinitionId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("bcc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("body", Types.CLOB);
		TABLE_COLUMNS_MAP.put("cc", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("description", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("from_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("fromName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("subject", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("to_", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table NotificationTemplate (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,notificationTemplateId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,objectDefinitionId LONG,bcc VARCHAR(75) null,body TEXT null,cc VARCHAR(75) null,description VARCHAR(75) null,from_ VARCHAR(75) null,fromName STRING null,name STRING null,subject STRING null,to_ STRING null)";

	public static final String TABLE_SQL_DROP =
		"drop table NotificationTemplate";

	public static final String ORDER_BY_JPQL =
		" ORDER BY notificationTemplate.notificationTemplateId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY NotificationTemplate.notificationTemplateId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long NOTIFICATIONTEMPLATEID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public NotificationTemplateModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _notificationTemplateId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setNotificationTemplateId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _notificationTemplateId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return NotificationTemplate.class;
	}

	@Override
	public String getModelClassName() {
		return NotificationTemplate.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<NotificationTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<NotificationTemplate, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<NotificationTemplate, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((NotificationTemplate)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<NotificationTemplate, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<NotificationTemplate, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(NotificationTemplate)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<NotificationTemplate, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<NotificationTemplate, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<NotificationTemplate, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<NotificationTemplate, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<NotificationTemplate, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<NotificationTemplate, Object>>();
		Map<String, BiConsumer<NotificationTemplate, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<NotificationTemplate, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", NotificationTemplate::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<NotificationTemplate, Long>)
				NotificationTemplate::setMvccVersion);
		attributeGetterFunctions.put("uuid", NotificationTemplate::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setUuid);
		attributeGetterFunctions.put(
			"notificationTemplateId",
			NotificationTemplate::getNotificationTemplateId);
		attributeSetterBiConsumers.put(
			"notificationTemplateId",
			(BiConsumer<NotificationTemplate, Long>)
				NotificationTemplate::setNotificationTemplateId);
		attributeGetterFunctions.put(
			"companyId", NotificationTemplate::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<NotificationTemplate, Long>)
				NotificationTemplate::setCompanyId);
		attributeGetterFunctions.put("userId", NotificationTemplate::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<NotificationTemplate, Long>)
				NotificationTemplate::setUserId);
		attributeGetterFunctions.put(
			"userName", NotificationTemplate::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setUserName);
		attributeGetterFunctions.put(
			"createDate", NotificationTemplate::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<NotificationTemplate, Date>)
				NotificationTemplate::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", NotificationTemplate::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<NotificationTemplate, Date>)
				NotificationTemplate::setModifiedDate);
		attributeGetterFunctions.put(
			"objectDefinitionId", NotificationTemplate::getObjectDefinitionId);
		attributeSetterBiConsumers.put(
			"objectDefinitionId",
			(BiConsumer<NotificationTemplate, Long>)
				NotificationTemplate::setObjectDefinitionId);
		attributeGetterFunctions.put("bcc", NotificationTemplate::getBcc);
		attributeSetterBiConsumers.put(
			"bcc",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setBcc);
		attributeGetterFunctions.put("body", NotificationTemplate::getBody);
		attributeSetterBiConsumers.put(
			"body",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setBody);
		attributeGetterFunctions.put("cc", NotificationTemplate::getCc);
		attributeSetterBiConsumers.put(
			"cc",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setCc);
		attributeGetterFunctions.put(
			"description", NotificationTemplate::getDescription);
		attributeSetterBiConsumers.put(
			"description",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setDescription);
		attributeGetterFunctions.put("from", NotificationTemplate::getFrom);
		attributeSetterBiConsumers.put(
			"from",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setFrom);
		attributeGetterFunctions.put(
			"fromName", NotificationTemplate::getFromName);
		attributeSetterBiConsumers.put(
			"fromName",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setFromName);
		attributeGetterFunctions.put("name", NotificationTemplate::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setName);
		attributeGetterFunctions.put(
			"subject", NotificationTemplate::getSubject);
		attributeSetterBiConsumers.put(
			"subject",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setSubject);
		attributeGetterFunctions.put("to", NotificationTemplate::getTo);
		attributeSetterBiConsumers.put(
			"to",
			(BiConsumer<NotificationTemplate, String>)
				NotificationTemplate::setTo);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getNotificationTemplateId() {
		return _notificationTemplateId;
	}

	@Override
	public void setNotificationTemplateId(long notificationTemplateId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_notificationTemplateId = notificationTemplateId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public long getObjectDefinitionId() {
		return _objectDefinitionId;
	}

	@Override
	public void setObjectDefinitionId(long objectDefinitionId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_objectDefinitionId = objectDefinitionId;
	}

	@JSON
	@Override
	public String getBcc() {
		if (_bcc == null) {
			return "";
		}
		else {
			return _bcc;
		}
	}

	@Override
	public void setBcc(String bcc) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_bcc = bcc;
	}

	@JSON
	@Override
	public String getBody() {
		if (_body == null) {
			return "";
		}
		else {
			return _body;
		}
	}

	@Override
	public String getBody(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getBody(languageId);
	}

	@Override
	public String getBody(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getBody(languageId, useDefault);
	}

	@Override
	public String getBody(String languageId) {
		return LocalizationUtil.getLocalization(getBody(), languageId);
	}

	@Override
	public String getBody(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getBody(), languageId, useDefault);
	}

	@Override
	public String getBodyCurrentLanguageId() {
		return _bodyCurrentLanguageId;
	}

	@JSON
	@Override
	public String getBodyCurrentValue() {
		Locale locale = getLocale(_bodyCurrentLanguageId);

		return getBody(locale);
	}

	@Override
	public Map<Locale, String> getBodyMap() {
		return LocalizationUtil.getLocalizationMap(getBody());
	}

	@Override
	public void setBody(String body) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_body = body;
	}

	@Override
	public void setBody(String body, Locale locale) {
		setBody(body, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setBody(String body, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(body)) {
			setBody(
				LocalizationUtil.updateLocalization(
					getBody(), "Body", body, languageId, defaultLanguageId));
		}
		else {
			setBody(
				LocalizationUtil.removeLocalization(
					getBody(), "Body", languageId));
		}
	}

	@Override
	public void setBodyCurrentLanguageId(String languageId) {
		_bodyCurrentLanguageId = languageId;
	}

	@Override
	public void setBodyMap(Map<Locale, String> bodyMap) {
		setBodyMap(bodyMap, LocaleUtil.getDefault());
	}

	@Override
	public void setBodyMap(Map<Locale, String> bodyMap, Locale defaultLocale) {
		if (bodyMap == null) {
			return;
		}

		setBody(
			LocalizationUtil.updateLocalization(
				bodyMap, getBody(), "Body",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getCc() {
		if (_cc == null) {
			return "";
		}
		else {
			return _cc;
		}
	}

	@Override
	public void setCc(String cc) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_cc = cc;
	}

	@JSON
	@Override
	public String getDescription() {
		if (_description == null) {
			return "";
		}
		else {
			return _description;
		}
	}

	@Override
	public void setDescription(String description) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_description = description;
	}

	@JSON
	@Override
	public String getFrom() {
		if (_from == null) {
			return "";
		}
		else {
			return _from;
		}
	}

	@Override
	public void setFrom(String from) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_from = from;
	}

	@JSON
	@Override
	public String getFromName() {
		if (_fromName == null) {
			return "";
		}
		else {
			return _fromName;
		}
	}

	@Override
	public String getFromName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFromName(languageId);
	}

	@Override
	public String getFromName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getFromName(languageId, useDefault);
	}

	@Override
	public String getFromName(String languageId) {
		return LocalizationUtil.getLocalization(getFromName(), languageId);
	}

	@Override
	public String getFromName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getFromName(), languageId, useDefault);
	}

	@Override
	public String getFromNameCurrentLanguageId() {
		return _fromNameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getFromNameCurrentValue() {
		Locale locale = getLocale(_fromNameCurrentLanguageId);

		return getFromName(locale);
	}

	@Override
	public Map<Locale, String> getFromNameMap() {
		return LocalizationUtil.getLocalizationMap(getFromName());
	}

	@Override
	public void setFromName(String fromName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_fromName = fromName;
	}

	@Override
	public void setFromName(String fromName, Locale locale) {
		setFromName(fromName, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setFromName(
		String fromName, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(fromName)) {
			setFromName(
				LocalizationUtil.updateLocalization(
					getFromName(), "FromName", fromName, languageId,
					defaultLanguageId));
		}
		else {
			setFromName(
				LocalizationUtil.removeLocalization(
					getFromName(), "FromName", languageId));
		}
	}

	@Override
	public void setFromNameCurrentLanguageId(String languageId) {
		_fromNameCurrentLanguageId = languageId;
	}

	@Override
	public void setFromNameMap(Map<Locale, String> fromNameMap) {
		setFromNameMap(fromNameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setFromNameMap(
		Map<Locale, String> fromNameMap, Locale defaultLocale) {

		if (fromNameMap == null) {
			return;
		}

		setFromName(
			LocalizationUtil.updateLocalization(
				fromNameMap, getFromName(), "FromName",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getSubject() {
		if (_subject == null) {
			return "";
		}
		else {
			return _subject;
		}
	}

	@Override
	public String getSubject(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSubject(languageId);
	}

	@Override
	public String getSubject(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getSubject(languageId, useDefault);
	}

	@Override
	public String getSubject(String languageId) {
		return LocalizationUtil.getLocalization(getSubject(), languageId);
	}

	@Override
	public String getSubject(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getSubject(), languageId, useDefault);
	}

	@Override
	public String getSubjectCurrentLanguageId() {
		return _subjectCurrentLanguageId;
	}

	@JSON
	@Override
	public String getSubjectCurrentValue() {
		Locale locale = getLocale(_subjectCurrentLanguageId);

		return getSubject(locale);
	}

	@Override
	public Map<Locale, String> getSubjectMap() {
		return LocalizationUtil.getLocalizationMap(getSubject());
	}

	@Override
	public void setSubject(String subject) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_subject = subject;
	}

	@Override
	public void setSubject(String subject, Locale locale) {
		setSubject(subject, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setSubject(
		String subject, Locale locale, Locale defaultLocale) {

		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(subject)) {
			setSubject(
				LocalizationUtil.updateLocalization(
					getSubject(), "Subject", subject, languageId,
					defaultLanguageId));
		}
		else {
			setSubject(
				LocalizationUtil.removeLocalization(
					getSubject(), "Subject", languageId));
		}
	}

	@Override
	public void setSubjectCurrentLanguageId(String languageId) {
		_subjectCurrentLanguageId = languageId;
	}

	@Override
	public void setSubjectMap(Map<Locale, String> subjectMap) {
		setSubjectMap(subjectMap, LocaleUtil.getDefault());
	}

	@Override
	public void setSubjectMap(
		Map<Locale, String> subjectMap, Locale defaultLocale) {

		if (subjectMap == null) {
			return;
		}

		setSubject(
			LocalizationUtil.updateLocalization(
				subjectMap, getSubject(), "Subject",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getTo() {
		if (_to == null) {
			return "";
		}
		else {
			return _to;
		}
	}

	@Override
	public String getTo(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTo(languageId);
	}

	@Override
	public String getTo(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getTo(languageId, useDefault);
	}

	@Override
	public String getTo(String languageId) {
		return LocalizationUtil.getLocalization(getTo(), languageId);
	}

	@Override
	public String getTo(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getTo(), languageId, useDefault);
	}

	@Override
	public String getToCurrentLanguageId() {
		return _toCurrentLanguageId;
	}

	@JSON
	@Override
	public String getToCurrentValue() {
		Locale locale = getLocale(_toCurrentLanguageId);

		return getTo(locale);
	}

	@Override
	public Map<Locale, String> getToMap() {
		return LocalizationUtil.getLocalizationMap(getTo());
	}

	@Override
	public void setTo(String to) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_to = to;
	}

	@Override
	public void setTo(String to, Locale locale) {
		setTo(to, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setTo(String to, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(to)) {
			setTo(
				LocalizationUtil.updateLocalization(
					getTo(), "To", to, languageId, defaultLanguageId));
		}
		else {
			setTo(
				LocalizationUtil.removeLocalization(getTo(), "To", languageId));
		}
	}

	@Override
	public void setToCurrentLanguageId(String languageId) {
		_toCurrentLanguageId = languageId;
	}

	@Override
	public void setToMap(Map<Locale, String> toMap) {
		setToMap(toMap, LocaleUtil.getDefault());
	}

	@Override
	public void setToMap(Map<Locale, String> toMap, Locale defaultLocale) {
		if (toMap == null) {
			return;
		}

		setTo(
			LocalizationUtil.updateLocalization(
				toMap, getTo(), "To", LocaleUtil.toLanguageId(defaultLocale)));
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(NotificationTemplate.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), NotificationTemplate.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> bodyMap = getBodyMap();

		for (Map.Entry<Locale, String> entry : bodyMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> fromNameMap = getFromNameMap();

		for (Map.Entry<Locale, String> entry : fromNameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> subjectMap = getSubjectMap();

		for (Map.Entry<Locale, String> entry : subjectMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		Map<Locale, String> toMap = getToMap();

		for (Map.Entry<Locale, String> entry : toMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getBody();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			NotificationTemplate.class.getName(), getPrimaryKey(),
			defaultLocale, availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String body = getBody(defaultLocale);

		if (Validator.isNull(body)) {
			setBody(getBody(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setBody(getBody(defaultLocale), defaultLocale, defaultLocale);
		}

		String fromName = getFromName(defaultLocale);

		if (Validator.isNull(fromName)) {
			setFromName(getFromName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setFromName(
				getFromName(defaultLocale), defaultLocale, defaultLocale);
		}

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}

		String subject = getSubject(defaultLocale);

		if (Validator.isNull(subject)) {
			setSubject(getSubject(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setSubject(getSubject(defaultLocale), defaultLocale, defaultLocale);
		}

		String to = getTo(defaultLocale);

		if (Validator.isNull(to)) {
			setTo(getTo(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setTo(getTo(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public NotificationTemplate toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, NotificationTemplate>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		NotificationTemplateImpl notificationTemplateImpl =
			new NotificationTemplateImpl();

		notificationTemplateImpl.setMvccVersion(getMvccVersion());
		notificationTemplateImpl.setUuid(getUuid());
		notificationTemplateImpl.setNotificationTemplateId(
			getNotificationTemplateId());
		notificationTemplateImpl.setCompanyId(getCompanyId());
		notificationTemplateImpl.setUserId(getUserId());
		notificationTemplateImpl.setUserName(getUserName());
		notificationTemplateImpl.setCreateDate(getCreateDate());
		notificationTemplateImpl.setModifiedDate(getModifiedDate());
		notificationTemplateImpl.setObjectDefinitionId(getObjectDefinitionId());
		notificationTemplateImpl.setBcc(getBcc());
		notificationTemplateImpl.setBody(getBody());
		notificationTemplateImpl.setCc(getCc());
		notificationTemplateImpl.setDescription(getDescription());
		notificationTemplateImpl.setFrom(getFrom());
		notificationTemplateImpl.setFromName(getFromName());
		notificationTemplateImpl.setName(getName());
		notificationTemplateImpl.setSubject(getSubject());
		notificationTemplateImpl.setTo(getTo());

		notificationTemplateImpl.resetOriginalValues();

		return notificationTemplateImpl;
	}

	@Override
	public NotificationTemplate cloneWithOriginalValues() {
		NotificationTemplateImpl notificationTemplateImpl =
			new NotificationTemplateImpl();

		notificationTemplateImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		notificationTemplateImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		notificationTemplateImpl.setNotificationTemplateId(
			this.<Long>getColumnOriginalValue("notificationTemplateId"));
		notificationTemplateImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		notificationTemplateImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		notificationTemplateImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		notificationTemplateImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		notificationTemplateImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		notificationTemplateImpl.setObjectDefinitionId(
			this.<Long>getColumnOriginalValue("objectDefinitionId"));
		notificationTemplateImpl.setBcc(
			this.<String>getColumnOriginalValue("bcc"));
		notificationTemplateImpl.setBody(
			this.<String>getColumnOriginalValue("body"));
		notificationTemplateImpl.setCc(
			this.<String>getColumnOriginalValue("cc"));
		notificationTemplateImpl.setDescription(
			this.<String>getColumnOriginalValue("description"));
		notificationTemplateImpl.setFrom(
			this.<String>getColumnOriginalValue("from_"));
		notificationTemplateImpl.setFromName(
			this.<String>getColumnOriginalValue("fromName"));
		notificationTemplateImpl.setName(
			this.<String>getColumnOriginalValue("name"));
		notificationTemplateImpl.setSubject(
			this.<String>getColumnOriginalValue("subject"));
		notificationTemplateImpl.setTo(
			this.<String>getColumnOriginalValue("to_"));

		return notificationTemplateImpl;
	}

	@Override
	public int compareTo(NotificationTemplate notificationTemplate) {
		long primaryKey = notificationTemplate.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof NotificationTemplate)) {
			return false;
		}

		NotificationTemplate notificationTemplate =
			(NotificationTemplate)object;

		long primaryKey = notificationTemplate.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<NotificationTemplate> toCacheModel() {
		NotificationTemplateCacheModel notificationTemplateCacheModel =
			new NotificationTemplateCacheModel();

		notificationTemplateCacheModel.mvccVersion = getMvccVersion();

		notificationTemplateCacheModel.uuid = getUuid();

		String uuid = notificationTemplateCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			notificationTemplateCacheModel.uuid = null;
		}

		notificationTemplateCacheModel.notificationTemplateId =
			getNotificationTemplateId();

		notificationTemplateCacheModel.companyId = getCompanyId();

		notificationTemplateCacheModel.userId = getUserId();

		notificationTemplateCacheModel.userName = getUserName();

		String userName = notificationTemplateCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			notificationTemplateCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			notificationTemplateCacheModel.createDate = createDate.getTime();
		}
		else {
			notificationTemplateCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			notificationTemplateCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			notificationTemplateCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		notificationTemplateCacheModel.objectDefinitionId =
			getObjectDefinitionId();

		notificationTemplateCacheModel.bcc = getBcc();

		String bcc = notificationTemplateCacheModel.bcc;

		if ((bcc != null) && (bcc.length() == 0)) {
			notificationTemplateCacheModel.bcc = null;
		}

		notificationTemplateCacheModel.body = getBody();

		String body = notificationTemplateCacheModel.body;

		if ((body != null) && (body.length() == 0)) {
			notificationTemplateCacheModel.body = null;
		}

		notificationTemplateCacheModel.cc = getCc();

		String cc = notificationTemplateCacheModel.cc;

		if ((cc != null) && (cc.length() == 0)) {
			notificationTemplateCacheModel.cc = null;
		}

		notificationTemplateCacheModel.description = getDescription();

		String description = notificationTemplateCacheModel.description;

		if ((description != null) && (description.length() == 0)) {
			notificationTemplateCacheModel.description = null;
		}

		notificationTemplateCacheModel.from = getFrom();

		String from = notificationTemplateCacheModel.from;

		if ((from != null) && (from.length() == 0)) {
			notificationTemplateCacheModel.from = null;
		}

		notificationTemplateCacheModel.fromName = getFromName();

		String fromName = notificationTemplateCacheModel.fromName;

		if ((fromName != null) && (fromName.length() == 0)) {
			notificationTemplateCacheModel.fromName = null;
		}

		notificationTemplateCacheModel.name = getName();

		String name = notificationTemplateCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			notificationTemplateCacheModel.name = null;
		}

		notificationTemplateCacheModel.subject = getSubject();

		String subject = notificationTemplateCacheModel.subject;

		if ((subject != null) && (subject.length() == 0)) {
			notificationTemplateCacheModel.subject = null;
		}

		notificationTemplateCacheModel.to = getTo();

		String to = notificationTemplateCacheModel.to;

		if ((to != null) && (to.length() == 0)) {
			notificationTemplateCacheModel.to = null;
		}

		return notificationTemplateCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<NotificationTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<NotificationTemplate, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<NotificationTemplate, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(NotificationTemplate)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<NotificationTemplate, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<NotificationTemplate, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<NotificationTemplate, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((NotificationTemplate)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, NotificationTemplate>
			_escapedModelProxyProviderFunction =
				ProxyUtil.getProxyProviderFunction(
					NotificationTemplate.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private String _uuid;
	private long _notificationTemplateId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private long _objectDefinitionId;
	private String _bcc;
	private String _body;
	private String _bodyCurrentLanguageId;
	private String _cc;
	private String _description;
	private String _from;
	private String _fromName;
	private String _fromNameCurrentLanguageId;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _subject;
	private String _subjectCurrentLanguageId;
	private String _to;
	private String _toCurrentLanguageId;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<NotificationTemplate, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((NotificationTemplate)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put(
			"notificationTemplateId", _notificationTemplateId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("objectDefinitionId", _objectDefinitionId);
		_columnOriginalValues.put("bcc", _bcc);
		_columnOriginalValues.put("body", _body);
		_columnOriginalValues.put("cc", _cc);
		_columnOriginalValues.put("description", _description);
		_columnOriginalValues.put("from_", _from);
		_columnOriginalValues.put("fromName", _fromName);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("subject", _subject);
		_columnOriginalValues.put("to_", _to);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("from_", "from");
		attributeNames.put("to_", "to");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("notificationTemplateId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("objectDefinitionId", 256L);

		columnBitmasks.put("bcc", 512L);

		columnBitmasks.put("body", 1024L);

		columnBitmasks.put("cc", 2048L);

		columnBitmasks.put("description", 4096L);

		columnBitmasks.put("from_", 8192L);

		columnBitmasks.put("fromName", 16384L);

		columnBitmasks.put("name", 32768L);

		columnBitmasks.put("subject", 65536L);

		columnBitmasks.put("to_", 131072L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private NotificationTemplate _escapedModel;

}