/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.model.impl;

import com.liferay.notification.model.NotificationTemplateAttachment;
import com.liferay.notification.service.NotificationTemplateAttachmentLocalServiceUtil;

/**
 * The extended model base implementation for the NotificationTemplateAttachment service. Represents a row in the &quot;NTemplateAttachment&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link NotificationTemplateAttachmentImpl}.
 * </p>
 *
 * @author Gabriel Albuquerque
 * @see NotificationTemplateAttachmentImpl
 * @see NotificationTemplateAttachment
 * @generated
 */
public abstract class NotificationTemplateAttachmentBaseImpl
	extends NotificationTemplateAttachmentModelImpl
	implements NotificationTemplateAttachment {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a notification template attachment model instance should use the <code>NotificationTemplateAttachment</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			NotificationTemplateAttachmentLocalServiceUtil.
				addNotificationTemplateAttachment(this);
		}
		else {
			NotificationTemplateAttachmentLocalServiceUtil.
				updateNotificationTemplateAttachment(this);
		}
	}

}