/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.internal.upgrade.v1_2_0;

import com.liferay.notification.constants.NotificationQueueEntryConstants;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.kernel.upgrade.UpgradeStep;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

/**
 * @author Mateus Santana
 */
public class NotificationQueueEntryUpgradeProcess extends UpgradeProcess {

	@Override
	protected void doUpgrade() throws Exception {
		try (PreparedStatement preparedStatement1 = connection.prepareStatement(
				"select notificationQueueEntryId, sent from " +
					"NotificationQueueEntry");
			ResultSet resultSet = preparedStatement1.executeQuery();
			PreparedStatement preparedStatement2 = connection.prepareStatement(
				SQLTransformer.transform(
					"update NotificationQueueEntry set status = ? where " +
						"notificationQueueEntryId = ?"))) {

			while (resultSet.next()) {
				if (resultSet.getBoolean("sent")) {
					preparedStatement2.setInt(
						1, NotificationQueueEntryConstants.STATUS_SENT);
				}
				else {
					preparedStatement2.setInt(
						1, NotificationQueueEntryConstants.STATUS_UNSENT);
				}

				preparedStatement2.setLong(
					2, resultSet.getLong("notificationQueueEntryId"));

				preparedStatement2.addBatch();
			}

			preparedStatement2.executeBatch();
		}
	}

	@Override
	protected UpgradeStep[] getPreUpgradeSteps() {
		return new UpgradeStep[] {
			UpgradeProcessFactory.addColumns(
				"NotificationQueueEntry", "status INTEGER")
		};
	}

}