/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.internal.upgrade.registry;

import com.liferay.notification.internal.upgrade.v1_1_0.util.NotificationQueueEntryAttachmentTable;
import com.liferay.notification.internal.upgrade.v1_1_0.util.NotificationTemplateAttachmentTable;
import com.liferay.notification.internal.upgrade.v1_2_0.NotificationQueueEntryUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;

/**
 * @author Carolina Barbosa
 */
@Component(immediate = true, service = UpgradeStepRegistrator.class)
public class NotificationUpgradeStepRegistrator
	implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.register(
			"1.0.0", "1.1.0", NotificationQueueEntryAttachmentTable.create(),
			NotificationTemplateAttachmentTable.create(),
			UpgradeProcessFactory.addColumns(
				"NotificationTemplate", "objectDefinitionId LONG"));

		registry.register(
			"1.1.0", "1.2.0", new NotificationQueueEntryUpgradeProcess());
	}

}