/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.internal.type;

import com.liferay.notification.type.NotificationType;
import com.liferay.notification.util.NotificationTypeRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory.ServiceWrapper;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Gustavo Lima
 */
@Component(immediate = true, service = NotificationTypeRegistry.class)
public class NotificationTypeRegistryImpl implements NotificationTypeRegistry {

	@Override
	public NotificationType getNotificationType(String key) {
		ServiceWrapper<NotificationType> notificationTypeServiceWrapper =
			_serviceTrackerMap.getService(key);

		if (notificationTypeServiceWrapper == null) {
			if (_log.isDebugEnabled()) {
				_log.debug("No notification type registered with key " + key);
			}

			return null;
		}

		return notificationTypeServiceWrapper.getService();
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap(
			bundleContext, NotificationType.class, "notification.type.key",
			ServiceTrackerCustomizerFactory.<NotificationType>serviceWrapper(
				bundleContext));
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMap.close();
	}

	private static final Log _log = LogFactoryUtil.getLog(
		NotificationTypeRegistryImpl.class);

	private ServiceTrackerMap<String, ServiceWrapper<NotificationType>>
		_serviceTrackerMap;

}