/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.internal.term;

import com.liferay.notification.term.contributor.NotificationTermContributor;
import com.liferay.notification.term.contributor.NotificationTermContributorRegistry;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerCustomizerFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

/**
 * @author Gustavo Lima
 */
@Component(
	immediate = true, service = NotificationTermContributorRegistry.class
)
public class NotificationTermContributorRegistryImpl
	implements NotificationTermContributorRegistry {

	@Override
	public List<NotificationTermContributor>
		getNotificationTermContributorsByNotificationTermContributorKey(
			String key) {

		return _getNotificationTermContributors(
			key, _serviceTrackerMapByNotificationTermContributorKey);
	}

	@Override
	public List<NotificationTermContributor>
		getNotificationTermContributorsByNotificationTypeKey(String key) {

		return _getNotificationTermContributors(
			key, _serviceTrackerMapByNotificationTypeKey);
	}

	@Activate
	protected void activate(BundleContext bundleContext) {
		_serviceTrackerMapByNotificationTermContributorKey =
			ServiceTrackerMapFactory.openMultiValueMap(
				bundleContext, NotificationTermContributor.class,
				"notification.term.contributor.key",
				ServiceTrackerCustomizerFactory.
					<NotificationTermContributor>serviceWrapper(bundleContext));
		_serviceTrackerMapByNotificationTypeKey =
			ServiceTrackerMapFactory.openMultiValueMap(
				bundleContext, NotificationTermContributor.class,
				"notification.type.key",
				ServiceTrackerCustomizerFactory.
					<NotificationTermContributor>serviceWrapper(bundleContext));
	}

	@Deactivate
	protected void deactivate() {
		_serviceTrackerMapByNotificationTermContributorKey.close();

		_serviceTrackerMapByNotificationTypeKey.close();
	}

	private List<NotificationTermContributor> _getNotificationTermContributors(
		String key,
		ServiceTrackerMap
			<String,
			 List
				 <ServiceTrackerCustomizerFactory.ServiceWrapper
					 <NotificationTermContributor>>> serviceTrackerMap) {

		List
			<ServiceTrackerCustomizerFactory.ServiceWrapper
				<NotificationTermContributor>>
					notificationTermContributorWrappers =
						serviceTrackerMap.getService(key);

		if (notificationTermContributorWrappers == null) {
			return Collections.emptyList();
		}

		List<NotificationTermContributor> notificationTermContributors =
			new ArrayList<>();

		for (ServiceTrackerCustomizerFactory.ServiceWrapper
				<NotificationTermContributor>
					tableActionProviderServiceWrapper :
						notificationTermContributorWrappers) {

			notificationTermContributors.add(
				tableActionProviderServiceWrapper.getService());
		}

		return notificationTermContributors;
	}

	private ServiceTrackerMap
		<String,
		 List
			 <ServiceTrackerCustomizerFactory.ServiceWrapper
				 <NotificationTermContributor>>>
					_serviceTrackerMapByNotificationTermContributorKey;
	private ServiceTrackerMap
		<String,
		 List
			 <ServiceTrackerCustomizerFactory.ServiceWrapper
				 <NotificationTermContributor>>>
					_serviceTrackerMapByNotificationTypeKey;

}