/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.notification.internal.security.permission.resource;

import com.liferay.notification.constants.NotificationConstants;
import com.liferay.notification.model.NotificationQueueEntry;
import com.liferay.notification.service.NotificationQueueEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Paulo Albuquerque
 */
@Component(
	immediate = true,
	property = "model.class.name=com.liferay.notification.model.NotificationQueueEntry",
	service = ModelResourcePermission.class
)
public class NotificationQueueEntryModelResourcePermission
	implements ModelResourcePermission<NotificationQueueEntry> {

	@Override
	public void check(
			PermissionChecker permissionChecker, long notificationQueueEntryId,
			String actionId)
		throws PortalException {

		if (!contains(permissionChecker, notificationQueueEntryId, actionId)) {
			throw new PrincipalException.MustHavePermission(
				permissionChecker, NotificationQueueEntry.class.getName(),
				notificationQueueEntryId, actionId);
		}
	}

	@Override
	public void check(
			PermissionChecker permissionChecker,
			NotificationQueueEntry notificationQueueEntry, String actionId)
		throws PortalException {

		if (!contains(permissionChecker, notificationQueueEntry, actionId)) {
			throw new PrincipalException.MustHavePermission(
				permissionChecker, NotificationQueueEntry.class.getName(),
				notificationQueueEntry.getPrimaryKey(), actionId);
		}
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker, long notificationQueueEntryId,
			String actionId)
		throws PortalException {

		return contains(
			permissionChecker,
			_notificationQueueEntryLocalService.getNotificationQueueEntry(
				notificationQueueEntryId),
			actionId);
	}

	@Override
	public boolean contains(
			PermissionChecker permissionChecker,
			NotificationQueueEntry notificationQueueEntry, String actionId)
		throws PortalException {

		if (permissionChecker.hasOwnerPermission(
				permissionChecker.getCompanyId(),
				NotificationQueueEntry.class.getName(),
				notificationQueueEntry.getNotificationQueueEntryId(),
				notificationQueueEntry.getUserId(), actionId) ||
			permissionChecker.hasPermission(
				null, NotificationQueueEntry.class.getName(),
				notificationQueueEntry.getPrimaryKey(), actionId)) {

			return true;
		}

		return false;
	}

	@Override
	public String getModelName() {
		return NotificationQueueEntry.class.getName();
	}

	@Override
	public PortletResourcePermission getPortletResourcePermission() {
		return _portletResourcePermission;
	}

	@Reference
	private NotificationQueueEntryLocalService
		_notificationQueueEntryLocalService;

	@Reference(
		target = "(resource.name=" + NotificationConstants.RESOURCE_NAME + ")"
	)
	private PortletResourcePermission _portletResourcePermission;

}