/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.multi.factor.authentication.fido2.credential.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.multi.factor.authentication.fido2.credential.model.MFAFIDO2CredentialEntry;
import com.liferay.multi.factor.authentication.fido2.credential.model.MFAFIDO2CredentialEntryModel;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.Serializable;

import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the MFAFIDO2CredentialEntry service. Represents a row in the &quot;MFAFIDO2CredentialEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>MFAFIDO2CredentialEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link MFAFIDO2CredentialEntryImpl}.
 * </p>
 *
 * @author Arthur Chan
 * @see MFAFIDO2CredentialEntryImpl
 * @generated
 */
public class MFAFIDO2CredentialEntryModelImpl
	extends BaseModelImpl<MFAFIDO2CredentialEntry>
	implements MFAFIDO2CredentialEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a mfafido2 credential entry model instance should use the <code>MFAFIDO2CredentialEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "MFAFIDO2CredentialEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT},
		{"mfaFIDO2CredentialEntryId", Types.BIGINT},
		{"companyId", Types.BIGINT}, {"userId", Types.BIGINT},
		{"userName", Types.VARCHAR}, {"createDate", Types.TIMESTAMP},
		{"modifiedDate", Types.TIMESTAMP}, {"credentialKey", Types.CLOB},
		{"credentialKeyHash", Types.BIGINT}, {"credentialType", Types.INTEGER},
		{"failedAttempts", Types.INTEGER}, {"publicKeyCOSE", Types.VARCHAR},
		{"signatureCount", Types.BIGINT}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("mfaFIDO2CredentialEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("credentialKey", Types.CLOB);
		TABLE_COLUMNS_MAP.put("credentialKeyHash", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("credentialType", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("failedAttempts", Types.INTEGER);
		TABLE_COLUMNS_MAP.put("publicKeyCOSE", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("signatureCount", Types.BIGINT);
	}

	public static final String TABLE_SQL_CREATE =
		"create table MFAFIDO2CredentialEntry (mvccVersion LONG default 0 not null,mfaFIDO2CredentialEntryId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,credentialKey TEXT null,credentialKeyHash LONG,credentialType INTEGER,failedAttempts INTEGER,publicKeyCOSE VARCHAR(128) null,signatureCount LONG)";

	public static final String TABLE_SQL_DROP =
		"drop table MFAFIDO2CredentialEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY mfafido2CredentialEntry.mfaFIDO2CredentialEntryId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY MFAFIDO2CredentialEntry.mfaFIDO2CredentialEntryId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long CREDENTIALKEYHASH_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long USERID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long MFAFIDO2CREDENTIALENTRYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	public MFAFIDO2CredentialEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _mfaFIDO2CredentialEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setMfaFIDO2CredentialEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _mfaFIDO2CredentialEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return MFAFIDO2CredentialEntry.class;
	}

	@Override
	public String getModelClassName() {
		return MFAFIDO2CredentialEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<MFAFIDO2CredentialEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<MFAFIDO2CredentialEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MFAFIDO2CredentialEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((MFAFIDO2CredentialEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<MFAFIDO2CredentialEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<MFAFIDO2CredentialEntry, Object>
				attributeSetterBiConsumer = attributeSetterBiConsumers.get(
					attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(MFAFIDO2CredentialEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<MFAFIDO2CredentialEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<MFAFIDO2CredentialEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static final Map<String, Function<MFAFIDO2CredentialEntry, Object>>
		_attributeGetterFunctions;
	private static final Map
		<String, BiConsumer<MFAFIDO2CredentialEntry, Object>>
			_attributeSetterBiConsumers;

	static {
		Map<String, Function<MFAFIDO2CredentialEntry, Object>>
			attributeGetterFunctions =
				new LinkedHashMap
					<String, Function<MFAFIDO2CredentialEntry, Object>>();
		Map<String, BiConsumer<MFAFIDO2CredentialEntry, ?>>
			attributeSetterBiConsumers =
				new LinkedHashMap
					<String, BiConsumer<MFAFIDO2CredentialEntry, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", MFAFIDO2CredentialEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<MFAFIDO2CredentialEntry, Long>)
				MFAFIDO2CredentialEntry::setMvccVersion);
		attributeGetterFunctions.put(
			"mfaFIDO2CredentialEntryId",
			MFAFIDO2CredentialEntry::getMfaFIDO2CredentialEntryId);
		attributeSetterBiConsumers.put(
			"mfaFIDO2CredentialEntryId",
			(BiConsumer<MFAFIDO2CredentialEntry, Long>)
				MFAFIDO2CredentialEntry::setMfaFIDO2CredentialEntryId);
		attributeGetterFunctions.put(
			"companyId", MFAFIDO2CredentialEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<MFAFIDO2CredentialEntry, Long>)
				MFAFIDO2CredentialEntry::setCompanyId);
		attributeGetterFunctions.put(
			"userId", MFAFIDO2CredentialEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<MFAFIDO2CredentialEntry, Long>)
				MFAFIDO2CredentialEntry::setUserId);
		attributeGetterFunctions.put(
			"userName", MFAFIDO2CredentialEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<MFAFIDO2CredentialEntry, String>)
				MFAFIDO2CredentialEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", MFAFIDO2CredentialEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<MFAFIDO2CredentialEntry, Date>)
				MFAFIDO2CredentialEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", MFAFIDO2CredentialEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<MFAFIDO2CredentialEntry, Date>)
				MFAFIDO2CredentialEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"credentialKey", MFAFIDO2CredentialEntry::getCredentialKey);
		attributeSetterBiConsumers.put(
			"credentialKey",
			(BiConsumer<MFAFIDO2CredentialEntry, String>)
				MFAFIDO2CredentialEntry::setCredentialKey);
		attributeGetterFunctions.put(
			"credentialKeyHash", MFAFIDO2CredentialEntry::getCredentialKeyHash);
		attributeSetterBiConsumers.put(
			"credentialKeyHash",
			(BiConsumer<MFAFIDO2CredentialEntry, Long>)
				MFAFIDO2CredentialEntry::setCredentialKeyHash);
		attributeGetterFunctions.put(
			"credentialType", MFAFIDO2CredentialEntry::getCredentialType);
		attributeSetterBiConsumers.put(
			"credentialType",
			(BiConsumer<MFAFIDO2CredentialEntry, Integer>)
				MFAFIDO2CredentialEntry::setCredentialType);
		attributeGetterFunctions.put(
			"failedAttempts", MFAFIDO2CredentialEntry::getFailedAttempts);
		attributeSetterBiConsumers.put(
			"failedAttempts",
			(BiConsumer<MFAFIDO2CredentialEntry, Integer>)
				MFAFIDO2CredentialEntry::setFailedAttempts);
		attributeGetterFunctions.put(
			"publicKeyCOSE", MFAFIDO2CredentialEntry::getPublicKeyCOSE);
		attributeSetterBiConsumers.put(
			"publicKeyCOSE",
			(BiConsumer<MFAFIDO2CredentialEntry, String>)
				MFAFIDO2CredentialEntry::setPublicKeyCOSE);
		attributeGetterFunctions.put(
			"signatureCount", MFAFIDO2CredentialEntry::getSignatureCount);
		attributeSetterBiConsumers.put(
			"signatureCount",
			(BiConsumer<MFAFIDO2CredentialEntry, Long>)
				MFAFIDO2CredentialEntry::setSignatureCount);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@Override
	public long getMfaFIDO2CredentialEntryId() {
		return _mfaFIDO2CredentialEntryId;
	}

	@Override
	public void setMfaFIDO2CredentialEntryId(long mfaFIDO2CredentialEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mfaFIDO2CredentialEntryId = mfaFIDO2CredentialEntryId;
	}

	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalUserId() {
		return GetterUtil.getLong(this.<Long>getColumnOriginalValue("userId"));
	}

	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@Override
	public String getCredentialKey() {
		if (_credentialKey == null) {
			return "";
		}
		else {
			return _credentialKey;
		}
	}

	@Override
	public void setCredentialKey(String credentialKey) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_credentialKey = credentialKey;
	}

	@Override
	public long getCredentialKeyHash() {
		return _credentialKeyHash;
	}

	@Override
	public void setCredentialKeyHash(long credentialKeyHash) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_credentialKeyHash = credentialKeyHash;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCredentialKeyHash() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("credentialKeyHash"));
	}

	@Override
	public int getCredentialType() {
		return _credentialType;
	}

	@Override
	public void setCredentialType(int credentialType) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_credentialType = credentialType;
	}

	@Override
	public int getFailedAttempts() {
		return _failedAttempts;
	}

	@Override
	public void setFailedAttempts(int failedAttempts) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_failedAttempts = failedAttempts;
	}

	@Override
	public String getPublicKeyCOSE() {
		if (_publicKeyCOSE == null) {
			return "";
		}
		else {
			return _publicKeyCOSE;
		}
	}

	@Override
	public void setPublicKeyCOSE(String publicKeyCOSE) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_publicKeyCOSE = publicKeyCOSE;
	}

	@Override
	public long getSignatureCount() {
		return _signatureCount;
	}

	@Override
	public void setSignatureCount(long signatureCount) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_signatureCount = signatureCount;
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), MFAFIDO2CredentialEntry.class.getName(),
			getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public MFAFIDO2CredentialEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, MFAFIDO2CredentialEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		MFAFIDO2CredentialEntryImpl mfaFIDO2CredentialEntryImpl =
			new MFAFIDO2CredentialEntryImpl();

		mfaFIDO2CredentialEntryImpl.setMvccVersion(getMvccVersion());
		mfaFIDO2CredentialEntryImpl.setMfaFIDO2CredentialEntryId(
			getMfaFIDO2CredentialEntryId());
		mfaFIDO2CredentialEntryImpl.setCompanyId(getCompanyId());
		mfaFIDO2CredentialEntryImpl.setUserId(getUserId());
		mfaFIDO2CredentialEntryImpl.setUserName(getUserName());
		mfaFIDO2CredentialEntryImpl.setCreateDate(getCreateDate());
		mfaFIDO2CredentialEntryImpl.setModifiedDate(getModifiedDate());
		mfaFIDO2CredentialEntryImpl.setCredentialKey(getCredentialKey());
		mfaFIDO2CredentialEntryImpl.setCredentialKeyHash(
			getCredentialKeyHash());
		mfaFIDO2CredentialEntryImpl.setCredentialType(getCredentialType());
		mfaFIDO2CredentialEntryImpl.setFailedAttempts(getFailedAttempts());
		mfaFIDO2CredentialEntryImpl.setPublicKeyCOSE(getPublicKeyCOSE());
		mfaFIDO2CredentialEntryImpl.setSignatureCount(getSignatureCount());

		mfaFIDO2CredentialEntryImpl.resetOriginalValues();

		return mfaFIDO2CredentialEntryImpl;
	}

	@Override
	public MFAFIDO2CredentialEntry cloneWithOriginalValues() {
		MFAFIDO2CredentialEntryImpl mfaFIDO2CredentialEntryImpl =
			new MFAFIDO2CredentialEntryImpl();

		mfaFIDO2CredentialEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		mfaFIDO2CredentialEntryImpl.setMfaFIDO2CredentialEntryId(
			this.<Long>getColumnOriginalValue("mfaFIDO2CredentialEntryId"));
		mfaFIDO2CredentialEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		mfaFIDO2CredentialEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		mfaFIDO2CredentialEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		mfaFIDO2CredentialEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		mfaFIDO2CredentialEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		mfaFIDO2CredentialEntryImpl.setCredentialKey(
			this.<String>getColumnOriginalValue("credentialKey"));
		mfaFIDO2CredentialEntryImpl.setCredentialKeyHash(
			this.<Long>getColumnOriginalValue("credentialKeyHash"));
		mfaFIDO2CredentialEntryImpl.setCredentialType(
			this.<Integer>getColumnOriginalValue("credentialType"));
		mfaFIDO2CredentialEntryImpl.setFailedAttempts(
			this.<Integer>getColumnOriginalValue("failedAttempts"));
		mfaFIDO2CredentialEntryImpl.setPublicKeyCOSE(
			this.<String>getColumnOriginalValue("publicKeyCOSE"));
		mfaFIDO2CredentialEntryImpl.setSignatureCount(
			this.<Long>getColumnOriginalValue("signatureCount"));

		return mfaFIDO2CredentialEntryImpl;
	}

	@Override
	public int compareTo(MFAFIDO2CredentialEntry mfaFIDO2CredentialEntry) {
		long primaryKey = mfaFIDO2CredentialEntry.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof MFAFIDO2CredentialEntry)) {
			return false;
		}

		MFAFIDO2CredentialEntry mfaFIDO2CredentialEntry =
			(MFAFIDO2CredentialEntry)object;

		long primaryKey = mfaFIDO2CredentialEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<MFAFIDO2CredentialEntry> toCacheModel() {
		MFAFIDO2CredentialEntryCacheModel mfaFIDO2CredentialEntryCacheModel =
			new MFAFIDO2CredentialEntryCacheModel();

		mfaFIDO2CredentialEntryCacheModel.mvccVersion = getMvccVersion();

		mfaFIDO2CredentialEntryCacheModel.mfaFIDO2CredentialEntryId =
			getMfaFIDO2CredentialEntryId();

		mfaFIDO2CredentialEntryCacheModel.companyId = getCompanyId();

		mfaFIDO2CredentialEntryCacheModel.userId = getUserId();

		mfaFIDO2CredentialEntryCacheModel.userName = getUserName();

		String userName = mfaFIDO2CredentialEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			mfaFIDO2CredentialEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			mfaFIDO2CredentialEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			mfaFIDO2CredentialEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			mfaFIDO2CredentialEntryCacheModel.modifiedDate =
				modifiedDate.getTime();
		}
		else {
			mfaFIDO2CredentialEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		mfaFIDO2CredentialEntryCacheModel.credentialKey = getCredentialKey();

		String credentialKey = mfaFIDO2CredentialEntryCacheModel.credentialKey;

		if ((credentialKey != null) && (credentialKey.length() == 0)) {
			mfaFIDO2CredentialEntryCacheModel.credentialKey = null;
		}

		mfaFIDO2CredentialEntryCacheModel.credentialKeyHash =
			getCredentialKeyHash();

		mfaFIDO2CredentialEntryCacheModel.credentialType = getCredentialType();

		mfaFIDO2CredentialEntryCacheModel.failedAttempts = getFailedAttempts();

		mfaFIDO2CredentialEntryCacheModel.publicKeyCOSE = getPublicKeyCOSE();

		String publicKeyCOSE = mfaFIDO2CredentialEntryCacheModel.publicKeyCOSE;

		if ((publicKeyCOSE != null) && (publicKeyCOSE.length() == 0)) {
			mfaFIDO2CredentialEntryCacheModel.publicKeyCOSE = null;
		}

		mfaFIDO2CredentialEntryCacheModel.signatureCount = getSignatureCount();

		return mfaFIDO2CredentialEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<MFAFIDO2CredentialEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<MFAFIDO2CredentialEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MFAFIDO2CredentialEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply(
				(MFAFIDO2CredentialEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<MFAFIDO2CredentialEntry, Object>>
			attributeGetterFunctions = getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<MFAFIDO2CredentialEntry, Object>>
				entry : attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<MFAFIDO2CredentialEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(
				attributeGetterFunction.apply((MFAFIDO2CredentialEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function
			<InvocationHandler, MFAFIDO2CredentialEntry>
				_escapedModelProxyProviderFunction =
					ProxyUtil.getProxyProviderFunction(
						MFAFIDO2CredentialEntry.class, ModelWrapper.class);

	}

	private long _mvccVersion;
	private long _mfaFIDO2CredentialEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _credentialKey;
	private long _credentialKeyHash;
	private int _credentialType;
	private int _failedAttempts;
	private String _publicKeyCOSE;
	private long _signatureCount;

	public <T> T getColumnValue(String columnName) {
		Function<MFAFIDO2CredentialEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((MFAFIDO2CredentialEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put(
			"mfaFIDO2CredentialEntryId", _mfaFIDO2CredentialEntryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put("credentialKey", _credentialKey);
		_columnOriginalValues.put("credentialKeyHash", _credentialKeyHash);
		_columnOriginalValues.put("credentialType", _credentialType);
		_columnOriginalValues.put("failedAttempts", _failedAttempts);
		_columnOriginalValues.put("publicKeyCOSE", _publicKeyCOSE);
		_columnOriginalValues.put("signatureCount", _signatureCount);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("mfaFIDO2CredentialEntryId", 2L);

		columnBitmasks.put("companyId", 4L);

		columnBitmasks.put("userId", 8L);

		columnBitmasks.put("userName", 16L);

		columnBitmasks.put("createDate", 32L);

		columnBitmasks.put("modifiedDate", 64L);

		columnBitmasks.put("credentialKey", 128L);

		columnBitmasks.put("credentialKeyHash", 256L);

		columnBitmasks.put("credentialType", 512L);

		columnBitmasks.put("failedAttempts", 1024L);

		columnBitmasks.put("publicKeyCOSE", 2048L);

		columnBitmasks.put("signatureCount", 4096L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private MFAFIDO2CredentialEntry _escapedModel;

}